/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.plan.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.utils.CommonUtils;

public class PlanNodesTree
extends DatabaseObjectListControl<DBCPlanNode> {
    private String query;
    private DBPDataSource dataSource;
    private static ITreeContentProvider CONTENT_PROVIDER = new ITreeContentProvider(){

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DBCPlanNode) {
                Collection nestedNodes = ((DBCPlanNode)parentElement).getNested();
                return CommonUtils.isEmpty((Collection)nestedNodes) ? new Object[]{} : nestedNodes.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof DBCPlanNode) {
                return ((DBCPlanNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof DBCPlanNode && !CommonUtils.isEmpty((Collection)((DBCPlanNode)element).getNested());
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    public PlanNodesTree(Composite parent, int style, IWorkbenchSite site) {
        super(parent, style, site, (IContentProvider)CONTENT_PROVIDER);
        this.setFitWidth(true);
    }

    protected ObjectViewerRenderer createRenderer() {
        return new PlanTreeRenderer();
    }

    @NotNull
    protected String getListConfigId(List<Class<?>> classList) {
        return "ExecutionPlan/" + this.dataSource.getContainer().getDriver().getId();
    }

    protected LoadingJob<Collection<DBCPlanNode>> createLoadService() {
        return null;
    }

    public void showPlan(DBPDataSource dataSource, DBCPlan plan) {
        this.dataSource = dataSource;
        ArrayList nodes = new ArrayList(plan.getPlanNodes(Collections.singletonMap("keepOriginal", true)));
        TreeViewer itemsViewer = (TreeViewer)this.getItemsViewer();
        itemsViewer.getControl().setRedraw(false);
        try {
            this.clearListData();
            this.setListData(nodes, false);
            itemsViewer.expandToLevel(10);
        }
        finally {
            itemsViewer.getControl().setRedraw(true);
        }
    }

    private class PlanTreeRenderer
    extends ObjectListControl.ViewerRenderer {
        private PlanTreeRenderer() {
            super((ObjectListControl)PlanNodesTree.this);
        }

        public boolean isHyperlink(Object cellValue) {
            return cellValue instanceof DBSObject;
        }

        public void navigateHyperlink(Object cellValue) {
            if (cellValue instanceof DBSObject) {
                NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)((DBSObject)cellValue));
            }
        }
    }
}

