/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.security;

import java.sql.ResultSet;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConnection;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolConnectionGrant
implements DBAPrivilege {
    private Boolean adminOption;
    private String connection;
    private ExasolDataSource dataSource;
    private String grantee;
    private Boolean isPersisted;

    public ExasolConnectionGrant(ExasolDataSource dataSource, ResultSet dbResult) {
        this.adminOption = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"ADMIN_OPTION");
        this.connection = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONNECTION_NAME");
        this.grantee = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"GRANTEE");
        this.dataSource = dataSource;
        this.isPersisted = true;
    }

    @Property(viewable=true, order=10)
    public ExasolConnection getConnection() throws DBException {
        return this.dataSource.getConnection((DBRProgressMonitor)new VoidProgressMonitor(), this.connection);
    }

    @Property(viewable=true, order=90)
    public Boolean getAdminOption() {
        return this.adminOption;
    }

    @Property(hidden=true, multiline=true)
    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public String getName() {
        return this.grantee;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    public Object getGrantee() {
        return String.valueOf(this.grantee) + "|" + this.connection + "|" + this.adminOption.toString();
    }
}

