/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskProcessorUI;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.DataTransferState;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.task.DTTaskHandlerTransfer;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIActivator;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferConfiguratorRegistry;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferNodeConfiguratorDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageType;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferPageFinal;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferPagePipes;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferPageSettings;
import org.jkiss.dbeaver.ui.DialogSettingsMap;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferWizard
extends TaskConfigurationWizard<DataTransferSettings>
implements IExportWizard,
IImportWizard {
    private static final String RS_EXPORT_WIZARD_DIALOG_SETTINGS = "DataTransfer";
    private static final Log log = Log.getLog(DataTransferWizard.class);
    private DataTransferSettings settings;
    private final Map<Class<?>, NodePageSettings> nodeSettings = new LinkedHashMap();

    private DataTransferWizard(@Nullable DBTTask task) {
        super(task);
        this.setDialogSettings(DataTransferWizard.getWizardDialogSettings());
    }

    public DataTransferWizard(@Nullable DBTTask task, @NotNull DataTransferSettings settings, boolean initTaskVariables) {
        this(task);
        this.settings = settings;
        this.loadSettings();
        if (initTaskVariables && settings.getInitProducers() != null) {
            IDataTransferProducer[] iDataTransferProducerArray = settings.getInitProducers();
            int n = iDataTransferProducerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDataTransferProducer producer = iDataTransferProducerArray[n2];
                if (producer instanceof DatabaseTransferProducer) {
                    Map queryParameters;
                    DBSObject databaseObject = producer.getDatabaseObject();
                    if (databaseObject instanceof SQLQueryContainer && !CommonUtils.isEmpty((Map)(queryParameters = ((SQLQueryContainer)databaseObject).getQueryParameters()))) {
                        this.getTaskVariables().putAll(queryParameters);
                    }
                    if (databaseObject instanceof DBPContextProvider) {
                        this.saveTaskContext(((DBPContextProvider)databaseObject).getExecutionContext());
                    }
                }
                ++n2;
            }
        }
    }

    @NotNull
    public static IDialogSettings getWizardDialogSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)DTUIActivator.getDefault().getDialogSettings(), (String)RS_EXPORT_WIZARD_DIALOG_SETTINGS);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.settings.getState().hasErrors()) {
            List loadErrors = this.settings.getState().getLoadErrors();
            if (loadErrors.size() == 1) {
                DBWorkbench.getPlatformUI().showError("Error loading configuration", "Error loading data transfer configuration", (Throwable)loadErrors.get(0));
            } else {
                ArrayList<IStatus> childStatuses = new ArrayList<IStatus>();
                for (Throwable error : loadErrors) {
                    childStatuses.add(GeneralUtils.makeExceptionStatus((Throwable)error));
                }
                MultiStatus status = new MultiStatus("org.jkiss.dbeaver.data.transfer", 0, childStatuses.toArray(new IStatus[0]), "Multiple configuration errors", null);
                DBWorkbench.getPlatformUI().showError("Error loading configuration", status.getMessage(), (IStatus)status);
            }
        }
    }

    void loadSettings() {
        boolean settingsChanged;
        DataTransferNodeDescriptor node;
        int n;
        int n2;
        IDataTransferProducer[] iDataTransferProducerArray;
        List objectTypes = this.settings.getSourceObjects();
        ArrayList<DataTransferNodeDescriptor> nodes = new ArrayList<DataTransferNodeDescriptor>();
        DataTransferRegistry registry = DataTransferRegistry.getInstance();
        if (ArrayUtils.isEmpty((Object[])this.settings.getInitProducers())) {
            nodes.addAll(registry.getAvailableProducers((Collection)objectTypes));
        } else {
            iDataTransferProducerArray = this.settings.getInitProducers();
            n2 = iDataTransferProducerArray.length;
            n = 0;
            while (n < n2) {
                IDataTransferProducer source = iDataTransferProducerArray[n];
                node = registry.getNodeByType(source.getClass());
                if (node != null && !nodes.contains(node)) {
                    nodes.add(node);
                }
                ++n;
            }
        }
        if (ArrayUtils.isEmpty((Object[])this.settings.getInitConsumers())) {
            nodes.addAll(registry.getAvailableConsumers((Collection)objectTypes));
        } else {
            iDataTransferProducerArray = this.settings.getInitConsumers();
            n2 = iDataTransferProducerArray.length;
            n = 0;
            while (n < n2) {
                IDataTransferProducer target = iDataTransferProducerArray[n];
                node = registry.getNodeByType(target.getClass());
                if (node != null && !nodes.contains(node)) {
                    nodes.add(node);
                }
                ++n;
            }
        }
        boolean bl = settingsChanged = this.nodeSettings.size() != nodes.size();
        if (!settingsChanged) {
            ArrayList<NodePageSettings> nsList = new ArrayList<NodePageSettings>(this.nodeSettings.values());
            int i = 0;
            while (i < this.nodeSettings.size()) {
                if (((NodePageSettings)nsList.get((int)i)).sourceNode != nodes.get(i)) {
                    settingsChanged = true;
                    break;
                }
                ++i;
            }
        }
        if (settingsChanged) {
            this.nodeSettings.clear();
            for (DataTransferNodeDescriptor node2 : nodes) {
                this.addNodeSettings(node2);
            }
        }
        this.updateWizardTitle();
    }

    public String getTaskTypeId() {
        if (this.getSettings().isProducerOptional()) {
            return "dataImport";
        }
        return "dataExport";
    }

    public DataTransferSettings getSettings() {
        return this.settings;
    }

    public <T extends IDataTransferSettings> T getPageSettings(IWizardPage page, Class<T> type) {
        return (T)((IDataTransferSettings)type.cast(this.getNodeSettings(page)));
    }

    public void addPages() {
        super.addPages();
        if ((!this.isTaskEditor() || this.isNewTaskEditor()) && (this.settings.isConsumerOptional() || this.settings.isProducerOptional())) {
            this.addPage((IWizardPage)new DataTransferPagePipes());
        }
        this.addWizardPages(this);
        this.addPage((IWizardPage)new DataTransferPageFinal());
    }

    protected String getDefaultWindowTitle() {
        return DTUIMessages.data_transfer_wizard_name;
    }

    @Nullable
    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int curIndex = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                curIndex = i;
                break;
            }
            ++i;
        }
        if (curIndex == pages.length - 1) {
            return null;
        }
        if (curIndex != -1) {
            i = curIndex + 1;
            while (i < pages.length) {
                if (this.isPageValid(pages[i])) {
                    return pages[i];
                }
                ++i;
            }
        }
        return pages[pages.length - 1];
    }

    @Nullable
    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int curIndex = -1;
        int i = 0;
        while (i < pages.length) {
            if (pages[i] == page) {
                curIndex = i;
                break;
            }
            ++i;
        }
        if (curIndex == 0) {
            return null;
        }
        if (curIndex != -1) {
            i = curIndex - 1;
            while (i > 0) {
                if (this.isPageValid(pages[i])) {
                    return pages[i];
                }
                --i;
            }
        }
        return pages[0];
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean performFinish() {
        this.saveDialogSettings();
        if (!super.performFinish()) {
            return false;
        }
        try {
            DBTTask currentTask = this.getCurrentTask();
            if (currentTask == null) {
                DataTransferWizardExecutor executor = new DataTransferWizardExecutor(this.getRunnableContext(), DTMessages.data_transfer_wizard_job_name, this.getSettings());
                executor.executeTask();
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError(e.getMessage(), DTUIMessages.data_transfer_wizard_message_init_data_transfer, (Throwable)e);
            return false;
        }
        return true;
    }

    private void saveDialogSettings() {
        DialogSettingsMap dialogSettings = new DialogSettingsMap(this.getDialogSettings());
        this.saveConfiguration((Map<String, Object>)dialogSettings);
        DTUIActivator.getDefault().saveDialogSettings();
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
    }

    private void addNodeSettings(DataTransferNodeDescriptor node) {
        if (node == null) {
            return;
        }
        Class nodeClass = node.getNodeClass();
        if (this.nodeSettings.containsKey(nodeClass)) {
            return;
        }
        DataTransferNodeConfiguratorDescriptor configurator = DataTransferConfiguratorRegistry.getInstance().getConfigurator(node.getId());
        NodePageSettings newNodeSettings = new NodePageSettings(this.getPages(), node, configurator, this.settings.isConsumerOptional(), this.settings.isProducerOptional());
        this.nodeSettings.put(nodeClass, newNodeSettings);
    }

    private void addWizardPages(DataTransferWizard wizard) {
        IWizardPage page;
        int n;
        int n2;
        IWizardPage[] iWizardPageArray;
        ArrayList<IWizardPage> settingPages = new ArrayList<IWizardPage>();
        for (NodePageSettings nodePageSettings : this.nodeSettings.values()) {
            iWizardPageArray = nodePageSettings.pages;
            n2 = nodePageSettings.pages.length;
            n = 0;
            while (n < n2) {
                page = iWizardPageArray[n];
                if (nodePageSettings.nodeConfigurator != null && nodePageSettings.nodeConfigurator.getPageDescriptor(page).getPageType() != DataTransferPageType.PREVIEW) {
                    wizard.addPage(page);
                }
                ++n;
            }
            if (nodePageSettings.settingsPage == null) continue;
            settingPages.add(nodePageSettings.settingsPage);
        }
        if (!CommonUtils.isEmpty(settingPages)) {
            wizard.addPage((IWizardPage)new DataTransferPageSettings());
        }
        for (NodePageSettings nodePageSettings : this.nodeSettings.values()) {
            iWizardPageArray = nodePageSettings.pages;
            n2 = nodePageSettings.pages.length;
            n = 0;
            while (n < n2) {
                page = iWizardPageArray[n];
                if (nodePageSettings.nodeConfigurator != null && nodePageSettings.nodeConfigurator.getPageDescriptor(page).getPageType() == DataTransferPageType.PREVIEW) {
                    wizard.addPage(page);
                }
                ++n;
            }
        }
    }

    protected boolean isPageValid(IWizardPage page) {
        return this.isTaskConfigPage(page) || page instanceof DataTransferPagePipes || page instanceof DataTransferPageSettings || page instanceof DataTransferPageFinal || this.isPageValid(page, this.settings.getProducer()) || this.isPageValid(page, this.settings.getConsumer());
    }

    private boolean isPageValid(IWizardPage page, DataTransferNodeDescriptor node) {
        NodePageSettings nodePageSettings;
        NodePageSettings nodePageSettings2 = nodePageSettings = node == null ? null : this.nodeSettings.get(node.getNodeClass());
        if (nodePageSettings != null && ArrayUtils.contains((Object[])nodePageSettings.pages, (Object)page)) {
            for (NodePageSettings ns : this.nodeSettings.values()) {
                DataTransferPageDescriptor pd;
                DataTransferPageDescriptor dataTransferPageDescriptor = pd = ns.nodeConfigurator == null ? null : ns.nodeConfigurator.getPageDescriptor(page);
                if (pd == null) continue;
                if (pd.getProducerType() != null && this.settings.getProducer() != null && !this.settings.getProducer().getId().equals(pd.getProducerType())) {
                    return false;
                }
                if (pd.getConsumerType() == null || this.settings.getConsumer() == null || this.settings.getConsumer().getId().equals(pd.getConsumerType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    NodePageSettings getNodeInfo(IDataTransferNode<?> node) {
        return this.nodeSettings.get(node.getClass());
    }

    private IDataTransferSettings getNodeSettings(IWizardPage page) {
        for (NodePageSettings nodePageSettings : this.nodeSettings.values()) {
            if (page == nodePageSettings.settingsPage) {
                return this.settings.getNodeSettings(nodePageSettings.sourceNode);
            }
            if (nodePageSettings.pages == null) continue;
            IWizardPage[] iWizardPageArray = nodePageSettings.pages;
            int n = nodePageSettings.pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage nodePage = iWizardPageArray[n2];
                if (nodePage == page) {
                    return this.settings.getNodeSettings(nodePageSettings.sourceNode);
                }
                ++n2;
            }
        }
        return null;
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        ArrayList<IDataTransferProducer> producers = new ArrayList<IDataTransferProducer>();
        ArrayList<IDataTransferConsumer> consumers = new ArrayList<IDataTransferConsumer>();
        for (DataTransferPipe pipe : this.settings.getDataPipes()) {
            if (pipe.getProducer() != null) {
                producers.add(pipe.getProducer());
            }
            if (pipe.getConsumer() == null) continue;
            consumers.add(pipe.getConsumer());
        }
        DataTransferSettings.saveNodesLocation((DBRRunnableContext)runnableContext, (DBTTask)task, state, producers, (String)"producers");
        DataTransferSettings.saveNodesLocation((DBRRunnableContext)runnableContext, (DBTTask)task, state, consumers, (String)"consumers");
        state.put("configuration", this.saveConfiguration(new LinkedHashMap<String, Object>()));
    }

    private Map<String, Object> saveConfiguration(Map<String, Object> config) {
        config.put("maxJobCount", this.settings.getMaxJobCount());
        config.put("showFinalMessage", this.settings.isShowFinalMessage());
        boolean isTask = this.getCurrentTask() != null;
        for (Map.Entry<Class<?>, NodePageSettings> entry : this.nodeSettings.entrySet()) {
            NodePageSettings nodePageSettings = entry.getValue();
            if (isTask && (nodePageSettings.sourceNode.getNodeType() == DataTransferNodeDescriptor.NodeType.PRODUCER && this.settings.getProducer() != null && !this.settings.getProducer().getId().equals(nodePageSettings.sourceNode.getId()) || nodePageSettings.sourceNode.getNodeType() == DataTransferNodeDescriptor.NodeType.CONSUMER && this.settings.getConsumer() != null && !this.settings.getConsumer().getId().equals(nodePageSettings.sourceNode.getId()))) continue;
            LinkedHashMap nodeSection = new LinkedHashMap();
            IDataTransferSettings settings = this.settings.getNodeSettings(nodePageSettings.sourceNode);
            if (settings != null) {
                settings.saveSettings(nodeSection);
            }
            config.put(entry.getKey().getSimpleName(), nodeSection);
        }
        if (this.settings.getProducer() != null) {
            config.put("producer", this.settings.getProducer().getId());
        }
        if (this.settings.getConsumer() != null) {
            config.put("consumer", this.settings.getConsumer().getId());
        }
        if (this.settings.getProcessor() != null) {
            config.put("processor", this.settings.getProcessor().getId());
        }
        LinkedHashMap processorsSection = new LinkedHashMap();
        for (DataTransferProcessorDescriptor procDescriptor : this.settings.getProcessorPropsHistory().keySet()) {
            if (isTask && (this.settings.getProcessor() == null || !this.settings.getProcessor().getId().equals(procDescriptor.getId()))) continue;
            LinkedHashMap<String, String> procSettings = new LinkedHashMap<String, String>();
            Map props = (Map)this.settings.getProcessorPropsHistory().get(procDescriptor);
            if (!CommonUtils.isEmpty((Map)props)) {
                StringBuilder propNames = new StringBuilder();
                for (Map.Entry prop : props.entrySet()) {
                    propNames.append((String)prop.getKey()).append(',');
                }
                procSettings.put("@propNames", propNames.toString());
                for (Map.Entry prop : props.entrySet()) {
                    procSettings.put(CommonUtils.toString(prop.getKey()), CommonUtils.toString(prop.getValue()));
                }
            }
            processorsSection.put(procDescriptor.getFullId(), procSettings);
        }
        config.put("processors", processorsSection);
        return config;
    }

    public static void openWizard(@NotNull IWorkbenchWindow workbenchWindow, @Nullable Collection<IDataTransferProducer<?>> producers, @Nullable Collection<IDataTransferConsumer<?, ?>> consumers) {
        DataTransferWizard.openWizard(workbenchWindow, producers, consumers, null);
    }

    public static void openWizard(@NotNull IWorkbenchWindow workbenchWindow, @Nullable Collection<IDataTransferProducer<?>> producers, @Nullable Collection<IDataTransferConsumer<?, ?>> consumers, @Nullable IStructuredSelection selection) {
        DataTransferSettings settings = new DataTransferSettings(producers, consumers, (Map)new DialogSettingsMap(DataTransferWizard.getWizardDialogSettings()), new DataTransferState(), true, CommonUtils.isEmpty(consumers), false);
        DataTransferWizard wizard = new DataTransferWizard(null, settings, true);
        TaskConfigurationWizardDialog dialog = new TaskConfigurationWizardDialog(workbenchWindow, (TaskConfigurationWizard)wizard, selection);
        dialog.open();
    }

    public static DataTransferWizard openWizard(final @NotNull DBTTask task) {
        try {
            DataTransferSettings settings = DataTransferSettings.loadSettings((DBRRunnableWithResult)new DBRRunnableWithResult<DataTransferSettings>(){

                public void run(DBRProgressMonitor monitor) {
                    this.result = new DataTransferSettings(monitor, task, log, (Map)new DialogSettingsMap(DataTransferWizard.getWizardDialogSettings()), new DataTransferState());
                }
            });
            return new DataTransferWizard(task, settings, false);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Data transfer error", "Can not open data transfer wizard", (Throwable)e);
            return null;
        }
    }

    class DataTransferWizardExecutor
    extends TaskProcessorUI {
        private final DataTransferSettings settings;

        DataTransferWizardExecutor(@NotNull DBRRunnableContext staticContext, @NotNull String taskName, DataTransferSettings settings) {
            super(staticContext, DataTransferWizard.this.getProject().getTaskManager().createTemporaryTask(DataTransferWizard.this.getTaskType(), taskName));
            this.settings = settings;
        }

        protected boolean isShowFinalMessage() {
            return this.settings.isShowFinalMessage();
        }

        protected void runTask() throws DBException {
            DTTaskHandlerTransfer handlerTransfer = new DTTaskHandlerTransfer();
            handlerTransfer.executeWithSettings((DBRRunnableContext)this, DataTransferWizard.this.getCurrentTask(), Locale.getDefault(), log, (DBTTaskExecutionListener)this, this.settings);
        }
    }

    static class NodePageSettings {
        DataTransferNodeDescriptor sourceNode;
        DataTransferNodeConfiguratorDescriptor nodeConfigurator;
        IWizardPage[] pages;
        IWizardPage settingsPage;

        private NodePageSettings(IWizardPage[] existingPages, DataTransferNodeDescriptor sourceNode, DataTransferNodeConfiguratorDescriptor nodeConfigurator, boolean consumerOptional, boolean producerOptional) {
            this.sourceNode = sourceNode;
            this.nodeConfigurator = nodeConfigurator;
            this.pages = nodeConfigurator == null ? new IWizardPage[]{} : nodeConfigurator.createWizardPages(existingPages, consumerOptional, producerOptional, false);
            IWizardPage[] sPages = nodeConfigurator == null ? new IWizardPage[]{} : nodeConfigurator.createWizardPages(existingPages, consumerOptional, producerOptional, true);
            this.settingsPage = sPages.length == 0 ? null : sPages[0];
        }

        public String toString() {
            return this.sourceNode.getId();
        }
    }
}

