/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandListener;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAdapter;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.ProxyProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.CustomSelectionProvider;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IErrorVisualizer;
import org.jkiss.dbeaver.ui.IProgressControlProvider;
import org.jkiss.dbeaver.ui.IPropertyChangeReflector;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceToolbarUtils;
import org.jkiss.dbeaver.ui.controls.CustomFormEditor;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderListener;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.ErrorEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IRevertableEditor;
import org.jkiss.dbeaver.ui.editors.MultiPageDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.ProgressEditorPart;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorDescriptor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorPropertyTester;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorsRegistry;
import org.jkiss.dbeaver.ui.editors.entity.ErrorEditorPartEx;
import org.jkiss.dbeaver.ui.editors.entity.GlobalContributorManager;
import org.jkiss.dbeaver.ui.editors.entity.IEntityDataEditor;
import org.jkiss.dbeaver.ui.editors.entity.IEntityEditorContext;
import org.jkiss.dbeaver.ui.editors.entity.IEntityStructureEditor;
import org.jkiss.dbeaver.ui.editors.entity.properties.ObjectPropertiesEditor;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class EntityEditor
extends MultiPageDatabaseEditor
implements IPropertyChangeReflector,
IProgressControlProvider,
ISaveablePart2,
IRevertableEditor,
ITabbedFolderContainer,
IDataSourceContainerProvider,
IEntityEditorContext {
    public static final String ID = "org.jkiss.dbeaver.ui.editors.entity.EntityEditor";
    private static final int PROP_OBJECT_INIT = 530;
    private static final Log log = Log.getLog(EntityEditor.class);
    private static final Map<String, EditorDefaults> defaultPageMap = new HashMap<String, EditorDefaults>();
    private final Map<String, IEditorPart> editorMap = new LinkedHashMap<String, IEditorPart>();
    private IEditorPart activeEditor;
    private DBECommandAdapter commandListener;
    private ITabbedFolderListener folderListener;
    private boolean hasPropertiesEditor;
    private Map<IEditorPart, IEditorActionBarContributor> actionContributors = new HashMap<IEditorPart, IEditorActionBarContributor>();
    private volatile boolean saveInProgress = false;
    private Menu breadcrumbsMenu;
    private ISelectionProvider savedPartSelectionProvider = null;
    private static final int MAX_BREADCRUMBS_MENU_ITEM = 300;

    public EntityEditor() {
        this.folderListener = folderId -> {
            String editorPageId;
            IEditorPart editor = this.getActiveEditor();
            if (editor != null && (editorPageId = this.getEditorPageId(editor)) != null) {
                this.updateEditorDefaults(editorPageId, folderId);
            }
        };
    }

    public void handlePropertyChange(int propId) {
        super.handlePropertyChange(propId);
    }

    @Nullable
    public ProgressPageControl getProgressControl() {
        IEditorPart activeEditor = this.getActiveEditor();
        return activeEditor instanceof IProgressControlProvider ? ((IProgressControlProvider)activeEditor).getProgressControl() : null;
    }

    public DBSObject getDatabaseObject() {
        return this.getEditorInput().getDatabaseObject();
    }

    @Nullable
    public DBECommandContext getCommandContext() {
        return this.getEditorInput().getCommandContext();
    }

    public void dispose() {
        if (this.breadcrumbsMenu != null) {
            this.breadcrumbsMenu.dispose();
            this.breadcrumbsMenu = null;
        }
        for (Map.Entry<IEditorPart, IEditorActionBarContributor> entry : this.actionContributors.entrySet()) {
            GlobalContributorManager.getInstance().removeContributor(entry.getValue(), entry.getKey());
        }
        this.actionContributors.clear();
        DBECommandContext commandContext = this.getCommandContext();
        if (this.commandListener != null && commandContext != null) {
            commandContext.removeCommandListener((DBECommandListener)this.commandListener);
            this.commandListener = null;
        }
        super.dispose();
        if (this.getDatabaseObject() != null && commandContext != null) {
            commandContext.resetChanges(true);
        }
        this.editorMap.clear();
        this.activeEditor = null;
    }

    public boolean isDirty() {
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext != null && commandContext.isDirty()) {
            return true;
        }
        for (IEditorPart editor : this.editorMap.values()) {
            if (!editor.isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return this.activeEditor != null && this.activeEditor.isSaveAsAllowed();
    }

    public void doSaveAs() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null && activeEditor.isSaveAsAllowed()) {
            activeEditor.doSaveAs();
        }
    }

    public boolean isSaveInProgress() {
        return this.saveInProgress;
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        if (EditorUtils.isInAutoSaveJob()) {
            return;
        }
        if (DBUtils.isReadOnly((DBSObject)this.getDatabaseObject())) {
            DBWorkbench.getPlatformUI().showMessageBox("Read-only", "Object [" + DBUtils.getObjectFullName((DBPNamedObject)this.getDatabaseObject(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "] is read-only", true);
            return;
        }
        for (IEditorPart editor : this.editorMap.values()) {
            if ((editor instanceof IEntityStructureEditor || editor instanceof IEntityDataEditor) && editor.isDirty()) {
                editor.doSave(monitor);
            }
            if (!monitor.isCanceled()) continue;
            return;
        }
        int previewResult = 10;
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.editor.show.preview")) {
            monitor.beginTask(UINavigatorMessages.editors_entity_monitor_preview_changes, 1);
            previewResult = this.showChanges(true);
        }
        if (previewResult == 9) {
            this.firePropertyChange(257);
            return;
        }
        if (previewResult != 10) {
            monitor.setCanceled(true);
            return;
        }
        try {
            this.saveInProgress = true;
            monitor.beginTask("Save changes...", 1);
            try {
                monitor.subTask("Save '" + this.getPartName() + "' changes...");
                SaveJob saveJob = new SaveJob();
                saveJob.schedule();
                UIUtils.waitJobCompletion((AbstractJob)saveJob);
                if (!saveJob.success.booleanValue()) {
                    monitor.setCanceled(true);
                    return;
                }
            }
            finally {
                monitor.done();
            }
            {
            }
        }
        finally {
            this.saveInProgress = false;
        }
    }

    public void doRevertToSaved() {
        for (IEditorPart editor : this.editorMap.values()) {
            if (!(editor instanceof IRevertableEditor)) continue;
            ((IRevertableEditor)editor).doRevertToSaved();
        }
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext != null) {
            commandContext.resetChanges(true);
        }
    }

    private boolean saveCommandContext(DBRProgressMonitor monitor, Map<String, Object> options) {
        boolean isNewObject;
        monitor.beginTask("Save entity", 1);
        DBException error = null;
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext == null) {
            log.warn((Object)"Null command context");
            return true;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            log.warn((Object)"Null execution context");
            return true;
        }
        boolean bl = isNewObject = this.getDatabaseObject() == null || !this.getDatabaseObject().isPersisted();
        if (!isNewObject) {
            for (DBECommand cmd : commandContext.getFinalCommands()) {
                if (!(cmd.getObject() instanceof DBSObject) || ((DBSObject)cmd.getObject()).isPersisted()) continue;
                isNewObject = true;
                break;
            }
        }
        try {
            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)executionContext.getDataSource(), param -> {
                try {
                    commandContext.saveChanges(monitor, options);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (DBException e) {
            error = e;
        }
        if (this.getDatabaseObject() instanceof DBPStatefulObject) {
            try {
                ((DBPStatefulObject)this.getDatabaseObject()).refreshObjectState(monitor);
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
        if (error == null) {
            final DBNDatabaseNode treeNode = this.getEditorInput().getNavigatorNode();
            final boolean doRefresh = isNewObject;
            new AbstractJob("Database node refresh"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        treeNode.refreshNode(monitor, doRefresh ? DBNEvent.FORCE_REFRESH : DBNEvent.UPDATE_ON_SAVE);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        monitor.done();
        if (error == null) {
            return true;
        }
        DBException vError = error;
        UIUtils.syncExec(() -> {
            IErrorVisualizer errorVisualizer = this.getAdapter(IErrorVisualizer.class);
            if (errorVisualizer != null) {
                errorVisualizer.visualizeError(monitor, vError);
            }
        });
        UIUtils.asyncExec(() -> {
            DBPPlatformUI.UserResponse userResponse = DBWorkbench.getPlatformUI().showError("Can't save '" + this.getDatabaseObject().getName() + "'", null, vError);
        });
        return false;
    }

    public void revertChanges() {
        if (this.isDirty()) {
            if (ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.internal.UINavigatorMessages"), null, (String)"entity_revert", (int)3, (Object[])new Object[]{this.getDatabaseObject().getName()}) != 2) {
                return;
            }
            DBECommandContext commandContext = this.getCommandContext();
            if (commandContext != null) {
                commandContext.resetChanges(true);
            }
            this.refreshPart(this, true, false);
            this.firePropertyChange(257);
        }
    }

    public void undoChanges() {
        IUndoManager undoManager = this.getAdapter(IUndoManager.class);
        if (undoManager != null) {
            undoManager.undo();
        } else {
            DBECommandContext commandContext = this.getCommandContext();
            if (commandContext != null && commandContext.getUndoCommand() != null) {
                if (!this.getDatabaseObject().isPersisted() && commandContext.getUndoCommands().size() == 1 && ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.internal.UINavigatorMessages"), null, (String)"entity_reject", (int)3, (Object[])new Object[]{this.getDatabaseObject().getName()}) != 2) {
                    return;
                }
                commandContext.undoCommand();
                this.firePropertyChange(257);
            }
        }
    }

    public void redoChanges() {
        IUndoManager undoManager = this.getAdapter(IUndoManager.class);
        if (undoManager != null) {
            undoManager.redo();
        } else {
            DBECommandContext commandContext = this.getCommandContext();
            if (commandContext != null && commandContext.getRedoCommand() != null) {
                commandContext.redoCommand();
                this.firePropertyChange(257);
            }
        }
    }

    public int showChanges(boolean allowSave) {
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext == null) {
            return 1;
        }
        Collection commands = commandContext.getFinalCommands();
        if (CommonUtils.isEmpty((Collection)commands)) {
            return 9;
        }
        StringBuilder script = new StringBuilder();
        try {
            try {
                this.saveInProgress = true;
                UIUtils.runInProgressService(monitor -> {
                    monitor.beginTask("Generate SQL script", commands.size());
                    HashMap validateOptions = new HashMap();
                    for (DBECommand command : commands) {
                        monitor.subTask(command.getTitle());
                        try {
                            command.validateCommand(monitor, validateOptions);
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                        options.put("object.save", true);
                        DBPDataSource dataSource = this.getDatabaseObject().getDataSource();
                        try {
                            DBEPersistAction[] persistActions = command.getPersistActions(monitor, this.getExecutionContext(), options);
                            script.append(SQLUtils.generateScript((DBPDataSource)dataSource, (DBEPersistAction[])persistActions, (boolean)false));
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                });
            }
            catch (InterruptedException interruptedException) {
                this.saveInProgress = false;
                return 1;
            }
            catch (InvocationTargetException e) {
                log.error((Object)e);
                DBWorkbench.getPlatformUI().showError("Script generate error", "Couldn't generate alter script", e.getTargetException());
                this.saveInProgress = false;
                return 1;
            }
        }
        finally {
            this.saveInProgress = false;
        }
        if (script.length() == 0) {
            return 10;
        }
        ChangesPreviewer changesPreviewer = new ChangesPreviewer(script, allowSave);
        UIUtils.syncExec((Runnable)changesPreviewer);
        return changesPreviewer.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPages() {
        super.createPages();
        IDatabaseEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof DatabaseLazyEditorInput) {
            try {
                this.addPage((IEditorPart)new ProgressEditorPart((IDatabaseEditor)this), (IEditorInput)editorInput);
                this.setPageText(0, "Initializing ...");
                Image tabImage = DBeaverIcons.getImage((DBPImage)UIIcon.REFRESH);
                this.setPageImage(0, tabImage);
                this.setActivePage(0);
                ((CTabFolder)this.getContainer()).setTabHeight(tabImage.getBounds().height + 2);
            }
            catch (PartInitException e) {
                log.error((Object)e);
            }
            return;
        }
        if (editorInput instanceof ErrorEditorInput) {
            ErrorEditorInput errorInput = (ErrorEditorInput)editorInput;
            try {
                this.addPage((IEditorPart)new ErrorEditorPartEx(errorInput.getError()), (IEditorInput)errorInput);
                this.setPageImage(0, UIUtils.getShardImage((String)"IMG_OBJS_ERROR_TSK"));
                this.setPageText(0, "Error");
                this.setActivePage(0);
            }
            catch (PartInitException e) {
                log.error((Object)e);
            }
            return;
        }
        this.commandListener = new DBECommandAdapter(){

            public void onCommandChange(DBECommand<?> command) {
                UIUtils.syncExec(() -> EntityEditor.this.firePropertyChange(257));
            }
        };
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext != null) {
            commandContext.addCommandListener((DBECommandListener)this.commandListener);
        }
        this.addPropertyListener((source, propId) -> {
            if (propId == 257) {
                EntityEditorPropertyTester.firePropertyChange("dirty");
                EntityEditorPropertyTester.firePropertyChange("canUndo");
                EntityEditorPropertyTester.firePropertyChange("canRedo");
            }
        });
        DBSObject databaseObject = editorInput.getDatabaseObject();
        EditorDefaults editorDefaults = null;
        if (databaseObject == null) {
            log.debug((Object)"Null database object in EntityEditor");
        } else {
            Map<String, EditorDefaults> map = defaultPageMap;
            synchronized (map) {
                editorDefaults = defaultPageMap.get(databaseObject.getClass().getName());
            }
            EntityEditorsRegistry editorsRegistry = EntityEditorsRegistry.getInstance();
            EntityEditorDescriptor defaultEditor = editorsRegistry.getMainEntityEditor((DBPObject)databaseObject, this);
            this.hasPropertiesEditor = false;
            if (defaultEditor != null) {
                this.hasPropertiesEditor = this.addEditorTab(defaultEditor);
            }
            if (this.hasPropertiesEditor) {
                DBNDatabaseNode node = editorInput.getNavigatorNode();
                int propEditorIndex = this.getPageCount() - 1;
                this.setPageText(propEditorIndex, UINavigatorMessages.editors_entity_properties_text);
                this.setPageToolTip(propEditorIndex, String.valueOf(node.getNodeType()) + UINavigatorMessages.editors_entity_properties_tooltip_suffix);
                this.setPageImage(propEditorIndex, DBeaverIcons.getImage((DBPImage)node.getNodeIconDefault()));
            }
        }
        this.addContributions("additions_props");
        this.addContributions("additions_start");
        this.addContributions("additions_middle");
        this.addContributions("additions_end");
        String defPageId = editorInput.getDefaultPageId();
        String defFolderId = editorInput.getDefaultFolderId();
        if (defPageId == null && editorDefaults != null) {
            defPageId = editorDefaults.pageId;
        }
        if (defPageId != null) {
            IEditorPart defEditorPage = this.editorMap.get(defPageId);
            if (defEditorPage != null) {
                this.setActiveEditor(defEditorPage);
            }
        } else {
            this.setActiveEditor(this.getEditor(0));
        }
        this.activeEditor = this.getActiveEditor();
        if (this.activeEditor instanceof ITabbedFolderContainer) {
            if (defFolderId == null && editorDefaults != null) {
                defFolderId = editorDefaults.folderId;
            }
            if (defFolderId != null) {
                String folderId = defFolderId;
                UIUtils.asyncExec(() -> ((ITabbedFolderContainer)this.activeEditor).switchFolder(folderId));
            }
        }
        UIUtils.setHelp((Control)this.getContainer(), (String)"entity-editor");
    }

    public IEditorPart getPageEditor(String pageId) {
        return this.editorMap.get(pageId);
    }

    protected void pageChange(int newPageIndex) {
        try {
            super.pageChange(newPageIndex);
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        this.activeEditor = this.getEditor(newPageIndex);
        for (Map.Entry<IEditorPart, IEditorActionBarContributor> entry : this.actionContributors.entrySet()) {
            if (entry.getKey() == this.activeEditor) {
                entry.getValue().setActiveEditor(this.activeEditor);
                continue;
            }
            entry.getValue().setActiveEditor(null);
        }
        String editorPageId = this.getEditorPageId(this.activeEditor);
        if (editorPageId != null) {
            this.updateEditorDefaults(editorPageId, null);
        }
        this.firePropertyChange(257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getEditorPageId(IEditorPart editorPart) {
        Map<String, IEditorPart> map = this.editorMap;
        synchronized (map) {
            for (Map.Entry<String, IEditorPart> entry : this.editorMap.entrySet()) {
                if (entry.getValue() != editorPart) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEditorDefaults(String pageId, @Nullable String folderId) {
        DBSObject object;
        IDatabaseEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof DatabaseEditorInput) {
            ((DatabaseEditorInput)editorInput).setDefaultPageId(pageId);
            ((DatabaseEditorInput)editorInput).setDefaultFolderId(folderId);
        }
        if ((object = editorInput.getDatabaseObject()) != null) {
            Map<String, EditorDefaults> map = defaultPageMap;
            synchronized (map) {
                EditorDefaults editorDefaults = defaultPageMap.get(object.getClass().getName());
                if (editorDefaults == null) {
                    editorDefaults = new EditorDefaults(pageId, folderId);
                    defaultPageMap.put(object.getClass().getName(), editorDefaults);
                } else {
                    if (pageId != null) {
                        editorDefaults.pageId = pageId;
                    }
                    if (folderId != null) {
                        editorDefaults.folderId = folderId;
                    }
                }
            }
        }
    }

    public int promptToSaveOnClose() {
        ArrayList<String> changedSubEditors = new ArrayList<String>();
        DBECommandContext commandContext = this.getCommandContext();
        if (commandContext != null && commandContext.isDirty()) {
            changedSubEditors.add(UINavigatorMessages.registry_entity_editor_descriptor_name);
        }
        for (IEditorPart editor : this.editorMap.values()) {
            EntityEditorDescriptor editorDescriptor;
            if (!editor.isDirty() || (editorDescriptor = EntityEditorsRegistry.getInstance().getEntityEditor(editor)) == null) continue;
            changedSubEditors.add(editorDescriptor.getName());
        }
        String subEditorsString = changedSubEditors.isEmpty() ? "" : "(" + String.join((CharSequence)", ", changedSubEditors) + ")";
        int result = ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.internal.UINavigatorMessages"), (Shell)this.getSite().getShell(), (String)"close_entity_edit", (int)6, (Object[])new Object[]{this.getEditorInput().getNavigatorNode().getNodeName(), subEditorsString});
        if (result == 2) {
            return 0;
        }
        if (result == 3) {
            return 1;
        }
        return 2;
    }

    @Nullable
    public ITabbedFolder getActiveFolder() {
        if (this.getActiveEditor() instanceof ITabbedFolderContainer) {
            ((ITabbedFolderContainer)this.getActiveEditor()).getActiveFolder();
        }
        return null;
    }

    public boolean switchFolder(String folderId) {
        boolean changed = false;
        for (IEditorPart editor : this.editorMap.values()) {
            if (!(editor instanceof ITabbedFolderContainer)) continue;
            if (this.getActiveEditor() != editor) {
                this.setActiveEditor(editor);
            }
            if (!((ITabbedFolderContainer)editor).switchFolder(folderId)) continue;
            changed = true;
        }
        return changed;
    }

    public void setActiveEditor(Class<?> editorInterface) {
        int i = 0;
        while (i < this.getPageCount()) {
            if (editorInterface.isAssignableFrom(this.getEditor(i).getClass())) {
                this.setActiveEditor(this.getEditor(i));
                break;
            }
            ++i;
        }
    }

    public void addFolderListener(ITabbedFolderListener listener) {
    }

    public void removeFolderListener(ITabbedFolderListener listener) {
    }

    private void addContributions(String position) {
        EntityEditorsRegistry editorsRegistry = EntityEditorsRegistry.getInstance();
        DBSObject databaseObject = this.getEditorInput().getDatabaseObject();
        Object object = databaseObject instanceof DBPDataSourceContainer && databaseObject.getDataSource() != null ? databaseObject.getDataSource() : databaseObject;
        List<EntityEditorDescriptor> descriptors = editorsRegistry.getEntityEditors((DBPObject)object, this, position);
        for (EntityEditorDescriptor descriptor : descriptors) {
            if (descriptor.getType() != EntityEditorDescriptor.Type.editor) continue;
            this.addEditorTab(descriptor);
        }
    }

    private boolean addEditorTab(EntityEditorDescriptor descriptor) {
        IEditorPart editor;
        block7: {
            try {
                editor = descriptor.createEditor();
                if (editor != null) break block7;
                return false;
            }
            catch (Exception ex) {
                log.error((Object)"Error adding nested editor", (Throwable)ex);
                return false;
            }
        }
        IEditorInput nestedInput = descriptor.getNestedEditorInput(this.getEditorInput());
        Class<? extends IEditorActionBarContributor> contributorClass = descriptor.getContributorClass();
        if (contributorClass != null) {
            this.addActionsContributor(editor, contributorClass);
        }
        int index = this.addPage(editor, nestedInput);
        this.setPageText(index, descriptor.getName());
        if (descriptor.getIcon() != null) {
            this.setPageImage(index, DBeaverIcons.getImage((DBPImage)descriptor.getIcon()));
        }
        if (!CommonUtils.isEmpty((String)descriptor.getDescription())) {
            this.setPageToolTip(index, descriptor.getDescription());
        }
        this.editorMap.put(descriptor.getId(), editor);
        if (editor instanceof ITabbedFolderContainer) {
            ((ITabbedFolderContainer)editor).addFolderListener(this.folderListener);
        }
        return true;
    }

    private void addActionsContributor(IEditorPart editor, Class<? extends IEditorActionBarContributor> contributorClass) throws Exception {
        GlobalContributorManager contributorManager = GlobalContributorManager.getInstance();
        IEditorActionBarContributor contributor = contributorManager.getContributor(contributorClass);
        if (contributor == null) {
            contributor = contributorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        contributorManager.addContributor(contributor, editor);
        this.actionContributors.put(editor, contributor);
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        return this.refreshPart(source, force, true);
    }

    private IRefreshablePart.RefreshResult refreshPart(Object source, boolean force, boolean showConfirmation) {
        DBSObject databaseObject;
        DBECommandContext commandContext;
        if (this.getContainer() == null || this.getContainer().isDisposed() || this.saveInProgress) {
            return IRefreshablePart.RefreshResult.IGNORED;
        }
        if (force && this.isDirty() && showConfirmation && ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.internal.UINavigatorMessages"), null, (String)"entity_revert", (int)3, (Object[])new Object[]{this.getTitle()}) != 2) {
            return IRefreshablePart.RefreshResult.CANCELED;
        }
        boolean isRename = false;
        if (source instanceof DBNEvent) {
            Map options;
            Object uiSource;
            ((DBNEvent)source).getNodeChange();
            Object source2 = ((DBNEvent)source).getSource();
            if (source2 instanceof DBPEvent && ((DBPEvent)source2).getData() == DBPEvent.RENAME && (uiSource = (options = ((DBPEvent)source2).getOptions()).get("uiSource")) != null && !(uiSource instanceof CustomFormEditor)) {
                isRename = true;
            }
        }
        if (force && this.getDatabaseObject().isPersisted() && (commandContext = this.getCommandContext()) != null && commandContext.isDirty()) {
            commandContext.resetChanges(true);
        }
        if ((databaseObject = this.getEditorInput().getDatabaseObject()) != null) {
            for (IEditorPart editor : this.editorMap.values()) {
                if (!(editor instanceof IRefreshablePart)) continue;
                boolean refreshNestedPart = force;
                if (!refreshNestedPart && editor instanceof ObjectPropertiesEditor && isRename) {
                    refreshNestedPart = true;
                }
                ((IRefreshablePart)editor).refreshPart(source, refreshNestedPart);
            }
        }
        this.setPartName(this.getEditorInput().getName());
        this.setTitleImage(this.getEditorInput().getImageDescriptor());
        if (this.hasPropertiesEditor) {
            this.setPageImage(0, DBeaverIcons.getImage((DBPImage)this.getEditorInput().getNavigatorNode().getNodeIconDefault()));
        }
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    public <T> T getAdapter(Class<T> adapter) {
        T activeAdapter = this.getNestedAdapter(adapter);
        if (activeAdapter != null) {
            return activeAdapter;
        }
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new PropertyPageStandard());
        }
        if (adapter == DBSObject.class) {
            IDatabaseEditorInput editorInput = this.getEditorInput();
            DBSObject databaseObject = editorInput.getDatabaseObject();
            return adapter.cast(databaseObject);
        }
        return (T)super.getAdapter(adapter);
    }

    public <T> T getNestedAdapter(Class<T> adapter) {
        IEditorPart activeEditor;
        if (Display.getCurrent() != null && (activeEditor = this.getActiveEditor()) != null) {
            Object result = activeEditor.getAdapter(adapter);
            if (result != null) {
                return adapter.cast(result);
            }
            if (adapter.isAssignableFrom(activeEditor.getClass())) {
                return adapter.cast(activeEditor);
            }
        }
        return null;
    }

    protected Control createTopRightControl(Composite composite) {
        Composite bcComposite = new Composite(composite, 0);
        bcComposite.setLayoutData((Object)new GridData(768));
        bcComposite.setLayout((Layout)new FillLayout());
        final DBNDatabaseNode[] selNode = new DBNDatabaseNode[1];
        final ToolBar breadcrumbsPanel = new ToolBar(bcComposite, 131328);
        breadcrumbsPanel.setForeground(UIStyles.getDefaultTextForeground());
        breadcrumbsPanel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ToolItem onItem = breadcrumbsPanel.getItem(new Point(e.x, e.y));
                selNode[0] = onItem == null ? null : (DBNDatabaseNode)onItem.getData();
            }
        });
        DBNDatabaseNode node = this.getEditorInput().getNavigatorNode();
        ArrayList<DBNDatabaseNode> nodeList = new ArrayList<DBNDatabaseNode>();
        DBNDatabaseNode n = node;
        while (n != null) {
            if (n instanceof DBNDatabaseNode) {
                nodeList.add(0, n);
            }
            n = n.getParentNode();
        }
        for (DBNDatabaseNode databaseNode : nodeList) {
            this.createBreadcrumbs(breadcrumbsPanel, databaseNode);
        }
        CustomSelectionProvider selProvider = new CustomSelectionProvider();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)breadcrumbsPanel);
        menuMgr.addMenuListener(manager -> {
            this.savedPartSelectionProvider = this.getActiveEditor().getSite().getSelectionProvider();
            this.getActiveEditor().getSite().setSelectionProvider((ISelectionProvider)selProvider);
            selProvider.setSelection(selProvider.getSelection());
            DBNDatabaseNode curNode = selNode[0];
            if (curNode == null) {
                selProvider.setSelection((ISelection)new StructuredSelection());
            } else {
                selProvider.setSelection((ISelection)new StructuredSelection((Object[])selNode));
            }
            NavigatorUtils.addStandardMenuItem((IWorkbenchSite)this.getSite(), manager, (ISelectionProvider)selProvider);
        });
        menuMgr.setRemoveAllWhenShown(true);
        breadcrumbsPanel.setMenu(menu);
        this.getSite().registerContextMenu("entityBreadcrumbsMenu", menuMgr, (ISelectionProvider)selProvider);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                UIUtils.asyncExec(() -> {
                    if (EntityEditor.this.savedPartSelectionProvider != null) {
                        EntityEditor.this.getActiveEditor().getSite().setSelectionProvider(EntityEditor.this.savedPartSelectionProvider);
                        EntityEditor.this.savedPartSelectionProvider = null;
                    }
                });
            }
        });
        return bcComposite;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return DBUtils.getContainer((DBSObject)this.getDatabaseObject());
    }

    public void recreateEditorControl() {
        this.recreatePages();
        this.firePropertyChange(530);
        DataSourceToolbarUtils.refreshSelectorToolbar(this.getSite().getWorkbenchWindow());
    }

    private void createBreadcrumbs(ToolBar infoGroup, final DBNDatabaseNode databaseNode) {
        final DBNDatabaseNode curNode = this.getEditorInput().getNavigatorNode();
        final ToolItem item = new ToolItem(infoGroup, databaseNode instanceof DBNDatabaseFolder ? 4 : 8);
        item.setText(databaseNode.getNodeName());
        item.setImage(DBeaverIcons.getImage((DBPImage)databaseNode.getNodeIconDefault()));
        item.setData((Object)databaseNode);
        if (databaseNode == curNode) {
            item.setToolTipText(databaseNode.getNodeType());
        } else {
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        block8: {
                            int itemCount = 0;
                            if (EntityEditor.this.breadcrumbsMenu != null) {
                                EntityEditor.this.breadcrumbsMenu.dispose();
                            }
                            EntityEditor.this.breadcrumbsMenu = new Menu((Control)item.getParent().getShell());
                            try {
                                Object[] childNodes = DBNUtils.getNodeChildrenFiltered((DBRProgressMonitor)new VoidProgressMonitor(), (DBNNode)databaseNode, (boolean)false);
                                if (ArrayUtils.isEmpty((Object[])childNodes)) break block8;
                                Object[] objectArray = childNodes;
                                int n = childNodes.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object folderItem = objectArray[n2];
                                    MenuItem childItem = new MenuItem(EntityEditor.this.breadcrumbsMenu, 0);
                                    childItem.setText(folderItem.getName());
                                    if (folderItem == curNode) {
                                        childItem.setEnabled(false);
                                    }
                                    childItem.addSelectionListener((SelectionListener)new SelectionAdapter((DBNNode)folderItem){
                                        private final /* synthetic */ DBNNode val$folderItem;
                                        {
                                            this.val$folderItem = dBNNode;
                                        }

                                        public void widgetSelected(SelectionEvent e) {
                                            NavigatorHandlerObjectOpen.openEntityEditor(this.val$folderItem, null, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                                        }
                                    });
                                    if (++itemCount < 300) {
                                        ++n2;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable e1) {
                                log.error((Object)e1);
                            }
                        }
                        Rectangle rect = item.getBounds();
                        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                        EntityEditor.this.breadcrumbsMenu.setLocation(pt.x, pt.y + rect.height);
                        EntityEditor.this.breadcrumbsMenu.setVisible(true);
                    } else {
                        NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)databaseNode, null, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    }
                }
            });
            item.setToolTipText(NLS.bind((String)UINavigatorMessages.actions_navigator_open, (Object)databaseNode.getNodeType()));
        }
    }

    @Override
    public boolean isEntityContainer(DBSObjectContainer object) {
        try {
            Class childType = object.getPrimaryChildType(null);
            return childType != null && DBSTable.class.isAssignableFrom(childType);
        }
        catch (DBException e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public boolean isRelationalObject(DBSObject object) {
        DBPDataSource dataSource = object.getDataSource();
        return dataSource != null && dataSource.getInfo().supportsReferentialIntegrity();
    }

    public String toString() {
        DBSObject databaseObject = this.getDatabaseObject();
        return databaseObject == null ? super.toString() : DBUtils.getObjectFullName((DBPNamedObject)databaseObject, (DBPEvaluationContext)DBPEvaluationContext.UI);
    }

    private class ChangesPreviewer
    implements Runnable {
        private final StringBuilder script;
        private final boolean allowSave;
        private int result;

        ChangesPreviewer(StringBuilder script, boolean allowSave) {
            this.script = script;
            this.allowSave = allowSave;
        }

        @Override
        public void run() {
            UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
            this.result = serviceSQL != null ? serviceSQL.openSQLViewer(EntityEditor.this.getExecutionContext(), String.valueOf(EntityEditor.this.getDatabaseObject().getName()) + " - " + (this.allowSave ? UINavigatorMessages.editors_entity_dialog_persist_title : UINavigatorMessages.editors_entity_dialog_preview_title), (DBPImage)UIIcon.SQL_PREVIEW, this.script.toString(), this.allowSave, true) : 0;
        }

        public int getResult() {
            return this.result;
        }
    }

    private static class EditorDefaults {
        String pageId;
        String folderId;

        private EditorDefaults(String pageId, String folderId) {
            this.pageId = pageId;
            this.folderId = folderId;
        }
    }

    private class SaveJob
    extends AbstractJob {
        private transient Boolean success;

        SaveJob() {
            super("Save '" + EntityEditor.this.getPartName() + "' changes...");
            this.success = null;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                DBECommandContext commandContext = EntityEditor.this.getCommandContext();
                if (commandContext != null && commandContext.isDirty()) {
                    HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                    options.put("object.save", true);
                    this.success = EntityEditor.this.saveCommandContext(monitor, options);
                } else {
                    this.success = true;
                }
                if (this.success.booleanValue()) {
                    ProxyProgressMonitor proxyMonitor = new ProxyProgressMonitor(monitor);
                    for (IEditorPart editor : EntityEditor.this.editorMap.values()) {
                        if (editor.isDirty()) {
                            editor.doSave((IProgressMonitor)proxyMonitor);
                        }
                        if (!monitor.isCanceled()) continue;
                        this.success = false;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (proxyMonitor.isCanceled()) {
                        this.success = false;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                IStatus iStatus = this.success != false ? Status.OK_STATUS : Status.CANCEL_STATUS;
                return iStatus;
            }
            catch (Throwable e) {
                this.success = false;
                log.error((Object)e);
                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                return iStatus;
            }
            finally {
                if (this.success == null) {
                    this.success = true;
                }
            }
        }
    }
}

