/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.NavigatorPreferences;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.StatisticsNavigatorNodeRenderer;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.CommonUtils;

public abstract class NavigatorViewBase
extends ViewPart
implements INavigatorModelView,
IDataSourceContainerProvider,
DBPPreferenceListener {
    private DatabaseNavigatorTree tree;
    private transient Object lastSelection;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$NavigatorPreferences$DoubleClickBehavior;

    protected NavigatorViewBase() {
    }

    public DBNModel getModel() {
        return DBWorkbench.getPlatform().getNavigatorModel();
    }

    public DatabaseNavigatorTree getNavigatorTree() {
        return this.tree;
    }

    protected INavigatorFilter getNavigatorFilter() {
        return null;
    }

    @NotNull
    public TreeViewer getNavigatorViewer() {
        return this.tree.getViewer();
    }

    public void createPartControl(Composite parent) {
        this.tree = this.createNavigatorTree(parent, null);
        this.tree.setItemRenderer(new StatisticsNavigatorNodeRenderer(this));
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.tree.getViewer());
        ((IContextService)this.getSite().getService(IContextService.class)).activateContext("org.jkiss.dbeaver.ui.context.navigator");
        ((IContextService)this.getSite().getService(IContextService.class)).activateContext("org.jkiss.dbeaver.ui.context.navigator.view");
        UIExecutionQueue.queueExec(() -> this.tree.setInput(this.getRootNode()));
    }

    private DatabaseNavigatorTree createNavigatorTree(Composite parent, DBNNode rootNode) {
        DatabaseNavigatorTree navigatorTree = new DatabaseNavigatorTree(parent, rootNode, this.getTreeStyle(), false, this.getNavigatorFilter());
        this.createTreeColumns(navigatorTree);
        navigatorTree.getViewer().addSelectionChangedListener(event -> this.onSelectionChange((IStructuredSelection)event.getSelection()));
        navigatorTree.getViewer().getTree().addListener(8, event -> {
            event.doit = false;
        });
        navigatorTree.getViewer().getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                super.mouseDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                super.mouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                super.mouseUp(e);
            }
        });
        navigatorTree.getViewer().addDoubleClickListener(event -> {
            TreeViewer viewer = this.tree.getViewer();
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                block20: {
                    Object node;
                    block21: {
                        NavigatorPreferences.DoubleClickBehavior dsBehaviorDefault;
                        block22: {
                            block19: {
                                node = objectArray[n2];
                                if (!(node instanceof DBNResource) || !(((DBNResource)node).getResource() instanceof IFolder)) break block19;
                                this.toggleNode(viewer, node);
                                break block20;
                            }
                            if (!(node instanceof DBNDataSource)) break block21;
                            dsBehaviorDefault = (NavigatorPreferences.DoubleClickBehavior)CommonUtils.valueOf(NavigatorPreferences.DoubleClickBehavior.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("navigator.connection.doubleClick"), (Enum)NavigatorPreferences.DoubleClickBehavior.EDIT);
                            if (dsBehaviorDefault != NavigatorPreferences.DoubleClickBehavior.EXPAND) break block22;
                            this.toggleNode(viewer, node);
                            break block20;
                        }
                        DBPDataSourceContainer dataSource = ((DBNDataSource)node).getObject();
                        switch (NavigatorViewBase.$SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$NavigatorPreferences$DoubleClickBehavior()[dsBehaviorDefault.ordinal()]) {
                            case 1: {
                                NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)((DBNDataSource)node), null, UIUtils.getActiveWorkbenchWindow());
                                break;
                            }
                            case 2: {
                                UIServiceConnections serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
                                if (serviceConnections != null) {
                                    if (dataSource.isConnected()) {
                                        serviceConnections.disconnectDataSource(dataSource);
                                        break;
                                    }
                                    serviceConnections.connectDataSource(dataSource, null);
                                    break;
                                }
                                break block20;
                            }
                            case 3: {
                                UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                                if (serviceSQL != null) {
                                    serviceSQL.openRecentScript((DBSObject)dataSource);
                                    break;
                                }
                                break block20;
                            }
                            case 5: {
                                UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
                                if (serviceSQL == null) break block20;
                                serviceSQL.openNewScript((DBSObject)dataSource);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block20;
                    }
                    if (node instanceof TreeNodeSpecial) {
                        ((TreeNodeSpecial)node).handleDefaultAction(navigatorTree);
                    } else {
                        boolean hasChildren;
                        String defaultEditorPageId = null;
                        NavigatorPreferences.DoubleClickBehavior dcBehaviorDefault = (NavigatorPreferences.DoubleClickBehavior)CommonUtils.valueOf(NavigatorPreferences.DoubleClickBehavior.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString("navigator.object.doubleClick"));
                        if (node instanceof DBNDatabaseNode && ((DBNDatabaseNode)node).getObject() instanceof DBSDataContainer) {
                            defaultEditorPageId = DBWorkbench.getPlatform().getPreferenceStore().getString("navigator.object.defaultEditorPage");
                        }
                        boolean bl = hasChildren = node instanceof DBNNode && ((DBNNode)node).hasChildren(true);
                        if (hasChildren && dcBehaviorDefault == NavigatorPreferences.DoubleClickBehavior.EXPAND) {
                            this.toggleNode(viewer, node);
                        } else {
                            Map<String, Object> parameters = null;
                            if (!CommonUtils.isEmpty((String)defaultEditorPageId)) {
                                parameters = Collections.singletonMap("activePage", defaultEditorPageId);
                            }
                            NavigatorUtils.executeNodeAction(DBXTreeNodeHandler.Action.open, node, parameters, (IServiceLocator)this.getSite());
                        }
                    }
                }
                ++n2;
            }
        });
        NavigatorUtils.addContextMenu((IWorkbenchSite)this.getSite(), (Viewer)navigatorTree.getViewer());
        NavigatorUtils.addDragAndDropSupport((Viewer)navigatorTree.getViewer());
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
        return navigatorTree;
    }

    protected void createTreeColumns(DatabaseNavigatorTree tree) {
    }

    private void toggleNode(TreeViewer viewer, Object node) {
        if (Boolean.TRUE.equals(viewer.getExpandedState(node))) {
            viewer.collapseToLevel(node, 1);
        } else {
            viewer.expandToLevel(node, 1);
        }
    }

    private void onSelectionChange(IStructuredSelection structSel) {
        IEditorPart activeEditor;
        if (!structSel.isEmpty()) {
            this.lastSelection = structSel.getFirstElement();
            if (this.lastSelection instanceof DBNNode) {
                String desc = ((DBNNode)this.lastSelection).getNodeDescription();
                if (CommonUtils.isEmpty((String)desc)) {
                    desc = ((DBNNode)this.lastSelection).getNodeName();
                }
                this.getViewSite().getActionBars().getStatusLineManager().setMessage(desc);
            }
        } else {
            this.lastSelection = null;
        }
        if (this.lastSelection instanceof DBNDatabaseNode && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.sync.editor.datasource") && (activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null) {
            NavigatorUtils.syncEditorWithNavigator(this, activeEditor);
        }
    }

    protected int getTreeStyle() {
        return 65538;
    }

    public void dispose() {
        DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.tree.getViewer().getControl().setFocus();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new PropertyPageStandard());
        }
        return (T)super.getAdapter(adapter);
    }

    public void showNode(DBNNode node) {
        this.tree.showNode(node);
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        Collection containers;
        if (this.lastSelection instanceof DBNDatabaseNode) {
            if (this.lastSelection instanceof DBNDataSource) {
                return ((DBNDataSource)this.lastSelection).getDataSourceContainer();
            }
            if (((DBNDatabaseNode)this.lastSelection).getObject() != null) {
                DBPDataSource dataSource = ((DBNDatabaseNode)this.lastSelection).getObject().getDataSource();
                return dataSource == null ? null : dataSource.getContainer();
            }
        } else if (this.lastSelection instanceof DBNResource && (containers = ((DBNResource)this.lastSelection).getAssociatedDataSources()) != null && containers.size() == 1) {
            return (DBPDataSourceContainer)containers.iterator().next();
        }
        return null;
    }

    public void configureView() {
    }

    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        String property = event.getProperty();
        if (CommonUtils.equalObjects((Object)event.getOldValue(), (Object)event.getNewValue())) {
            return;
        }
        switch (property) {
            case "navigator.sort.case.insensitive": 
            case "navigator.sort.forlers.first": 
            case "navigator.group.by.driver": 
            case "navigator.color.nodes.all": 
            case "navigator.show.folder.placeholders": {
                this.tree.getViewer().refresh();
                break;
            }
            case "navigator.show.connection.host": 
            case "navigator.show.statistics.info": 
            case "navigator.show.node.actions": {
                this.tree.getViewer().getTree().redraw();
            }
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$NavigatorPreferences$DoubleClickBehavior() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$NavigatorPreferences$DoubleClickBehavior != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$NavigatorPreferences$DoubleClickBehavior;
        }
        int[] nArray = new int[NavigatorPreferences.DoubleClickBehavior.values().length];
        try {
            nArray[NavigatorPreferences.DoubleClickBehavior.CONNECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NavigatorPreferences.DoubleClickBehavior.EDIT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NavigatorPreferences.DoubleClickBehavior.EXPAND.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NavigatorPreferences.DoubleClickBehavior.SQL_EDITOR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NavigatorPreferences.DoubleClickBehavior.SQL_EDITOR_NEW.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$ui$navigator$NavigatorPreferences$DoubleClickBehavior = nArray;
        return nArray;
    }
}

