/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.teradata.model;

import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSActionTiming;
import org.jkiss.dbeaver.model.struct.rdb.DBSManipulationType;
import org.jkiss.utils.CommonUtils;

public class TeradataTrigger
extends GenericTableTrigger {
    private DBSActionTiming actionTime;
    private DBSManipulationType eventType;
    private String enabledStatus;
    private String triggerType;
    private Date createDate;
    private String definition;

    public TeradataTrigger(GenericTableBase table, String name, String description, JDBCResultSet dbResult) {
        block25: {
            String event;
            block23: {
                super(table, name, description);
                String actTime = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ActionTime");
                if (CommonUtils.isEmpty((String)actTime)) break block23;
                switch (actTime) {
                    case "A": {
                        this.actionTime = DBSActionTiming.AFTER;
                        break;
                    }
                    case "B": {
                        this.actionTime = DBSActionTiming.BEFORE;
                        break;
                    }
                    default: {
                        this.actionTime = DBSActionTiming.UNKNOWN;
                    }
                }
            }
            if (CommonUtils.isEmpty((String)(event = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Event")))) break block25;
            switch (event) {
                case "U": {
                    this.eventType = DBSManipulationType.UPDATE;
                    break;
                }
                case "I": {
                    this.eventType = DBSManipulationType.INSERT;
                    break;
                }
                case "D": {
                    this.eventType = DBSManipulationType.DELETE;
                    break;
                }
                default: {
                    this.eventType = DBSManipulationType.UNKNOWN;
                }
            }
        }
        this.enabledStatus = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"status");
        this.triggerType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"triggerKind");
        this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"createDate");
        this.definition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"definition");
    }

    @Property(viewable=true, order=3)
    public DBSActionTiming getActionTime() {
        return this.actionTime;
    }

    @Property(viewable=true, order=4)
    public DBSManipulationType getEventType() {
        return this.eventType;
    }

    @Property(viewable=true, order=5)
    public String getEnabledStatus() {
        return this.enabledStatus;
    }

    @Property(viewable=true, order=6)
    public String getTriggerType() {
        return this.triggerType;
    }

    @Property(order=7)
    public Date getCreateDate() {
        return this.createDate;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.definition;
    }
}

