/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.acl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.access.DBAPrivilegeOwner;
import org.jkiss.dbeaver.model.access.DBAPrivilegeType;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.acl.ACLCommandChangePrivilege;
import org.jkiss.dbeaver.ui.editors.acl.ObjectACLManager;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorLabelProvider;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ObjectACLEditor<PRIVILEGE extends DBAPrivilege, PRIVILEGE_TYPE extends DBAPrivilegeType>
extends AbstractDatabaseObjectEditor<DBAPrivilegeOwner> {
    private PageControl pageControl;
    private boolean isLoaded;
    private DatabaseNavigatorTree roleOrObjectTable;
    private Composite permEditPanel;
    private ObjectListControl<DBAPrivilege> permissionTable;
    private ControlEnableState permissionsEnable;
    private DBSObject[] currentObjects;
    private DBAPrivilege[] currentPrivileges;
    private Map<String, DBAPrivilege> privilegeMap = new HashMap<String, DBAPrivilege>();
    private Text objectDescriptionText;

    protected abstract ObjectACLManager<PRIVILEGE, PRIVILEGE_TYPE> getACLManager();

    public void createPartControl(Composite parent) {
        this.pageControl = new PageControl(parent);
        CustomSashForm composite = UIUtils.createPartDivider((IWorkbenchPart)this.getSite().getPart(), (Composite)this.pageControl, (int)256);
        composite.setLayoutData((Object)new GridData(1808));
        this.roleOrObjectTable = new DatabaseNavigatorTree((Composite)composite, (DBNNode)DBWorkbench.getPlatform().getNavigatorModel().getRoot(), 65538, false, (INavigatorFilter)(this.isRoleEditor() ? new DatabaseObjectFilter() : null));
        this.roleOrObjectTable.setLayoutData((Object)new GridData(1808));
        TreeViewer treeViewer = this.roleOrObjectTable.getViewer();
        treeViewer.setLabelProvider((IBaseLabelProvider)new DatabaseNavigatorLabelProvider((Viewer)treeViewer){

            public Font getFont(Object element) {
                if (element instanceof DBNDatabaseNode) {
                    DBSObject object = ((DBNDatabaseNode)element).getObject();
                    if (object instanceof DBSSchema) {
                        String schemaPrefix = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)object)) + ".";
                        for (String tableName : ObjectACLEditor.this.privilegeMap.keySet()) {
                            if (!tableName.startsWith(schemaPrefix)) continue;
                            return this.boldFont;
                        }
                    } else if (ObjectACLEditor.this.getObjectPermissions(object) != null) {
                        return this.boldFont;
                    }
                }
                return null;
            }
        });
        treeViewer.addSelectionChangedListener(event -> this.handleSelectionChange());
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof DBNNode && !(element instanceof DBNDatabaseNode)) {
                    return false;
                }
                if (element instanceof DBNDatabaseFolder) {
                    String elementTypeName;
                    block5: {
                        try {
                            elementTypeName = ((DBNDatabaseFolder)element).getMeta().getType();
                            if (elementTypeName != null) break block5;
                            return false;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            return false;
                        }
                    }
                    Class<?> childType = Class.forName(elementTypeName);
                    return DBAPrivilegeOwner.class.isAssignableFrom(childType);
                }
                return true;
            }
        });
        this.permEditPanel = new Composite((Composite)composite, 0);
        this.permEditPanel.setLayout((Layout)new GridLayout(1, true));
        this.permissionTable = new ObjectListControl<DBAPrivilege>(this.permEditPanel, 65568, (IContentProvider)new ListContentProvider()){

            protected String getListConfigId(List<Class<?>> classList) {
                return ((Object)((Object)ObjectACLEditor.this)).getClass().getName();
            }

            protected LoadingJob<Collection<DBAPrivilege>> createLoadService(boolean forUpdate) {
                return null;
            }
        };
        this.permissionTable.setLayoutData((Object)new GridData(768));
        Composite buttonPanel = new Composite(this.permEditPanel, 0);
        buttonPanel.setLayoutData((Object)new GridData(768));
        buttonPanel.setLayout((Layout)new RowLayout());
        UIUtils.createPushButton((Composite)buttonPanel, (String)"Grant All", null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        UIUtils.createPushButton((Composite)buttonPanel, (String)"Revoke All", null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.objectDescriptionText = new Text(this.permEditPanel, 586);
        this.objectDescriptionText.setLayoutData((Object)new GridData(1808));
        this.pageControl.createOrSubstituteProgressPanel(this.getSite());
        this.updateObjectPermissions(null);
    }

    private void handleSelectionChange() {
        List selectedObjects = NavigatorUtils.getSelectedObjects((ISelection)this.roleOrObjectTable.getViewer().getSelection());
        if (CommonUtils.isEmpty((Collection)selectedObjects)) {
            this.updateObjectPermissions(null);
        } else {
            this.updateObjectPermissions(selectedObjects);
        }
    }

    private DBAPrivilege getObjectPermissions(DBSObject object) {
        return this.privilegeMap.get(this.getACLManager().getObjectUniqueName(object));
    }

    private void updateCurrentPrivileges(boolean grant, @Nullable DBAPrivilegeType privilegeType) {
        if (ArrayUtils.isEmpty((Object[])this.currentObjects)) {
            DBWorkbench.getPlatformUI().showError("Update privilege", "Can't update privilege - no current object");
            return;
        }
        int i = 0;
        while (i < this.currentObjects.length) {
            block8: {
                DBAPrivilegeType[] dBAPrivilegeTypeArray;
                DBAPrivilege privilege;
                block7: {
                    DBSObject currentObject = this.currentObjects[i];
                    privilege = this.currentPrivileges[i];
                    if (privilege != null) break block7;
                    if (!grant) break block8;
                    privilege = this.getACLManager().createNewPrivilege((DBAPrivilegeOwner)this.getDatabaseObject(), currentObject, null);
                    this.privilegeMap.put(privilege.getName(), privilege);
                }
                ObjectACLManager<PRIVILEGE, PRIVILEGE_TYPE> objectACLManager = this.getACLManager();
                DBAPrivilegeOwner dBAPrivilegeOwner = (DBAPrivilegeOwner)this.getDatabaseObject();
                if (privilegeType == null) {
                    dBAPrivilegeTypeArray = null;
                } else {
                    DBAPrivilegeType[] dBAPrivilegeTypeArray2 = new DBAPrivilegeType[1];
                    dBAPrivilegeTypeArray = dBAPrivilegeTypeArray2;
                    dBAPrivilegeTypeArray2[0] = privilegeType;
                }
                this.addChangeCommand((DBECommand)new ACLCommandChangePrivilege(objectACLManager, dBAPrivilegeOwner, grant, privilege, dBAPrivilegeTypeArray), (DBECommandReflector)new DBECommandReflector<DBAPrivilegeOwner, ACLCommandChangePrivilege>(){

                    public void redoCommand(ACLCommandChangePrivilege cmd) {
                    }

                    public void undoCommand(ACLCommandChangePrivilege cmd) {
                    }
                });
            }
            ++i;
        }
    }

    private void updateObjectPermissions(List<DBSObject> objects) {
        boolean editEnabled;
        boolean hasBadObjects = CommonUtils.isEmpty(objects);
        StringBuilder objectNames = new StringBuilder();
        if (!hasBadObjects) {
            for (DBSObject object : objects) {
                if (!(object instanceof DBAPrivilegeOwner)) {
                    hasBadObjects = true;
                    break;
                }
                if (objectNames.length() > 0) {
                    objectNames.append(", ");
                }
                objectNames.append(DBUtils.getObjectFullName((DBPDataSource)object.getDataSource(), (DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DML));
            }
        }
        if (hasBadObjects) {
            this.objectDescriptionText.setText("<no objects>");
            this.currentPrivileges = null;
            this.currentObjects = null;
            editEnabled = false;
        } else {
            this.objectDescriptionText.setText(objectNames.toString());
            this.currentObjects = objects.toArray(new DBSObject[0]);
            this.currentPrivileges = new DBAPrivilege[this.currentObjects.length];
            int i = 0;
            while (i < this.currentObjects.length) {
                this.currentPrivileges[i] = this.getObjectPermissions(this.currentObjects[i]);
                ++i;
            }
            boolean bl = editEnabled = !CommonUtils.isEmpty(objects);
        }
        if (editEnabled) {
            if (this.permissionsEnable != null) {
                this.permissionsEnable.restore();
                this.permissionsEnable = null;
            }
        } else if (this.permissionsEnable == null) {
            this.permissionsEnable = ControlEnableState.disable((Control)this.permEditPanel);
        }
    }

    private boolean isRoleEditor() {
        return this.getDatabaseObject() instanceof DBARole;
    }

    public void setFocus() {
        if (this.pageControl != null) {
            this.pageControl.activate(true);
        }
        if (this.roleOrObjectTable != null) {
            this.roleOrObjectTable.getViewer().getControl().setFocus();
        }
    }

    public synchronized void activatePart() {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        LoadingJob.createService((ILoadService)new DatabaseLoadService<Collection<? extends DBAPrivilege>>("Load permissions", this.getExecutionContext()){

            public Collection<? extends DBAPrivilege> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask("Load privileges from database..", 1);
                try {
                    monitor.subTask("Load " + ((DBAPrivilegeOwner)ObjectACLEditor.this.getDatabaseObject()).getName() + " privileges");
                    Collection collection = ((DBAPrivilegeOwner)ObjectACLEditor.this.getDatabaseObject()).getPrivileges(monitor, false);
                    return collection;
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        }, this.pageControl.createLoadVisualizer()).schedule();
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        if (force || source instanceof DBNEvent && ((DBNEvent)source).getSource() == DBNEvent.UPDATE_ON_SAVE || !this.isLoaded) {
            this.isLoaded = false;
            UIUtils.syncExec(() -> this.updateObjectPermissions(null));
            this.activatePart();
            return IRefreshablePart.RefreshResult.REFRESHED;
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    private static class DatabaseObjectFilter
    extends DatabaseNavigatorTreeFilter {
        private DatabaseObjectFilter() {
        }

        public boolean filterFolders() {
            return false;
        }

        public boolean isLeafObject(Object object) {
            if (object instanceof DBNDatabaseItem) {
                DBSObject dbObject = ((DBNDatabaseItem)object).getObject();
                return dbObject instanceof DBSEntity || dbObject instanceof DBSProcedure || dbObject instanceof DBSTableIndex || dbObject instanceof DBSPackage || dbObject instanceof DBSSequence || dbObject instanceof DBAUser;
            }
            return false;
        }

        public boolean select(Object element) {
            if (!(element instanceof DBNDatabaseItem)) {
                return true;
            }
            return this.isLeafObject(element);
        }
    }

    private class PageControl
    extends ProgressPageControl {
        PageControl(Composite parent) {
            super(parent, 0x10000000);
        }

        ProgressPageControl.ProgressVisualizer<Collection<? extends DBAPrivilege>> createLoadVisualizer() {
            return new ProgressPageControl.ProgressVisualizer<Collection<? extends DBAPrivilege>>((ProgressPageControl)this){

                public void completeLoading(Collection<? extends DBAPrivilege> privs) {
                    super.completeLoading(privs);
                    if (privs == null) {
                        return;
                    }
                    ObjectACLEditor.this.privilegeMap.clear();
                    for (DBAPrivilege dBAPrivilege : privs) {
                        ObjectACLEditor.this.privilegeMap.put(dBAPrivilege.getName(), dBAPrivilege);
                    }
                    VoidProgressMonitor voidProgressMonitor = new VoidProgressMonitor();
                    DBSObject parentContainer = (DBSObject)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)ObjectACLEditor.this.getDatabaseObject());
                    if (parentContainer == null) {
                        parentContainer = (DBSObject)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)ObjectACLEditor.this.getDatabaseObject());
                    }
                    if (parentContainer == null) {
                        parentContainer = ((DBAPrivilegeOwner)ObjectACLEditor.this.getDatabaseObject()).getParentObject();
                    }
                    DBNDatabaseNode dbNode = DBNUtils.getNodeByObject((DBSObject)parentContainer);
                    DBNDatabaseNode rootNode = ObjectACLEditor.this.isRoleEditor() ? DBNUtils.getChildFolder((DBRProgressMonitor)voidProgressMonitor, (DBNDatabaseNode)dbNode, DBSSchema.class) : DBNUtils.getChildFolder((DBRProgressMonitor)voidProgressMonitor, (DBNDatabaseNode)dbNode, DBARole.class);
                    if (rootNode == null) {
                        DBWorkbench.getPlatformUI().showError("Object tree", "Can't detect root node for objects tree");
                    } else {
                        ObjectACLEditor.this.roleOrObjectTable.reloadTree((DBNNode)rootNode);
                    }
                    ObjectACLEditor.this.handleSelectionChange();
                }
            };
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            super.fillCustomActions(contributionManager);
            contributionManager.add((IContributionItem)new Separator());
            IWorkbenchPartSite workbenchSite = ObjectACLEditor.this.getSite();
            if (workbenchSite != null) {
                DatabaseEditorUtils.contributeStandardEditorActions((IWorkbenchSite)workbenchSite, (IContributionManager)contributionManager);
            }
        }
    }
}

