/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh.config;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;

public class SSHAuthConfiguration {
    private final SSHConstants.AuthType type;
    private final String password;
    private final File key;
    private final boolean savePassword;

    private SSHAuthConfiguration(@NotNull SSHConstants.AuthType type, @Nullable File key, @Nullable String password, boolean savePassword) {
        this.type = type;
        this.password = password;
        this.key = key;
        this.savePassword = savePassword;
        Assert.isLegal((type != SSHConstants.AuthType.PASSWORD || password != null ? 1 : 0) != 0, (String)"Password must not be null");
        Assert.isLegal((type != SSHConstants.AuthType.PUBLIC_KEY || key != null && key.exists() ? 1 : 0) != 0, (String)"Key must be present");
        Assert.isLegal((type != SSHConstants.AuthType.AGENT || password == null && key == null && !savePassword ? 1 : 0) != 0, (String)"Password and key may not be present");
    }

    @NotNull
    public static SSHAuthConfiguration usingPassword(@NotNull String password, boolean savePassword) {
        return new SSHAuthConfiguration(SSHConstants.AuthType.PASSWORD, null, password, savePassword);
    }

    @NotNull
    public static SSHAuthConfiguration usingKey(@NotNull File key, @Nullable String passphrase, boolean savePassword) {
        return new SSHAuthConfiguration(SSHConstants.AuthType.PUBLIC_KEY, key, passphrase, savePassword);
    }

    @NotNull
    public static SSHAuthConfiguration usingAgent() {
        return new SSHAuthConfiguration(SSHConstants.AuthType.AGENT, null, null, false);
    }

    @NotNull
    public SSHConstants.AuthType getType() {
        return this.type;
    }

    @NotNull
    public String getPassword() {
        Assert.isLegal((boolean)this.type.usesPassword());
        return this.password;
    }

    @NotNull
    public File getKey() {
        Assert.isLegal((this.type == SSHConstants.AuthType.PUBLIC_KEY ? 1 : 0) != 0);
        return this.key;
    }

    public boolean isSavePassword() {
        Assert.isLegal((boolean)this.type.usesPassword());
        return this.savePassword;
    }
}

