/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class EditConnectionNavigatorSettingsDialog
extends BaseDialog {
    private final DataSourceNavigatorSettings navigatorSettings;
    @Nullable
    private final DBPDataSourceContainer dataSourceDescriptor;
    private Button showSystemObjects;
    private Button showUtilityObjects;
    private Button showOnlyEntities;
    private Button mergeEntities;
    private Button hideFolders;

    public EditConnectionNavigatorSettingsDialog(@NotNull Shell shell, @NotNull DBNBrowseSettings navigatorSettings, @Nullable DBPDataSourceContainer dataSourceDescriptor) {
        super(shell, CoreMessages.dialog_connection_wizard_final_group_navigator, null);
        this.navigatorSettings = new DataSourceNavigatorSettings(navigatorSettings);
        this.dataSourceDescriptor = dataSourceDescriptor;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group miscGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_general, (int)1, (int)2, (int)0);
        miscGroup.setLayoutData((Object)new GridData(32));
        this.showSystemObjects = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_show_system_objects, (String)CoreMessages.dialog_connection_wizard_final_checkbox_show_system_objects_tip, (boolean)this.navigatorSettings.isShowSystemObjects(), (int)1);
        this.showUtilityObjects = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_show_util_objects, (String)CoreMessages.dialog_connection_wizard_final_checkbox_show_util_objects_tip, (boolean)this.navigatorSettings.isShowUtilityObjects(), (int)1);
        this.showOnlyEntities = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_show_only_entities, (String)CoreMessages.dialog_connection_wizard_final_checkbox_show_only_entities_tip, (boolean)this.navigatorSettings.isShowOnlyEntities(), (int)1);
        this.mergeEntities = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_merge_entities, (String)CoreMessages.dialog_connection_wizard_final_checkbox_merge_entities_tip, (boolean)this.navigatorSettings.isMergeEntities(), (int)1);
        if (this.dataSourceDescriptor != null) {
            this.mergeEntities.setEnabled(this.dataSourceDescriptor.getDriver().getProviderDescriptor().getTreeDescriptor().supportsEntityMerge());
        }
        this.hideFolders = UIUtils.createCheckbox((Composite)miscGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_hide_folders, (String)CoreMessages.dialog_connection_wizard_final_checkbox_hide_folders_tip, (boolean)this.navigatorSettings.isHideFolders(), (int)1);
        return composite;
    }

    protected void okPressed() {
        this.navigatorSettings.setShowSystemObjects(this.showSystemObjects.getSelection());
        this.navigatorSettings.setShowUtilityObjects(this.showUtilityObjects.getSelection());
        this.navigatorSettings.setShowOnlyEntities(this.showOnlyEntities.getSelection());
        this.navigatorSettings.setMergeEntities(this.mergeEntities.getSelection());
        this.navigatorSettings.setHideFolders(this.hideFolders.getSelection());
        super.okPressed();
    }

    public DBNBrowseSettings getNavigatorSettings() {
        return this.navigatorSettings;
    }
}

