/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPOrderedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;

public class NavigatorHandlerObjectMove
extends NavigatorHandlerObjectBase {
    private static final Log log = Log.getLog(NavigatorHandlerObjectMove.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBNNode[][] nodes;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode[][] dBNNodeArray = nodes = NavigatorHandlerObjectMove.groupConsecutiveNodes(NavigatorUtils.getSelectedNodes(selection));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode[] partition;
            DBNNode[] dBNNodeArray2 = partition = dBNNodeArray[n2];
            int n3 = partition.length;
            int n4 = 0;
            while (n4 < n3) {
                DBNNode node = dBNNodeArray2[n4];
                if (!(node.getParentNode() instanceof DBNContainer)) {
                    return null;
                }
                DBSObject object = ((DBNDatabaseNode)node).getObject();
                if (!(object instanceof DBPOrderedObject)) {
                    return null;
                }
                DBEObjectReorderer objectReorderer = (DBEObjectReorderer)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectReorderer.class);
                if (objectReorderer == null) {
                    return null;
                }
                DBPOrderedObject orderedObject = (DBPOrderedObject)object;
                try {
                    ArrayList<DBSObject> siblingObjects = new ArrayList<DBSObject>();
                    DBNNode[] dBNNodeArray3 = node.getParentNode().getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                    int n5 = dBNNodeArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        DBNNode siblingNode = dBNNodeArray3[n6];
                        if (siblingNode instanceof DBNDatabaseNode) {
                            DBSObject siblingObject = ((DBNDatabaseNode)siblingNode).getObject();
                            if (siblingObject.getClass() != object.getClass()) {
                                log.warn((Object)("Sibling object class " + siblingObject.getClass() + " differs from moving object class " + object.getClass().getName()));
                            } else {
                                siblingObjects.add(siblingObject);
                            }
                        } else {
                            log.warn((Object)("Wrong sibling node type: " + siblingNode));
                        }
                        ++n6;
                    }
                    NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectMove.getCommandTarget(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), node.getParentNode(), null, object.getClass(), false);
                    switch (event.getCommand().getId()) {
                        case "org.jkiss.dbeaver.core.object.move.up": {
                            objectReorderer.setObjectOrdinalPosition(commandTarget.getContext(), object, siblingObjects, orderedObject.getOrdinalPosition() - 1);
                            break;
                        }
                        case "org.jkiss.dbeaver.core.object.move.down": {
                            objectReorderer.setObjectOrdinalPosition(commandTarget.getContext(), object, siblingObjects, orderedObject.getOrdinalPosition() + partition.length);
                            break;
                        }
                    }
                    if (object.isPersisted() && commandTarget.getEditor() == null) {
                        Map options = DBPScriptObject.EMPTY_OPTIONS;
                        if (!NavigatorHandlerObjectMove.showScript(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), commandTarget.getContext(), options, "Reorder script")) {
                            commandTarget.getContext().resetChanges(true);
                            return false;
                        }
                        NavigatorHandlerObjectBase.ObjectSaver orderer = new NavigatorHandlerObjectBase.ObjectSaver(commandTarget.getContext(), options);
                        TasksJob.runTask((String)("Change object '" + object.getName() + "' position"), (DBRRunnableWithProgress)orderer);
                    }
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Object move", "Error during object reposition", (Throwable)e);
                    return null;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @NotNull
    private static DBNNode[][] groupConsecutiveNodes(@NotNull List<DBNNode> nodes) {
        ArrayList<DBNNode[]> ranges = new ArrayList<DBNNode[]>();
        ArrayList<DBNNode> range = new ArrayList<DBNNode>();
        int index = 1;
        int length = nodes.size();
        while (index <= length) {
            range.add(nodes.get(index - 1));
            if (index == length || NavigatorHandlerObjectMove.getNodePosition(nodes.get(index - 1)) != NavigatorHandlerObjectMove.getNodePosition(nodes.get(index)) - 1) {
                ranges.add(range.toArray(new DBNNode[0]));
                range.clear();
            }
            ++index;
        }
        return (DBNNode[][])ranges.toArray((T[])new DBNNode[0][]);
    }

    private static int getNodePosition(@NotNull DBNNode node) {
        if (!(node instanceof DBNDatabaseNode)) {
            return -1;
        }
        DBSObject object = ((DBNDatabaseNode)node).getObject();
        if (!(object instanceof DBPOrderedObject)) {
            return -1;
        }
        return ((DBPOrderedObject)object).getOrdinalPosition();
    }
}

