/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.ui.config;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.ui.internal.DB2Messages;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;

public class DB2SchemaConfigurator
implements DBEObjectConfigurator<DB2Schema> {
    public DB2Schema configureObject(DBRProgressMonitor monitor, Object container, final DB2Schema newSchema) {
        return (DB2Schema)new UITask<DB2Schema>(){

            protected DB2Schema runTask() {
                NewSchemaDialog dialog = new NewSchemaDialog(UIUtils.getActiveWorkbenchShell());
                if (dialog.open() != 0) {
                    return null;
                }
                String schemaName = dialog.getSchemaName();
                if (schemaName.length() == 0) {
                    return null;
                }
                newSchema.setName(schemaName);
                return newSchema;
            }
        }.execute();
    }

    private static class NewSchemaDialog
    extends Dialog {
        private String schemaName;
        private Text nameText;

        public String getSchemaName() {
            return this.schemaName;
        }

        public NewSchemaDialog(Shell parentShell) {
            super(parentShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(DB2Messages.dialog_schema_edit_title);
            Control container = super.createDialogArea(parent);
            Composite composite = UIUtils.createPlaceholder((Composite)((Composite)container), (int)2);
            composite.setLayoutData((Object)new GridData(1808));
            this.nameText = UIUtils.createLabelText((Composite)composite, (String)DB2Messages.dialog_schema_edit_schema_name, null);
            this.nameText.setLayoutData((Object)new GridData(768));
            return parent;
        }

        protected void okPressed() {
            this.schemaName = this.nameText.getText().trim().toUpperCase();
            super.okPressed();
        }
    }
}

