/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.text;

import java.util.List;
import org.eclipse.draw2dl.text.FlowUtilities;
import org.eclipse.draw2dl.text.TextFlow;
import org.eclipse.draw2dl.text.TextFragmentBox;
import org.eclipse.draw2dl.text.TextLayout;
import org.eclipse.swt.graphics.Font;

public class SimpleTextLayout
extends TextLayout {
    private static final String[] DELIMITERS = new String[]{"\r\n", "\n", "\r"};
    private static int result;
    private static int delimeterLength;

    public SimpleTextLayout(TextFlow flow) {
        super(flow);
    }

    @Override
    protected void layout() {
        TextFlow textFlow = (TextFlow)this.getFlowFigure();
        String text = textFlow.getText();
        List fragments = textFlow.getFragments();
        Font font = textFlow.getFont();
        int i = 0;
        int offset = 0;
        FlowUtilities flowUtilities = textFlow.getFlowUtilities();
        do {
            this.nextLineBreak(text, offset);
            TextFragmentBox fragment = this.getFragment(i++, fragments);
            fragment.length = result - offset;
            fragment.offset = offset;
            fragment.setWidth(-1);
            flowUtilities.setupFragment(fragment, font, text.substring(offset, result));
            this.getContext().addToCurrentLine(fragment);
            this.getContext().endLine();
        } while ((offset = result + delimeterLength) < text.length());
        while (i < fragments.size()) {
            fragments.remove(i++);
        }
    }

    private int nextLineBreak(String text, int offset) {
        result = text.length();
        delimeterLength = 0;
        int i = 0;
        while (i < DELIMITERS.length) {
            int current = text.indexOf(DELIMITERS[i], offset);
            if (current != -1 && current < result) {
                result = current;
                delimeterLength = DELIMITERS[i].length();
            }
            ++i;
        }
        return result;
    }
}

