/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.translate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;

public final class SQLQueryTranslator {
    public static String translateScript(@NotNull SQLDialect sourceDialect, @NotNull SQLDialect targetDialect, @NotNull String script) throws DBException {
        List<SQLScriptElement> sqlScriptElements = SQLScriptParser.parseScript(sourceDialect, script);
        ArrayList<? extends SQLScriptElement> result = new ArrayList<SQLScriptElement>();
        for (SQLScriptElement element : sqlScriptElements) {
            result.addAll(SQLQueryTranslator.translateCommand(sourceDialect, targetDialect, element));
        }
        String scriptDelimiter = targetDialect.getScriptDelimiters()[0];
        StringBuilder sql = new StringBuilder();
        for (SQLScriptElement sQLScriptElement : result) {
            sql.append(sQLScriptElement.getText());
            sql.append(scriptDelimiter);
        }
        return sql.toString();
    }

    public static List<? extends SQLScriptElement> translateCommand(@NotNull SQLDialect sourceDialect, @NotNull SQLDialect targetDialect, @NotNull SQLScriptElement element) throws DBException {
        return Collections.singletonList(element);
    }
}

