/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class OracleJob
extends OracleSchemaObject
implements OracleSourceObject {
    private final long job;
    private final String loginUser;
    private final String privilegedUser;
    private final String schemaUser;
    private final Date lastDate;
    private final Date thisDate;
    private final Date nextDate;
    private final String interval;
    private final long totalTime;
    private final long failures;
    private final long instance;
    private final String action;
    private final String nlsEnv;
    private final boolean broken;

    public OracleJob(@NotNull OracleSchema schema, @NotNull ResultSet resultSet) {
        super(schema, String.valueOf(JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"JOB")), true);
        this.job = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"JOB");
        this.loginUser = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOG_USER");
        this.privilegedUser = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PRIV_USER");
        this.schemaUser = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"SCHEMA_USER");
        this.lastDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LAST_DATE");
        this.thisDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"THIS_DATE");
        this.nextDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"NEXT_DATE");
        this.interval = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"INTERVAL");
        this.totalTime = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"TOTAL_TIME");
        this.failures = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"FAILURES");
        this.instance = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"INSTANCE");
        this.nlsEnv = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"NLS_ENV");
        this.action = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"WHAT");
        this.broken = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"BROKEN", (String)"Y");
    }

    public long getJob() {
        return this.job;
    }

    @Nullable
    public String getAction() {
        return this.action;
    }

    @Property(viewable=true, order=11)
    @Nullable
    public String getLoginUser() {
        return this.loginUser;
    }

    @Property(viewable=true, order=12)
    @Nullable
    public String getPrivilegedUser() {
        return this.privilegedUser;
    }

    @Property(viewable=true, order=13)
    @Nullable
    public String getSchemaUser() {
        return this.schemaUser;
    }

    @Property(viewable=true, order=14)
    @Nullable
    public Date getLastDate() {
        return this.lastDate;
    }

    @Property(viewable=true, order=15)
    public Date getThisDate() {
        return this.thisDate;
    }

    @Property(viewable=true, order=16)
    @Nullable
    public Date getNextDate() {
        return this.broken ? null : this.nextDate;
    }

    @Property(viewable=true, order=17)
    @Nullable
    public String getInterval() {
        return this.interval;
    }

    @Property(viewable=true, order=18)
    public String getTotalTime() {
        return RuntimeUtils.formatExecutionTime((long)this.totalTime);
    }

    @Property(viewable=true, order=19)
    public long getFailures() {
        return this.failures;
    }

    @Property(viewable=true, order=20)
    public long getInstance() {
        return this.instance;
    }

    @Property(viewable=true, order=21)
    @Nullable
    public String getNlsEnv() {
        return this.nlsEnv;
    }

    @Property(viewable=true, order=22)
    public boolean isBroken() {
        return this.broken;
    }

    @Override
    public OracleSourceType getSourceType() {
        return OracleSourceType.JOB;
    }

    @Override
    public DBEPersistAction[] getCompileActions(DBRProgressMonitor monitor) {
        return new DBEPersistAction[0];
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)this.action)) {
            return "-- Source unavailable";
        }
        return this.action;
    }

    public void setObjectDefinitionText(String source) {
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.broken ? DBSObjectState.INVALID : DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }
}

