/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.importer;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.utils.CommonUtils;

public abstract class StreamImporterAbstract
implements IStreamDataImporter {
    private static final Log log = Log.getLog(StreamImporterAbstract.class);
    protected static final String PROP_TIMESTAMP_FORMAT = "timestampFormat";
    protected static final String PROP_TIMESTAMP_ZONE = "timestampZone";
    protected static final String PROP_COLUMN_TYPE_SAMPLES = "columnTypeSamplesCount";
    protected static final String PROP_COLUMN_TYPE_LENGTH = "columnTypeMinimalLength";
    protected static final String PROP_COLUMN_IS_BYTE_LENGTH = "columnTypeIsByteLength";
    private IStreamDataImporterSite site;

    public IStreamDataImporterSite getSite() {
        return this.site;
    }

    @Override
    public void init(@NotNull IStreamDataImporterSite site) throws DBException {
        this.site = site;
    }

    @Override
    public void dispose() {
    }

    @Nullable
    protected DateTimeFormatter getTimeStampFormat(Map<String, Object> properties, String formatPropName) {
        DateTimeFormatter tsFormat = null;
        String tsFormatPattern = CommonUtils.toString((Object)properties.get(formatPropName));
        if (!CommonUtils.isEmpty((String)tsFormatPattern)) {
            try {
                tsFormat = DateTimeFormatter.ofPattern(tsFormatPattern);
            }
            catch (Exception e) {
                log.error((Object)("Wrong timestamp format: " + tsFormatPattern), (Throwable)e);
            }
        }
        return tsFormat;
    }

    protected void applyTransformHints(StreamTransferResultSet resultSet, IDataTransferConsumer consumer, Map<String, Object> properties, String formatPropName, String zoneIdPropName) throws DBException {
        String zoneId;
        DateTimeFormatter tsFormat = formatPropName == null ? null : this.getTimeStampFormat(properties, formatPropName);
        ZoneId tsZoneId = null;
        if (zoneIdPropName != null && !CommonUtils.isEmpty((String)(zoneId = CommonUtils.toString((Object)properties.get(zoneIdPropName))))) {
            tsZoneId = ZoneId.of(zoneId);
        }
        if (tsFormat != null) {
            resultSet.setDateTimeFormat(tsFormat, tsZoneId);
        }
        if (consumer instanceof DatabaseTransferConsumer) {
            DatabaseTransferConsumer.ColumnMapping[] columnMappingArray = ((DatabaseTransferConsumer)consumer).getColumnMappings();
            int n = columnMappingArray.length;
            int n2 = 0;
            while (n2 < n) {
                DatabaseTransferConsumer.ColumnMapping cm = columnMappingArray[n2];
                if (cm != null) {
                    for (StreamDataImporterColumnInfo attributeMapping : resultSet.getAttributeMappings()) {
                        DBSEntityAttribute targetAttr;
                        if (!cm.targetAttr.getMappingType().isValid() || cm.sourceAttr.getDataKind() != DBPDataKind.STRING || !cm.sourceAttr.getName().equals(attributeMapping.getName()) || (targetAttr = cm.targetAttr.getTarget()) == null) continue;
                        switch (targetAttr.getDataKind()) {
                            case BOOLEAN: 
                            case NUMERIC: 
                            case DATETIME: {
                                attributeMapping.setDataKind(targetAttr.getDataKind());
                            }
                        }
                    }
                }
                ++n2;
            }
            Object targetObject = consumer.getTargetObject();
            boolean cfr_ignored_0 = targetObject instanceof DBSEntity;
        }
    }
}

