/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.MySQLServerHome;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLDatabaseExportInfo;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLNativeCredentialsSettings;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceMap;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.nativetool.ExportSettingsExtension;
import org.jkiss.dbeaver.tasks.nativetool.NativeToolUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class MySQLExportSettings
extends AbstractImportExportSettings<DBSObject>
implements MySQLNativeCredentialsSettings,
ExportSettingsExtension<MySQLDatabaseExportInfo> {
    private static final Log log = Log.getLog(MySQLExportSettings.class);
    private DumpMethod method = DumpMethod.NORMAL;
    private boolean noCreateStatements;
    private boolean addDropStatements = true;
    private boolean disableKeys = true;
    private boolean extendedInserts = true;
    private boolean dumpEvents;
    private boolean comments;
    private boolean removeDefiner;
    private boolean binariesInHex;
    private boolean noData;
    private boolean showViews;
    private boolean overrideCredentials;
    public List<MySQLDatabaseExportInfo> exportObjects = new ArrayList<MySQLDatabaseExportInfo>();

    public DumpMethod getMethod() {
        return this.method;
    }

    public void setMethod(DumpMethod method) {
        this.method = method;
    }

    public boolean isNoCreateStatements() {
        return this.noCreateStatements;
    }

    public void setNoCreateStatements(boolean noCreateStatements) {
        this.noCreateStatements = noCreateStatements;
    }

    public boolean isAddDropStatements() {
        return this.addDropStatements;
    }

    public void setAddDropStatements(boolean addDropStatements) {
        this.addDropStatements = addDropStatements;
    }

    public boolean isDisableKeys() {
        return this.disableKeys;
    }

    public void setDisableKeys(boolean disableKeys) {
        this.disableKeys = disableKeys;
    }

    public boolean isExtendedInserts() {
        return this.extendedInserts;
    }

    public void setExtendedInserts(boolean extendedInserts) {
        this.extendedInserts = extendedInserts;
    }

    public boolean isDumpEvents() {
        return this.dumpEvents;
    }

    public void setDumpEvents(boolean dumpEvents) {
        this.dumpEvents = dumpEvents;
    }

    public boolean isComments() {
        return this.comments;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public boolean isRemoveDefiner() {
        return this.removeDefiner;
    }

    public void setRemoveDefiner(boolean removeDefiner) {
        this.removeDefiner = removeDefiner;
    }

    public boolean isBinariesInHex() {
        return this.binariesInHex;
    }

    public void setBinariesInHex(boolean binariesInHex) {
        this.binariesInHex = binariesInHex;
    }

    public boolean isNoData() {
        return this.noData;
    }

    public void setNoData(boolean noData) {
        this.noData = noData;
    }

    public boolean isShowViews() {
        return this.showViews;
    }

    public void setShowViews(boolean showViews) {
        this.showViews = showViews;
    }

    public void setExportObjects(List<MySQLDatabaseExportInfo> exportObjects) {
        this.exportObjects = exportObjects;
    }

    @NotNull
    public List<MySQLDatabaseExportInfo> getExportObjects() {
        return this.exportObjects;
    }

    @Override
    public boolean isOverrideCredentials() {
        return this.overrideCredentials;
    }

    @Override
    public void setOverrideCredentials(boolean value) {
        this.overrideCredentials = value;
    }

    public void fillExportObjectsFromInput() {
        LinkedHashMap<MySQLCatalog, List> objMap = new LinkedHashMap<MySQLCatalog, List>();
        for (DBSObject dBSObject : this.getDatabaseObjects()) {
            MySQLCatalog catalog = null;
            if (dBSObject instanceof MySQLCatalog) {
                catalog = (MySQLCatalog)dBSObject;
            } else if (dBSObject instanceof MySQLTableBase) {
                catalog = (MySQLCatalog)((MySQLTableBase)dBSObject).getContainer();
            }
            if (catalog == null) {
                log.error((Object)"Can't determine export catalog");
                continue;
            }
            List tables = objMap.computeIfAbsent(catalog, mySQLCatalog -> new ArrayList());
            if (!(dBSObject instanceof MySQLTableBase)) continue;
            tables.add((MySQLTableBase)dBSObject);
        }
        for (Map.Entry entry : objMap.entrySet()) {
            this.getExportObjects().add(new MySQLDatabaseExportInfo((MySQLCatalog)entry.getKey(), (Collection)entry.getValue()));
        }
        this.updateDataSourceContainer();
    }

    public MySQLServerHome findNativeClientHome(String clientHomeId) {
        return MySQLDataSourceProvider.getServerHome(clientHomeId);
    }

    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) throws DBException {
        List objectList;
        super.loadSettings(runnableContext, store);
        this.method = (DumpMethod)CommonUtils.valueOf(DumpMethod.class, (String)store.getString("MySQL.export.method"), (Enum)DumpMethod.NORMAL);
        this.noCreateStatements = CommonUtils.getBoolean((String)store.getString("MySQL.export.noCreateStatements"), (boolean)false);
        this.addDropStatements = CommonUtils.getBoolean((String)store.getString("MySQL.export.addDropStatements"), (boolean)true);
        this.disableKeys = CommonUtils.getBoolean((String)store.getString("MySQL.export.disableKeys"), (boolean)true);
        this.extendedInserts = CommonUtils.getBoolean((String)store.getString("MySQL.export.extendedInserts"), (boolean)true);
        this.dumpEvents = CommonUtils.getBoolean((String)store.getString("MySQL.export.dumpEvents"), (boolean)false);
        this.comments = CommonUtils.getBoolean((String)store.getString("MySQL.export.comments"), (boolean)false);
        this.removeDefiner = CommonUtils.getBoolean((String)store.getString("MySQL.export.removeDefiner"), (boolean)false);
        this.binariesInHex = CommonUtils.getBoolean((String)store.getString("MySQL.export.binariesInHex"), (boolean)false);
        this.noData = CommonUtils.getBoolean((String)store.getString("MySQL.export.noData"), (boolean)false);
        this.showViews = CommonUtils.getBoolean((String)store.getString("MySQL.export.showViews"), (boolean)false);
        this.overrideCredentials = CommonUtils.getBoolean((String)store.getString("MySQL.overrideNativeCredentials"), (boolean)false);
        if (CommonUtils.isEmpty((String)this.getExtraCommandArgs())) {
            this.setExtraCommandArgs(store.getString("MySQL.export.extraArgs"));
        }
        if (store instanceof DBPPreferenceMap && !CommonUtils.isEmpty((Collection)(objectList = (List)((DBPPreferenceMap)store).getObject("exportObjects")))) {
            for (Map object : objectList) {
                List tableNames;
                MySQLDatabaseExportInfo exportInfo;
                String catalogId = CommonUtils.toString(object.get("catalog"));
                if (CommonUtils.isEmpty((String)catalogId) || (exportInfo = this.loadDatabaseExportInfo(runnableContext, catalogId, tableNames = (List)object.get("tables"))) == null) continue;
                this.exportObjects.add(exportInfo);
            }
        }
    }

    private MySQLDatabaseExportInfo loadDatabaseExportInfo(DBRRunnableContext runnableContext, String catalogId, List<String> tableNames) {
        MySQLDatabaseExportInfo[] exportInfo = new MySQLDatabaseExportInfo[1];
        try {
            runnableContext.run(false, true, monitor -> {
                try {
                    MySQLCatalog catalog = (MySQLCatalog)DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)this.getProject(), (String)catalogId);
                    if (catalog == null) {
                        throw new DBException("Catalog " + catalogId + " not found");
                    }
                    ArrayList<MySQLTableBase> tables = null;
                    if (!CommonUtils.isEmpty((Collection)tableNames)) {
                        tables = new ArrayList<MySQLTableBase>();
                        for (String tableName : tableNames) {
                            MySQLTableBase table = (MySQLTableBase)catalog.getTableCache().getObject(monitor, (DBSObject)catalog, tableName);
                            if (table == null) continue;
                            tables.add(table);
                        }
                    }
                    mySQLDatabaseExportInfoArray[0] = new MySQLDatabaseExportInfo(catalog, tables);
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Error loading objects configuration", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        return exportInfo[0];
    }

    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) {
        super.saveSettings(runnableContext, store);
        store.setValue("MySQL.export.method", this.method.name());
        store.setValue("MySQL.export.noCreateStatements", this.noCreateStatements);
        store.setValue("MySQL.export.addDropStatements", this.addDropStatements);
        store.setValue("MySQL.export.disableKeys", this.disableKeys);
        store.setValue("MySQL.export.extendedInserts", this.extendedInserts);
        store.setValue("MySQL.export.dumpEvents", this.dumpEvents);
        store.setValue("MySQL.export.comments", this.comments);
        store.setValue("MySQL.export.removeDefiner", this.removeDefiner);
        store.setValue("MySQL.export.binariesInHex", this.binariesInHex);
        store.setValue("MySQL.export.noData", this.noData);
        store.setValue("MySQL.export.showViews", this.showViews);
        store.setValue("MySQL.overrideNativeCredentials", this.overrideCredentials);
        if (store instanceof DBPPreferenceMap && !CommonUtils.isEmpty(this.exportObjects)) {
            ArrayList objectList = new ArrayList();
            for (MySQLDatabaseExportInfo object : this.exportObjects) {
                LinkedHashMap<String, Object> objInfo = new LinkedHashMap<String, Object>();
                objInfo.put("catalog", DBUtils.getObjectFullId((DBSObject)object.getDatabase()));
                if (!CommonUtils.isEmpty(object.getTables())) {
                    ArrayList<String> tableList = new ArrayList<String>();
                    for (MySQLTableBase table : object.getTables()) {
                        tableList.add(table.getName());
                    }
                    objInfo.put("tables", tableList);
                }
                objectList.add(objInfo);
            }
            ((DBPPreferenceMap)store).getPropertyMap().put("exportObjects", objectList);
        }
    }

    @NotNull
    public File getOutputFile(@NotNull MySQLDatabaseExportInfo info) {
        String outFileName = GeneralUtils.replaceVariables((String)this.getOutputFilePattern(), name -> {
            switch (name) {
                case "database": {
                    return info.getDatabase().getName();
                }
                case "host": {
                    return info.getDatabase().getDataSource().getContainer().getConnectionConfiguration().getHostName();
                }
                case "connectionType": {
                    return info.getDatabase().getDataSource().getContainer().getConnectionConfiguration().getConnectionType().getId();
                }
                case "table": {
                    Iterator<MySQLTableBase> iterator;
                    Iterator<MySQLTableBase> iterator2 = iterator = info.getTables() == null ? null : info.getTables().iterator();
                    if (iterator != null && iterator.hasNext()) {
                        return iterator.next().getName();
                    }
                    return "null";
                }
                case "timestamp": {
                    return RuntimeUtils.getCurrentTimeStamp();
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
            }
            return NativeToolUtils.replaceVariables((String)name);
        });
        return new File(this.getOutputFolder(), outFileName);
    }

    public static enum DumpMethod {
        ONLINE,
        LOCK_ALL_TABLES,
        NORMAL;

    }
}

