/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.LinkedHashMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProviderEx;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.ui.editors.IRevertableEditor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class EditorUtils {
    public static final String PROP_SQL_DATA_SOURCE_ID = "sql-editor-data-source-id";
    private static final String PROP_SQL_PROJECT_ID = "sql-editor-project-id";
    private static final String PROP_CONTEXT_DEFAULT_DATASOURCE = "default-datasource";
    private static final String PROP_CONTEXT_DEFAULT_CATALOG = "default-catalog";
    private static final String PROP_CONTEXT_DEFAULT_SCHEMA = "default-schema";
    private static final String PROP_SQL_DATA_SOURCE_CONTAINER = "sql-editor-data-source-container";
    private static final String PROP_EDITOR_CONTEXT = "database-editor-context";
    private static final String PROP_EXECUTION_CONTEXT = "sql-editor-execution-context";
    public static final String PROP_NAMESPACE = "org.jkiss.dbeaver";
    private static final Log log = Log.getLog(EditorUtils.class);

    @Nullable
    public static IFile getFileFromInput(IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        if (editorInput instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)editorInput).getPath();
            return path == null ? null : ContentUtils.convertPathToWorkspaceFile((IPath)path);
        }
        if (editorInput instanceof IURIEditorInput) {
            return null;
        }
        IPathEditorInput pathInput = (IPathEditorInput)editorInput.getAdapter(IPathEditorInput.class);
        if (pathInput != null) {
            IPath path = pathInput.getPath();
            return path == null ? null : ContentUtils.convertPathToWorkspaceFile((IPath)path);
        }
        try {
            Method getFileMethod = editorInput.getClass().getMethod("getFile", new Class[0]);
            if (IFile.class.isAssignableFrom(getFileMethod.getReturnType())) {
                return (IFile)IFile.class.cast(getFileMethod.invoke((Object)editorInput, new Object[0]));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static IStorage getStorageFromInput(Object element) {
        IFile file;
        IStorage storage;
        if (element instanceof IAdaptable && (storage = (IStorage)((IAdaptable)element).getAdapter(IStorage.class)) != null) {
            return storage;
        }
        if (element instanceof IEditorInput && (file = EditorUtils.getFileFromInput((IEditorInput)element)) != null) {
            return file;
        }
        return null;
    }

    public static File getLocalFileFromInput(Object element) {
        if (element instanceof IEditorInput) {
            File localFile;
            IFile file = EditorUtils.getFileFromInput((IEditorInput)element);
            if (file != null) {
                IPath location = file.getLocation();
                return location == null ? null : location.toFile();
            }
            if (element instanceof IURIEditorInput && (localFile = new File(((IURIEditorInput)element).getURI())).exists()) {
                return localFile;
            }
        }
        return null;
    }

    public static DatabaseEditorContext getEditorContext(IEditorInput editorInput) {
        if (editorInput instanceof INonPersistentEditorInput) {
            return (DatabaseEditorContext)((INonPersistentEditorInput)editorInput).getProperty(PROP_EDITOR_CONTEXT);
        }
        return null;
    }

    public static DBCExecutionContext getInputExecutionContext(IEditorInput editorInput) {
        if (editorInput instanceof INonPersistentEditorInput) {
            return (DBCExecutionContext)((INonPersistentEditorInput)editorInput).getProperty(PROP_EXECUTION_CONTEXT);
        }
        return null;
    }

    public static DBPDataSourceContainer getInputDataSource(IEditorInput editorInput) {
        if (editorInput instanceof IDatabaseEditorInput) {
            DBSObject object = ((IDatabaseEditorInput)editorInput).getDatabaseObject();
            if (object != null && object.getDataSource() != null) {
                return object.getDataSource().getContainer();
            }
            return null;
        }
        if (editorInput instanceof INonPersistentEditorInput) {
            return (DBPDataSourceContainer)((INonPersistentEditorInput)editorInput).getProperty(PROP_SQL_DATA_SOURCE_CONTAINER);
        }
        IFile file = EditorUtils.getFileFromInput(editorInput);
        if (file != null) {
            return EditorUtils.getFileDataSource(file);
        }
        File localFile = EditorUtils.getLocalFileFromInput(editorInput);
        if (localFile != null) {
            DBPExternalFileManager efManager = DBWorkbench.getPlatform().getExternalFileManager();
            String dataSourceId = (String)efManager.getFileProperty(localFile, PROP_SQL_DATA_SOURCE_ID);
            String projectName = (String)efManager.getFileProperty(localFile, PROP_SQL_PROJECT_ID);
            if (CommonUtils.isEmpty((String)dataSourceId) || CommonUtils.isEmpty((String)projectName)) {
                return null;
            }
            IProject project = DBWorkbench.getPlatform().getWorkspace().getEclipseWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists()) {
                log.error((Object)("Can't locate project '" + projectName + "' in workspace"));
                return null;
            }
            DBPProject projectMeta = DBWorkbench.getPlatform().getWorkspace().getProject(project);
            return projectMeta == null ? null : projectMeta.getDataSourceRegistry().getDataSource(dataSourceId);
        }
        return null;
    }

    public static String[] getInputContextDefaults(DBPDataSourceContainer dataSource, IEditorInput editorInput) {
        String defaultDatasource = null;
        String defaultCatalogName = null;
        String defaultSchema = null;
        if (editorInput instanceof INonPersistentEditorInput) {
            defaultDatasource = (String)((INonPersistentEditorInput)editorInput).getProperty(PROP_CONTEXT_DEFAULT_DATASOURCE);
            defaultCatalogName = (String)((INonPersistentEditorInput)editorInput).getProperty(PROP_CONTEXT_DEFAULT_CATALOG);
            defaultSchema = (String)((INonPersistentEditorInput)editorInput).getProperty(PROP_CONTEXT_DEFAULT_SCHEMA);
        } else {
            IFile file = EditorUtils.getFileFromInput(editorInput);
            if (file != null) {
                DBPProject projectMeta = DBWorkbench.getPlatform().getWorkspace().getProject(file.getProject());
                if (projectMeta != null) {
                    defaultDatasource = (String)projectMeta.getResourceProperty((IResource)file, PROP_CONTEXT_DEFAULT_DATASOURCE);
                    defaultCatalogName = (String)projectMeta.getResourceProperty((IResource)file, PROP_CONTEXT_DEFAULT_CATALOG);
                    defaultSchema = (String)projectMeta.getResourceProperty((IResource)file, PROP_CONTEXT_DEFAULT_SCHEMA);
                }
            } else {
                File localFile = EditorUtils.getLocalFileFromInput(editorInput);
                if (localFile != null) {
                    DBPExternalFileManager efManager = DBWorkbench.getPlatform().getExternalFileManager();
                    defaultDatasource = (String)efManager.getFileProperty(localFile, PROP_CONTEXT_DEFAULT_DATASOURCE);
                    defaultCatalogName = (String)efManager.getFileProperty(localFile, PROP_CONTEXT_DEFAULT_CATALOG);
                    defaultSchema = (String)efManager.getFileProperty(localFile, PROP_CONTEXT_DEFAULT_SCHEMA);
                }
            }
        }
        if (!CommonUtils.isEmpty((String)defaultDatasource) && !defaultDatasource.equals(dataSource.getId())) {
            return new String[2];
        }
        return new String[]{defaultCatalogName, defaultSchema};
    }

    @Nullable
    public static DBPDataSourceContainer getFileDataSource(IFile file) {
        if (!file.exists()) {
            return null;
        }
        DBPProject projectMeta = DBWorkbench.getPlatform().getWorkspace().getProject(file.getProject());
        if (projectMeta != null) {
            Object dataSourceId = projectMeta.getResourceProperty((IResource)file, PROP_SQL_DATA_SOURCE_ID);
            if (dataSourceId != null) {
                DBPDataSourceContainer dataSource = projectMeta.getDataSourceRegistry().getDataSource(dataSourceId.toString());
                if (dataSource == null) {
                    log.debug((Object)("Datasource " + dataSourceId + " not found in project " + projectMeta.getName() + " (" + file.getFullPath().toString() + ")"));
                }
                return dataSource;
            }
            return null;
        }
        return null;
    }

    public static void setInputDataSource(@NotNull IEditorInput editorInput, @NotNull DatabaseEditorContext context) {
        if (editorInput instanceof INonPersistentEditorInput) {
            DBPDataSourceContainer dataSourceContainer;
            ((INonPersistentEditorInput)editorInput).setProperty(PROP_EDITOR_CONTEXT, context);
            DBCExecutionContext executionContext = context.getExecutionContext();
            if (executionContext != null) {
                ((INonPersistentEditorInput)editorInput).setProperty(PROP_EXECUTION_CONTEXT, executionContext);
            }
            if ((dataSourceContainer = context.getDataSourceContainer()) != null) {
                ((INonPersistentEditorInput)editorInput).setProperty(PROP_SQL_DATA_SOURCE_CONTAINER, dataSourceContainer);
            }
            if (!EditorUtils.isDefaultContextSettings(context)) {
                String schemaName;
                String catalogName;
                if (dataSourceContainer != null) {
                    ((INonPersistentEditorInput)editorInput).setProperty(PROP_CONTEXT_DEFAULT_DATASOURCE, dataSourceContainer.getId());
                }
                if ((catalogName = EditorUtils.getDefaultCatalogName(context)) != null) {
                    ((INonPersistentEditorInput)editorInput).setProperty(PROP_CONTEXT_DEFAULT_CATALOG, EditorUtils.getDefaultCatalogName(context));
                }
                if ((schemaName = EditorUtils.getDefaultSchemaName(context)) != null) {
                    ((INonPersistentEditorInput)editorInput).setProperty(PROP_CONTEXT_DEFAULT_SCHEMA, schemaName);
                }
            }
            return;
        }
        IFile file = EditorUtils.getFileFromInput(editorInput);
        if (file != null) {
            EditorUtils.setFileDataSource(file, context);
        } else {
            File localFile = EditorUtils.getLocalFileFromInput(editorInput);
            if (localFile != null) {
                EditorUtils.setFileDataSource(localFile, context);
            } else {
                log.error((Object)("Can't set datasource for input " + editorInput));
            }
        }
    }

    public static void setFileDataSource(@NotNull File localFile, @NotNull DatabaseEditorContext context) {
        DBPExternalFileManager efManager = DBWorkbench.getPlatform().getExternalFileManager();
        DBPDataSourceContainer dataSourceContainer = context.getDataSourceContainer();
        efManager.setFileProperty(localFile, PROP_SQL_PROJECT_ID, dataSourceContainer == null ? null : dataSourceContainer.getRegistry().getProject().getName());
        String dataSourceId = dataSourceContainer == null ? null : dataSourceContainer.getId();
        efManager.setFileProperty(localFile, PROP_SQL_DATA_SOURCE_ID, (Object)dataSourceId);
        if (!EditorUtils.isDefaultContextSettings(context)) {
            efManager.setFileProperty(localFile, PROP_CONTEXT_DEFAULT_DATASOURCE, (Object)dataSourceId);
            String catalogName = EditorUtils.getDefaultCatalogName(context);
            if (catalogName != null) {
                efManager.setFileProperty(localFile, PROP_CONTEXT_DEFAULT_CATALOG, (Object)EditorUtils.getDefaultCatalogName(context));
            }
            String schemaName = EditorUtils.getDefaultSchemaName(context);
            if (catalogName != null || schemaName != null) {
                efManager.setFileProperty(localFile, PROP_CONTEXT_DEFAULT_SCHEMA, (Object)EditorUtils.getDefaultCatalogName(context));
            }
        }
    }

    public static void setFileDataSource(@NotNull IFile file, @NotNull DatabaseEditorContext context) {
        DBPProject projectMeta = DBWorkbench.getPlatform().getWorkspace().getProject(file.getProject());
        if (projectMeta == null) {
            return;
        }
        DBPDataSourceContainer dataSourceContainer = context.getDataSourceContainer();
        LinkedHashMap<String, String> fileProps = new LinkedHashMap<String, String>();
        String dataSourceId = dataSourceContainer == null ? null : dataSourceContainer.getId();
        fileProps.put(PROP_SQL_DATA_SOURCE_ID, dataSourceId);
        if (!EditorUtils.isDefaultContextSettings(context)) {
            fileProps.put(PROP_CONTEXT_DEFAULT_DATASOURCE, dataSourceId);
            String catalogName = EditorUtils.getDefaultCatalogName(context);
            if (catalogName != null) {
                fileProps.put(PROP_CONTEXT_DEFAULT_CATALOG, catalogName);
            }
            String schemaName = EditorUtils.getDefaultSchemaName(context);
            if (catalogName != null || schemaName != null) {
                fileProps.put(PROP_CONTEXT_DEFAULT_SCHEMA, schemaName);
            }
        }
        projectMeta.setResourceProperties((IResource)file, fileProps);
    }

    private static boolean isDefaultContextSettings(DatabaseEditorContext context) {
        return context.getExecutionContext() == null && context.getSelectedObject() == null;
    }

    private static String getDefaultCatalogName(DatabaseEditorContext context) {
        DBCExecutionContext executionContext = context.getExecutionContext();
        if (executionContext != null) {
            DBSCatalog defaultCatalog;
            DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
            if (contextDefaults != null && (defaultCatalog = contextDefaults.getDefaultCatalog()) != null) {
                return defaultCatalog.getName();
            }
        } else {
            DBSCatalog catalog = context.getSelectedObject() instanceof DBSCatalog ? (DBSCatalog)context.getSelectedObject() : (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)context.getSelectedObject());
            return catalog == null ? null : catalog.getName();
        }
        return null;
    }

    private static String getDefaultSchemaName(DatabaseEditorContext context) {
        DBCExecutionContext executionContext = context.getExecutionContext();
        if (executionContext != null) {
            DBSSchema defaultSchema;
            DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
            if (contextDefaults != null && (defaultSchema = contextDefaults.getDefaultSchema()) != null) {
                return defaultSchema.getName();
            }
        } else {
            DBSSchema schema = context.getSelectedObject() instanceof DBSSchema ? (DBSSchema)context.getSelectedObject() : (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)context.getSelectedObject());
            return schema == null ? null : schema.getName();
        }
        return null;
    }

    public static IEditorPart openExternalFileEditor(File file, IWorkbenchWindow window) {
        try {
            IEditorDescriptor desc = window.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            if (desc == null) {
                desc = window.getWorkbench().getEditorRegistry().getDefaultEditor(String.valueOf(file.getName()) + ".txt");
            }
            IFileStore fileStore = EFS.getStore((URI)file.toURI());
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IEditorInput)input, (String)desc.getId());
        }
        catch (CoreException e) {
            log.error((Object)("Can't open editor from file '" + file.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    public static boolean isInAutoSaveJob() {
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob == null) {
            return false;
        }
        return "Auto save all editors".equals(currentJob.getName());
    }

    public static void trackControlContext(IWorkbenchSite site, Control control, final String contextId) {
        final IContextService contextService = (IContextService)site.getService(IContextService.class);
        if (contextService != null) {
            final IContextActivation[] activation = new IContextActivation[1];
            FocusListener focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (activation[0] != null) {
                        contextService.deactivateContext(activation[0]);
                        activation[0] = null;
                    }
                    activation[0] = contextService.activateContext(contextId);
                }

                public void focusLost(FocusEvent e) {
                    if (activation[0] != null) {
                        contextService.deactivateContext(activation[0]);
                        activation[0] = null;
                    }
                }
            };
            control.addFocusListener(focusListener);
            control.addDisposeListener(e -> {
                if (activation[0] != null) {
                    contextService.deactivateContext(activation[0]);
                    iContextActivationArray[0] = null;
                }
            });
        }
    }

    public static void revertEditorChanges(IEditorPart editorPart) {
        DBCExecutionContext executionContext;
        if (editorPart instanceof IRevertableEditor) {
            ((IRevertableEditor)editorPart).doRevertToSaved();
        } else if (editorPart instanceof ITextEditor) {
            ((ITextEditor)editorPart).doRevertToSaved();
        }
        if (editorPart instanceof DBPContextProvider && editorPart instanceof IDataSourceContainerProviderEx && (executionContext = ((DBPContextProvider)editorPart).getExecutionContext()) != null) {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)executionContext);
            try {
                if (txnManager != null && !txnManager.isAutoCommit()) {
                    RuntimeUtils.runTask(monitor -> {
                        try {
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Rollback editor transaction");){
                                txnManager.rollback(session, null);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (DBCException e) {
                            throw new InvocationTargetException(e);
                        }
                    }, (String)"End editor transaction", (long)5000L);
                }
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
    }
}

