/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor.tools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.part.ICustomizablePart;

public class ResetPartColorAction
extends SelectionAction {
    private IStructuredSelection selection;

    public ResetPartColorAction(ERDEditorPart part, IStructuredSelection selection) {
        super((IWorkbenchPart)part);
        this.selection = selection;
        this.setText("Remove color");
        this.setToolTipText("Reset figure color");
        this.setId("removeFigureColor");
    }

    protected boolean calculateEnabled() {
        Object[] objectArray = this.selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof ICustomizablePart && ((ICustomizablePart)item).getCustomBackgroundColor() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void init() {
        super.init();
    }

    public void run() {
        this.execute(this.createColorCommand(this.selection.toArray()));
    }

    private Command createColorCommand(final Object[] objects) {
        return new Command(){
            private final Map<ICustomizablePart, Color> oldColors = new HashMap<ICustomizablePart, Color>();

            public void execute() {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof ICustomizablePart) {
                        ICustomizablePart colorizedPart = (ICustomizablePart)item;
                        this.oldColors.put(colorizedPart, colorizedPart.getCustomBackgroundColor());
                        colorizedPart.setCustomBackgroundColor(null);
                    }
                    ++n2;
                }
            }

            public void undo() {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof ICustomizablePart) {
                        ICustomizablePart colorizedPart = (ICustomizablePart)item;
                        colorizedPart.setCustomBackgroundColor(this.oldColors.get(colorizedPart));
                    }
                    ++n2;
                }
            }

            public void redo() {
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof ICustomizablePart) {
                        ICustomizablePart colorizedPart = (ICustomizablePart)item;
                        colorizedPart.setCustomBackgroundColor(null);
                    }
                    ++n2;
                }
            }
        };
    }
}

