/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.utils.ArrayUtils;

public class DataSourceFolder
implements DBPDataSourceFolder {
    private final DataSourceRegistry registry;
    private DataSourceFolder parent;
    private List<DataSourceFolder> children = new ArrayList<DataSourceFolder>();
    private String name;
    private String description;

    public DataSourceFolder(DataSourceRegistry registry, DataSourceFolder parent, String name, String description) {
        this.registry = registry;
        this.name = name;
        this.description = description;
        this.setParent(parent);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataSourceFolder getParent() {
        return this.parent;
    }

    public void setParent(DBPDataSourceFolder parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = (DataSourceFolder)parent;
        if (this.parent != null) {
            this.parent.children.add(this);
        }
    }

    public DataSourceFolder[] getChildren() {
        return (DataSourceFolder[])ArrayUtils.toArray(DataSourceFolder.class, this.children);
    }

    public DBPDataSourceRegistry getDataSourceRegistry() {
        return this.registry;
    }

    public boolean canMoveTo(DBPDataSourceFolder folder) {
        return folder != this && !this.isParentOf(folder);
    }

    private boolean isParentOf(DBPDataSourceFolder folder) {
        DBPDataSourceFolder p = folder;
        while (p != null) {
            if (p == this) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    public DataSourceFolder getChild(String name) {
        for (DataSourceFolder child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public String getFolderPath() {
        String path = null;
        DataSourceFolder folder = this;
        while (folder != null) {
            path = path == null ? folder.getName() : String.valueOf(folder.getName()) + "/" + path;
            folder = folder.getParent();
        }
        return path;
    }

    public String toString() {
        return this.getFolderPath();
    }
}

