/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRCreator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.GenerateSQLParametrizedDialog;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.ViewSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class UIServiceSQLImpl
implements UIServiceSQL {
    private static final Log log = Log.getLog(UIServiceSQLImpl.class);

    public int openSQLViewer(DBCExecutionContext context, String title, DBPImage image, String text, boolean showSaveButton, boolean showOpenEditorButton) {
        ViewSQLDialog dialog = new ViewSQLDialog(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite(), () -> context, title, image, text);
        dialog.setShowSaveButton(showSaveButton);
        dialog.setShowOpenEditorButton(showOpenEditorButton);
        return dialog.open();
    }

    public String openSQLEditor(@Nullable DBPContextProvider contextProvider, String title, @Nullable DBPImage image, String text) {
        ViewSQLDialog dialog = new ViewSQLDialog(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite(), contextProvider, title, image, text);
        dialog.setReadOnly(false);
        if (dialog.open() == 0) {
            return dialog.getText();
        }
        return null;
    }

    public int openGeneratedScriptViewer(@Nullable DBCExecutionContext context, String title, @Nullable DBPImage image, final @NotNull DBRCreator<String, Map<String, Object>> scriptGenerator, final @NotNull DBPPropertyDescriptor[] properties, boolean showSaveButton) {
        new GenerateSQLParametrizedDialog(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite(), context, title, image){

            @Override
            protected void createControls(Composite parent) {
                DBPPropertyDescriptor[] dBPPropertyDescriptorArray = properties;
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
                    if (prop.getDataType() == Boolean.class) {
                        UIUtils.createCheckbox((Composite)parent, (String)prop.getDisplayName(), (String)CommonUtils.notEmpty((String)prop.getDescription()), (boolean)false, (int)1);
                    }
                    ++n2;
                }
                super.createControls(parent);
            }

            @Override
            protected String[] generateSQLScript() {
                LinkedHashMap params = new LinkedHashMap();
                return new String[]{(String)scriptGenerator.createObject(params)};
            }
        };
        return 0;
    }

    public Object openSQLConsole(@NotNull DBPDataSourceContainer dataSourceContainer, DBCExecutionContext executionContext, DBSObject selectedObject, String name, String sqlText) {
        SQLNavigatorContext navigatorContext;
        SQLNavigatorContext sQLNavigatorContext = navigatorContext = executionContext != null ? new SQLNavigatorContext(executionContext) : new SQLNavigatorContext((DBSObject)dataSourceContainer);
        if (selectedObject != null) {
            navigatorContext.setSelectedObject(selectedObject);
        }
        return SQLEditorHandlerOpenEditor.openSQLConsole(UIUtils.getActiveWorkbenchWindow(), navigatorContext, name, sqlText);
    }

    public Object createSQLPanel(Object site, Object parent, final DBPContextProvider contextProvider, String panelName, boolean showVerticalBar, String sqlText) throws DBException {
        IWorkbenchPartSite partSite = (IWorkbenchPartSite)site;
        Composite editorPH = (Composite)parent;
        SQLEditorBase editor = new SQLEditorBase(){

            @Nullable
            public DBCExecutionContext getExecutionContext() {
                return contextProvider.getExecutionContext();
            }

            @Override
            public void createPartControl(Composite parent) {
                super.createPartControl(parent);
                this.getAction("Preferences.ContextAction").setEnabled(false);
            }

            @Override
            public boolean isFoldingEnabled() {
                return false;
            }
        };
        editor.setHasVerticalRuler(showVerticalBar);
        try {
            editor.init((IEditorSite)new SubEditorSite(partSite), (IEditorInput)new StringEditorInput(panelName, (CharSequence)sqlText, true, GeneralUtils.getDefaultFileEncoding()));
        }
        catch (PartInitException e) {
            throw new DBException("Error initializing SQL panel", (Throwable)e);
        }
        editor.createPartControl(editorPH);
        editor.reloadSyntaxRules();
        TextViewer textViewer = editor.getTextViewer();
        textViewer.setData("editor", (Object)editor);
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)partSite, (Control)textViewer.getTextWidget());
        return textViewer;
    }

    public void setSQLPanelText(Object panelObject, String sqlText) {
        Object editor;
        if (panelObject instanceof TextViewer && (editor = ((TextViewer)panelObject).getData("editor")) instanceof SQLEditorBase) {
            IDocument document = ((SQLEditorBase)((Object)editor)).getDocument();
            if (((SQLEditorBase)((Object)editor)).getEditorInput() instanceof StringEditorInput && document != null) {
                document.set(sqlText);
            } else {
                ((SQLEditorBase)((Object)editor)).setInput((IEditorInput)new StringEditorInput("SQL", (CharSequence)sqlText, true, GeneralUtils.getDefaultFileEncoding()));
                ((SQLEditorBase)((Object)editor)).reloadSyntaxRules();
            }
        }
    }

    public String getSQLPanelText(Object panelObject) {
        Object editor;
        if (panelObject instanceof TextViewer && (editor = ((TextViewer)panelObject).getData("editor")) instanceof SQLEditorBase) {
            return ((SQLEditorBase)((Object)editor)).getDocument().get();
        }
        return null;
    }

    public void disposeSQLPanel(Object panelObject) {
        Object editor;
        if (panelObject instanceof TextViewer && (editor = ((TextViewer)panelObject).getData("editor")) instanceof SQLEditorBase) {
            ((SQLEditorBase)((Object)editor)).dispose();
        }
    }

    public Object openNewScript(DBSObject forObject) {
        try {
            SQLEditorHandlerOpenEditor.openNewEditor(new SQLNavigatorContext(forObject), null);
            return true;
        }
        catch (CoreException e) {
            DBWorkbench.getPlatformUI().showError("Open new SQL editor", "Can't open new SQL editor", (Throwable)e);
            return false;
        }
    }

    public Object openRecentScript(DBSObject forObject) {
        try {
            SQLEditorHandlerOpenEditor.openRecentScript(UIUtils.getActiveWorkbenchWindow(), new SQLNavigatorContext(forObject), null);
            return true;
        }
        catch (CoreException e) {
            DBWorkbench.getPlatformUI().showError("Open SQL editor", "Can't open SQL editor", (Throwable)e);
            return false;
        }
    }

    public void openResource(IResource element) {
        SQLEditorHandlerOpenEditor.openResource(element, new SQLNavigatorContext());
    }

    public boolean useIsolatedConnections(DBPContextProvider contextProvider) {
        return contextProvider.getExecutionContext().getDataSource().getContainer().getPreferenceStore().getBoolean("database.editor.separate.connection");
    }
}

