/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2dl.Animation;
import org.eclipse.draw2dl.Animator;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LayoutListener;
import org.eclipse.draw2dl.geometry.Rectangle;

public class LayoutAnimator
extends Animator
implements LayoutListener {
    static final LayoutAnimator INSTANCE = new LayoutAnimator();

    protected LayoutAnimator() {
    }

    @Override
    protected Object getCurrentState(IFigure container) {
        HashMap<IFigure, Rectangle> locations = new HashMap<IFigure, Rectangle>();
        List<IFigure> children = container.getChildren();
        for (IFigure child : children) {
            locations.put(child, child.getBounds().getCopy());
        }
        return locations;
    }

    public static LayoutAnimator getDefault() {
        return INSTANCE;
    }

    @Override
    public final void invalidate(IFigure container) {
        if (Animation.isInitialRecording()) {
            Animation.hookAnimator(container, this);
        }
    }

    @Override
    public final boolean layout(IFigure container) {
        if (Animation.isAnimating()) {
            return Animation.hookPlayback(container, this);
        }
        return false;
    }

    @Override
    protected boolean playback(IFigure container) {
        Map initial = (Map)Animation.getInitialState(this, container);
        Map ending = (Map)Animation.getFinalState(this, container);
        if (initial == null) {
            return false;
        }
        List<IFigure> children = container.getChildren();
        float progress = Animation.getProgress();
        float ssergorp = 1.0f - progress;
        for (IFigure child : children) {
            Rectangle rect1 = (Rectangle)initial.get(child);
            Rectangle rect2 = (Rectangle)ending.get(child);
            if (rect1 == null) continue;
            child.setBounds(new Rectangle(Math.round(progress * (float)rect2.x + ssergorp * (float)rect1.x), Math.round(progress * (float)rect2.y + ssergorp * (float)rect1.y), Math.round(progress * (float)rect2.width + ssergorp * (float)rect1.width), Math.round(progress * (float)rect2.height + ssergorp * (float)rect1.height)));
        }
        return true;
    }

    @Override
    public final void postLayout(IFigure container) {
        if (Animation.isFinalRecording()) {
            Animation.hookNeedsCapture(container, this);
        }
    }

    @Override
    public final void remove(IFigure child) {
    }

    @Override
    public final void setConstraint(IFigure child, Object constraint) {
    }
}

