/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataType;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt4;
import org.jkiss.utils.CommonUtils;

public class FireBirdTableColumn
extends GenericTableColumn
implements DBPNamedObject2,
DBSTypedObjectExt4<FireBirdDataType> {
    private FireBirdDataType dataType;
    private String computedDefinition;

    public FireBirdTableColumn(GenericTableBase table) {
        super(table);
    }

    public FireBirdTableColumn(DBRProgressMonitor monitor, JDBCResultSet dbResult, GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPosition, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        super(table, columnName, typeName, valueType, sourceType, ordinalPosition, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
        String domainTypeName = this.getDomainTypeName(monitor);
        this.dataType = domainTypeName != null ? (FireBirdDataType)((GenericDataSource)table.getDataSource()).getLocalDataType(domainTypeName) : (FireBirdDataType)((GenericDataSource)table.getDataSource()).getLocalDataType(typeName);
    }

    public GenericTableBase getTable() {
        return (GenericTableBase)super.getTable();
    }

    public DBPDataKind getDataKind() {
        return this.dataType == null ? super.getDataKind() : this.dataType.getDataKind();
    }

    @Property(order=21)
    public String getDomainTypeName(DBRProgressMonitor monitor) throws DBException {
        GenericTableBase table = this.getTable();
        if (table instanceof FireBirdTableBase) {
            return ((FireBirdTableBase)table).getColumnDomainType(monitor, this);
        }
        return null;
    }

    @Property(order=22, viewable=true)
    public String getCharset() {
        if (this.dataType != null) {
            return this.dataType.getCharsetName();
        }
        return null;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20, listProvider=JDBCTableColumn.ColumnTypeNameListProvider.class)
    public String getTypeName() {
        return super.getTypeName();
    }

    @Property(viewable=true, editable=true, updatable=true, order=40)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    @Property(viewable=true, editable=true, updatable=true, order=70)
    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    @Property(viewable=true, editable=true, updatableExpr="object.table.dataSource.isServerVersionAtLeast(2, 5)", order=75)
    @Nullable
    public String getComputedDefinition(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.computedDefinition == null && this.isAutoGenerated()) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this.getTable(), (String)"Load computed definition");){
                try {
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT F.RDB$COMPUTED_SOURCE AS COMPUTED_SOURCE FROM RDB$RELATION_FIELDS RF,RDB$FIELDS F\nWHERE RF.RDB$RELATION_NAME = ? AND RF.RDB$FIELD_NAME = ? AND RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME");){
                        dbStat.setString(1, this.getTable().getName());
                        dbStat.setString(2, this.getName());
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbComputedResult = dbStat.executeQuery();){
                            this.computedDefinition = dbComputedResult.next() ? CommonUtils.notEmpty((String)JDBCUtils.safeGetString((ResultSet)dbComputedResult, (String)"COMPUTED_SOURCE")) : "";
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Error reading computed definition", (Throwable)e);
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        return this.computedDefinition;
    }

    @Nullable
    public String getComputedDefinition() {
        return this.computedDefinition;
    }

    public void setComputedDefinition(@Nullable String computedDefinition) {
        this.computedDefinition = computedDefinition;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public boolean isAutoGenerated() {
        return super.isAutoGenerated();
    }

    public void setDataType(FireBirdDataType dataType) {
        this.dataType = dataType;
        this.typeName = dataType.getTypeName();
    }
}

