/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.time;

import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ExtendedDateFormat
extends SimpleDateFormat {
    private static final String NINE_ZEROES = "000000000";
    public static final int MAX_NANO_LENGTH = 8;
    int nanoStart = -1;
    int nanoLength;
    boolean nanoOptional;
    String nanoPrefix;
    String nanoPostfix;

    public ExtendedDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public ExtendedDateFormat(String pattern, Locale locale) {
        super(ExtendedDateFormat.stripNanos(pattern), locale);
        int quoteCount = 0;
        int i = 0;
        while (i < pattern.length()) {
            int k;
            char c = pattern.charAt(i);
            if (c == '\'') {
                ++quoteCount;
                k = i + 1;
                while (k < pattern.length()) {
                    if (pattern.charAt(k) == '\'') {
                        if (k != i + 1) {
                            ++quoteCount;
                        }
                        i = k;
                        break;
                    }
                    ++k;
                }
            } else if (c == '[') {
                this.nanoStart = i;
                this.nanoOptional = true;
                k = i + 1;
                while (k < pattern.length()) {
                    if (pattern.charAt(k) == 'f' || pattern.charAt(k) == 'S') {
                        ++this.nanoLength;
                        if (this.nanoPrefix == null) {
                            this.nanoPrefix = pattern.substring(i + 1, k);
                        }
                    }
                    if (pattern.charAt(k) == ']') {
                        if (this.nanoPrefix != null) {
                            this.nanoPostfix = pattern.substring(i + 1 + this.nanoPrefix.length() + this.nanoLength, k);
                            i = k + 1;
                        }
                        break;
                    }
                    ++k;
                }
            } else if (c == 'f') {
                this.nanoStart = i - quoteCount;
                this.nanoOptional = false;
                k = i + 1;
                while (k < pattern.length()) {
                    if (pattern.charAt(k) != 'f') break;
                    ++this.nanoLength;
                    ++k;
                }
                ++this.nanoLength;
                i += this.nanoLength;
            }
            ++i;
        }
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer result = super.format(date, toAppendTo, pos);
        if (this.nanoStart >= 0) {
            long nanos = 0L;
            if (date instanceof Timestamp) {
                nanos = ((Timestamp)date).getNanos();
            }
            if (!this.nanoOptional || nanos > 0L) {
                String nanoStr;
                int nbZeroesToPad;
                StringBuilder nanosRes = new StringBuilder(this.nanoLength);
                if (this.nanoPrefix != null) {
                    nanosRes.append(this.nanoPrefix);
                }
                if ((nbZeroesToPad = 9 - (nanoStr = String.valueOf(nanos)).length()) > 0) {
                    nanoStr = String.valueOf(NINE_ZEROES.substring(0, nbZeroesToPad)) + nanoStr;
                }
                if (this.nanoLength < nanoStr.length()) {
                    nanoStr = nanoStr.substring(0, this.nanoLength);
                } else {
                    int i = 0;
                    while (i < this.nanoLength - nanoStr.length()) {
                        nanosRes.append("0");
                        ++i;
                    }
                }
                nanosRes.append(nanoStr);
                if (this.nanoPostfix != null) {
                    nanosRes.append(this.nanoPostfix);
                }
                result.insert(this.nanoStart, nanosRes.toString());
            }
        }
        return result;
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        Date date = super.parse(text, pos);
        if (date == null) {
            return null;
        }
        int index = pos.getIndex();
        if (index < text.length() && this.nanoStart > 0) {
            long nanos = 0L;
            int i = 0;
            while (i < this.nanoLength) {
                int digitPos = index + i;
                if (digitPos == text.length()) break;
                char c = text.charAt(digitPos);
                if (!Character.isDigit(c)) {
                    pos.setErrorIndex(index);
                    pos.setIndex(index);
                    return null;
                }
                long digit = c - 48;
                int k = 8 - i;
                while (k > 0) {
                    digit *= 10L;
                    --k;
                }
                nanos += digit;
                ++i;
            }
            if (nanos > 0L) {
                Timestamp ts = new Timestamp(date.getTime());
                ts.setNanos((int)nanos);
                return ts;
            }
        }
        return date;
    }

    private static String stripNanos(String pattern) {
        int i = 0;
        while (i < pattern.length()) {
            int k;
            char c = pattern.charAt(i);
            if (c == '\'') {
                k = i + 1;
                while (k < pattern.length()) {
                    if (pattern.charAt(k) == '\'') {
                        i = k;
                        break;
                    }
                    ++k;
                }
            } else if (c == '[') {
                k = i + 1;
                while (k < pattern.length()) {
                    if (pattern.charAt(k) == ']') {
                        return String.valueOf(pattern.substring(0, i)) + pattern.substring(k + 1);
                    }
                    ++k;
                }
            } else if (c == 'f') {
                k = i + 1;
                while (k < pattern.length()) {
                    if (pattern.charAt(k) != 'f') {
                        return String.valueOf(pattern.substring(0, i)) + pattern.substring(k);
                    }
                    ++k;
                }
                return pattern.substring(0, i);
            }
            ++i;
        }
        return pattern;
    }

    public static void main(String[] args) {
        ExtendedDateFormat.test("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.ffffff''");
        ExtendedDateFormat.test("yyyy-MM-dd Z hh:mm:ss[.fffffffff]");
        ExtendedDateFormat.test("yyyy-MM-dd Z hh:mm:ss.fffffffff");
        ExtendedDateFormat.test("yyyy-MM-dd Z hh:mm:ss");
        ExtendedDateFormat.test("yyyy-MM-dd Z hh:mm:ss[.fffffffff nanos]");
        ExtendedDateFormat.test("yyyy-MM-dd Z hh:mm:ss[.ffffff micros]");
        ExtendedDateFormat.test("yyyy-MM-dd Z hh:mm:ss.ffffff");
        ExtendedDateFormat.test("yyyy-MM-dd Z hh:mm:ss.f");
    }

    private static void test(String pattern) {
        ExtendedDateFormat edf = new ExtendedDateFormat(pattern);
        Timestamp date = new Timestamp(System.currentTimeMillis());
        System.out.println(edf.format(date));
        date.setNanos(0);
        System.out.println(edf.format(date));
    }
}

