/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GenericExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<GenericCatalog, GenericSchema> {
    private static final Log log = Log.getLog(GenericExecutionContext.class);
    private String selectedEntityName;

    public GenericExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public GenericDataSource getDataSource() {
        return (GenericDataSource)super.getDataSource();
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return this;
    }

    void determineSelectedEntity(DBRProgressMonitor monitor) {
        GenericDataSource dataSource;
        block41: {
            dataSource = this.getDataSource();
            this.selectedEntityName = null;
            Throwable throwable = null;
            Object var4_5 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Determine default catalog/schema");){
                if (CommonUtils.isEmpty((String)dataSource.getQueryGetActiveDB())) {
                    try {
                        this.selectedEntityName = session.getCatalog();
                        if (dataSource.getSelectedEntityType() == null && !CommonUtils.isEmpty((String)this.selectedEntityName)) {
                            dataSource.setSelectedEntityType("catalog");
                            dataSource.setSelectedEntityFromAPI(true);
                        }
                    }
                    catch (Throwable e) {
                        log.debug((Object)e);
                    }
                    if (!CommonUtils.isEmpty((String)this.selectedEntityName)) break block41;
                    try {
                        this.selectedEntityName = session.getSchema();
                        if (dataSource.getSelectedEntityType() == null && !CommonUtils.isEmpty((String)this.selectedEntityName)) {
                            dataSource.setSelectedEntityType("schema");
                            dataSource.setSelectedEntityFromAPI(true);
                        }
                        break block41;
                    }
                    catch (Throwable e) {
                        log.debug((Object)e);
                    }
                    break block41;
                }
                try {
                    Throwable e = null;
                    Object var7_13 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement(dataSource.getQueryGetActiveDB());){
                        Throwable throwable2 = null;
                        Object var10_18 = null;
                        try (JDBCResultSet resultSet = dbStat.executeQuery();){
                            int divPos;
                            resultSet.next();
                            this.selectedEntityName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (int)1);
                            if (!CommonUtils.isEmpty((String)this.selectedEntityName) && (divPos = this.selectedEntityName.lastIndexOf(44)) != -1) {
                                this.selectedEntityName = this.selectedEntityName.substring(divPos + 1);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (e == null) {
                            e = throwable4;
                        } else if (e != throwable4) {
                            e.addSuppressed(throwable4);
                        }
                        throw e;
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                    this.selectedEntityName = null;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        if (CommonUtils.isEmpty((String)this.selectedEntityName)) {
            if (dataSource.hasCatalogs() && dataSource.getCatalogs().size() == 1) {
                dataSource.setSelectedEntityType("catalog");
                this.selectedEntityName = dataSource.getCatalogs().get(0).getName();
            } else if (dataSource.hasSchemas() && dataSource.getSchemas().size() == 1) {
                dataSource.setSelectedEntityType("schema");
                this.selectedEntityName = dataSource.getSchemas().get(0).getName();
            }
        }
    }

    void initDefaultsFrom(DBRProgressMonitor monitor, GenericExecutionContext context) throws DBCException {
        GenericSchema defaultSchema;
        GenericCatalog defaultCatalog = context.getDefaultCatalog();
        String entityName = null;
        if (defaultCatalog != null && context.supportsCatalogChange()) {
            entityName = defaultCatalog.getName();
        } else if (context.supportsSchemaChange() && (defaultSchema = context.getDefaultSchema()) != null) {
            entityName = defaultSchema.getName();
        }
        if (entityName != null) {
            GenericDataSource dataSource = this.getDataSource();
            DBCTransactionManager txnManager = null;
            boolean autoCommit = true;
            boolean needToSetAutocommit = false;
            try {
                try {
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");){
                        if (dataSource.isSelectedEntityFromAPI()) {
                            if (!dataSource.getContainer().getDriver().isInternalDriver()) {
                                if (context.supportsCatalogChange()) {
                                    session.setCatalog(entityName);
                                } else {
                                    session.setSchema(entityName);
                                }
                            } else {
                                log.debug((Object)"Catalog/schema switch is disabled for legacy drivers");
                            }
                        } else {
                            if (CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
                                throw new DBCException("Active database can't be changed for this kind of datasource!");
                            }
                            txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this);
                            boolean bl = needToSetAutocommit = txnManager != null && this.isSupportsTransactions() && !dataSource.supportsCatalogChangeInTransaction();
                            if (needToSetAutocommit && !(autoCommit = txnManager.isAutoCommit())) {
                                txnManager.setAutoCommit(monitor, true);
                            }
                            String changeQuery = dataSource.getQuerySetActiveDB().replaceFirst("\\?", Matcher.quoteReplacement(entityName));
                            Throwable throwable2 = null;
                            Object var14_18 = null;
                            try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                                dbStat.execute();
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        this.selectedEntityName = entityName;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)this);
                }
            }
            finally {
                if (needToSetAutocommit && !autoCommit) {
                    txnManager.setAutoCommit(monitor, false);
                }
            }
        }
    }

    public GenericCatalog getDefaultCatalog() {
        GenericDataSource dataSource;
        if (!CommonUtils.isEmpty((String)this.selectedEntityName) && (dataSource = this.getDataSource()).hasCatalogs() && (dataSource.getSelectedEntityType() == null || dataSource.getSelectedEntityType().equals("catalog") || !dataSource.hasSchemas())) {
            return this.getDataSource().getCatalog(this.selectedEntityName);
        }
        return this.getDataSource().getDefaultCatalog();
    }

    public GenericSchema getDefaultSchema() {
        GenericDataSource dataSource;
        if (!(CommonUtils.isEmpty((String)this.selectedEntityName) || (dataSource = this.getDataSource()).hasCatalogs() || !dataSource.hasSchemas() || dataSource.getSelectedEntityType() != null && !dataSource.getSelectedEntityType().equals("schema") && dataSource.hasCatalogs())) {
            return dataSource.getSchema(this.selectedEntityName);
        }
        return this.getDataSource().getDefaultSchema();
    }

    public boolean supportsCatalogChange() {
        GenericDataSource dataSource = this.getDataSource();
        if (dataSource.isSelectedEntityFromAPI() || !CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
            if (CommonUtils.isEmpty((String)dataSource.getSelectedEntityType())) {
                return dataSource.hasCatalogs();
            }
            if (dataSource.hasCatalogs()) {
                return "catalog".equals(dataSource.getSelectedEntityType()) || !dataSource.hasSchemas();
            }
        }
        return false;
    }

    public boolean supportsSchemaChange() {
        GenericDataSource dataSource = this.getDataSource();
        if (dataSource.isSelectedEntityFromAPI() || !CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
            if (CommonUtils.isEmpty((String)dataSource.getSelectedEntityType())) {
                return !dataSource.hasCatalogs() && dataSource.hasSchemas();
            }
            if (dataSource.hasSchemas()) {
                return "schema".equals(dataSource.getSelectedEntityType()) || !dataSource.hasCatalogs();
            }
        }
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, GenericCatalog catalog, GenericSchema schema) throws DBCException {
        GenericCatalog oldSelectedCatalog;
        GenericDataSource dataSource;
        block31: {
            if (catalog == null) {
                log.debug((Object)"Null current catalog");
                return;
            }
            dataSource = this.getDataSource();
            oldSelectedCatalog = this.getDefaultCatalog();
            DBCTransactionManager txnManager = null;
            boolean autoCommit = true;
            boolean needToSetAutocommit = false;
            try {
                try {
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");){
                        if (dataSource.isSelectedEntityFromAPI()) {
                            if (!dataSource.getContainer().getDriver().isInternalDriver()) {
                                session.setCatalog(catalog.getName());
                            } else {
                                log.debug((Object)"Catalog change is disabled for legacy drivers");
                            }
                            break block31;
                        }
                        if (CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
                            throw new DBCException("Active catalog can't be changed for this kind of datasource!");
                        }
                        txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this);
                        boolean bl = needToSetAutocommit = txnManager != null && this.isSupportsTransactions() && !dataSource.supportsCatalogChangeInTransaction();
                        if (needToSetAutocommit && !(autoCommit = txnManager.isAutoCommit())) {
                            txnManager.setAutoCommit(monitor, true);
                        }
                        String changeQuery = dataSource.getQuerySetActiveDB().replaceFirst("\\?", Matcher.quoteReplacement(catalog.getName()));
                        Throwable throwable2 = null;
                        Object var14_18 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                            dbStat.execute();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)this);
                }
            }
            finally {
                if (needToSetAutocommit && !autoCommit) {
                    txnManager.setAutoCommit(monitor, false);
                }
            }
        }
        this.selectedEntityName = catalog.getName();
        dataSource.setSelectedEntityType("catalog");
        if (oldSelectedCatalog != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedCatalog, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)catalog, (boolean)true);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, GenericSchema schema) throws DBCException {
        if (schema == null) {
            log.debug((Object)"Null current schema");
            return;
        }
        GenericSchema oldSelectedSchema = this.getDefaultSchema();
        this.setDefaultSchema(monitor, schema.getName());
        if (oldSelectedSchema != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedSchema, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)schema, (boolean)true);
    }

    private void setDefaultSchema(DBRProgressMonitor monitor, String schemaName) throws DBCException {
        GenericDataSource dataSource;
        block22: {
            dataSource = this.getDataSource();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                    if (dataSource.isSelectedEntityFromAPI()) {
                        session.setSchema(schemaName);
                        break block22;
                    }
                    if (CommonUtils.isEmpty((String)dataSource.getQuerySetActiveDB())) {
                        throw new DBCException("Active schema can't be changed for this kind of datasource!");
                    }
                    String changeQuery = dataSource.getQuerySetActiveDB().replaceFirst("\\?", Matcher.quoteReplacement(schemaName));
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement(changeQuery);){
                        dbStat.execute();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        this.selectedEntityName = schemaName;
        dataSource.setSelectedEntityType("schema");
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        GenericObjectContainer newDefaultObject;
        DBPConnectionBootstrap bootstrap;
        if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrap = this.getBootstrapSettings()).getDefaultSchemaName())) {
            this.setDefaultSchema(monitor, bootstrap.getDefaultSchemaName());
        }
        String oldEntityName = this.selectedEntityName;
        GenericObjectContainer oldDefaultObject = this.getDefaultObject();
        try {
            this.determineSelectedEntity(monitor);
        }
        catch (Throwable e) {
            log.debug((Object)"Error detecting active object", e);
            return false;
        }
        if (!CommonUtils.equalObjects((Object)oldEntityName, (Object)this.selectedEntityName) && (newDefaultObject = this.getDefaultObject()) != null) {
            DBUtils.fireObjectSelectionChange((DBSObject)oldDefaultObject, (DBSObject)newDefaultObject);
            return true;
        }
        return false;
    }

    public GenericObjectContainer getDefaultObject() {
        if (!CommonUtils.isEmpty((String)this.selectedEntityName)) {
            GenericDataSource dataSource = this.getDataSource();
            if (dataSource.hasCatalogs()) {
                if (dataSource.getSelectedEntityType() == null || dataSource.getSelectedEntityType().equals("catalog")) {
                    return dataSource.getCatalog(this.selectedEntityName);
                }
            } else if (dataSource.hasSchemas()) {
                return dataSource.getSchema(this.selectedEntityName);
            }
        }
        return null;
    }
}

