/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.auth.DBAAuthCredentials;
import org.jkiss.dbeaver.model.auth.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ProgressStreamReader;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.tasks.nativetool.NativeToolUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public abstract class AbstractNativeToolHandler<SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
implements DBTTaskHandler {
    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        SETTINGS settings = this.createTaskSettings(runnableContext, task);
        ((AbstractNativeToolSettings)settings).setLogWriter(logStream);
        if (!this.validateTaskParameters(task, settings, log)) {
            return new DBTTaskRunStatus();
        }
        try {
            runnableContext.run(true, true, monitor -> {
                monitor.beginTask(task.getType().getName(), 1);
                monitor.subTask(task.getType().getName());
                Log.setLogWriter((OutputStream)logStream);
                listener.taskStarted((Object)task);
                Exception error = null;
                try {
                    try {
                        this.doExecute(monitor, task, settings, log);
                    }
                    catch (Exception e) {
                        error = e;
                        listener.taskFinished((Object)settings, null, (Throwable)error);
                        Log.setLogWriter(null);
                        monitor.worked(1);
                        monitor.done();
                    }
                }
                finally {
                    listener.taskFinished((Object)settings, null, (Throwable)error);
                    Log.setLogWriter(null);
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error executing native tool", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        return new DBTTaskRunStatus();
    }

    protected boolean isNativeClientHomeRequired() {
        return true;
    }

    protected boolean isMergeProcessStreams() {
        return false;
    }

    protected boolean needsModelRefresh() {
        return true;
    }

    private void validateClientHome(DBRProgressMonitor monitor, SETTINGS settings) throws DBCException {
        DBPDataSourceContainer dataSourceContainer = ((AbstractNativeToolSettings)settings).getDataSourceContainer();
        if (this.isNativeClientHomeRequired()) {
            String clientHomeId = dataSourceContainer.getConnectionConfiguration().getClientHomeId();
            DBPDriver driver = dataSourceContainer.getDriver();
            List clientLocations = driver.getNativeClientLocations();
            DBPNativeClientLocationManager locationManager = driver.getNativeClientManager();
            if (locationManager != null) {
                clientLocations.addAll(locationManager.findLocalClientLocations());
            }
            if (clientHomeId == null) {
                if (!clientLocations.isEmpty()) {
                    ((AbstractNativeToolSettings)settings).setClientHome((DBPNativeClientLocation)clientLocations.get(0));
                } else {
                    ((AbstractNativeToolSettings)settings).setClientHome(null);
                }
                if (((AbstractNativeToolSettings)settings).getClientHome() == null) {
                    throw new DBCException("Client binaries location is not specified");
                }
            } else {
                DBPNativeClientLocation clientHome = (DBPNativeClientLocation)DBUtils.findObject((Collection)clientLocations, (String)clientHomeId);
                if (clientHome == null) {
                    clientHome = ((AbstractNativeToolSettings)settings).findNativeClientHome(clientHomeId);
                }
                ((AbstractNativeToolSettings)settings).setClientHome(clientHome);
            }
            if (((AbstractNativeToolSettings)settings).getClientHome() == null) {
                throw new DBCException("Native client home '" + clientHomeId + "' not found");
            }
        }
        DBPNativeClientLocation clientHome = ((AbstractNativeToolSettings)settings).getClientHome();
        if (!this.isNativeClientHomeRequired() || clientHome == null) {
            return;
        }
        try {
            clientHome.validateFilesPresence(monitor);
        }
        catch (DBException e) {
            throw new DBCException("Error downloading client file(s)", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new DBCException("Client file download interrupted", (Throwable)e);
        }
    }

    public abstract Collection<PROCESS_ARG> getRunInfo(SETTINGS var1);

    public Collection<BASE_OBJECT> getUpdatedObjects(PROCESS_ARG settings) {
        return Collections.emptyList();
    }

    protected abstract SETTINGS createTaskSettings(DBRRunnableContext var1, DBTTask var2) throws DBException;

    protected boolean validateTaskParameters(DBTTask task, SETTINGS settings, Log log) {
        return true;
    }

    protected abstract List<String> getCommandLine(SETTINGS var1, PROCESS_ARG var2) throws IOException;

    public abstract void fillProcessParameters(SETTINGS var1, PROCESS_ARG var2, List<String> var3) throws IOException;

    protected void setupProcessParameters(DBRProgressMonitor monitor, SETTINGS settings, PROCESS_ARG arg, ProcessBuilder process) {
    }

    protected boolean isLogInputStream() {
        return true;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, DBTTask task, SETTINGS settings, PROCESS_ARG arg, ProcessBuilder processBuilder, Process process, Log log) throws IOException {
        LogReaderJob logReaderJob = new LogReaderJob(this, task, settings, processBuilder, this.isLogInputStream() ? process.getInputStream() : process.getErrorStream());
        logReaderJob.start();
    }

    public boolean executeProcess(DBRProgressMonitor monitor, DBTTask task, SETTINGS settings, PROCESS_ARG arg, Log log) throws IOException, InterruptedException {
        monitor.beginTask(task.getType().getName(), 1);
        try {
            try {
                monitor.subTask("Start native tool");
                List<String> commandLine = this.getCommandLine(settings, arg);
                File execPath = new File(commandLine.get(0));
                ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
                processBuilder.directory(execPath.getParentFile());
                if (this.isMergeProcessStreams()) {
                    processBuilder.redirectErrorStream(true);
                }
                this.setupProcessParameters(monitor, settings, arg, processBuilder);
                Process process = processBuilder.start();
                this.startProcessHandler(monitor, task, settings, arg, processBuilder, process, log);
                monitor.subTask("Executing");
                Thread.sleep(100L);
                while (true) {
                    Thread.sleep(100L);
                    if (monitor.isCanceled()) {
                        process.destroy();
                    }
                    try {
                        int exitCode = process.exitValue();
                        this.validateErrorCode(exitCode);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)("IO error: " + e.getMessage()));
                throw e;
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public void validateErrorCode(int exitCode) throws IOException {
        if (exitCode != 0) {
            throw new IOException("Process failed (exit code = " + exitCode + "). See error log.");
        }
    }

    protected void notifyToolFinish(String toolName, long workTime) {
        if (workTime > DBWorkbench.getPlatformUI().getLongOperationTimeout() * 1000L) {
            DBWorkbench.getPlatformUI().notifyAgent(toolName, 1);
        }
    }

    protected void onSuccess(DBTTask task, SETTINGS settings, long workTime) {
        StringBuilder message = new StringBuilder();
        message.append("Task [").append(task.getName()).append("] is completed (").append(workTime).append("ms)");
        ArrayList<String> objNames = new ArrayList<String>();
        for (DBSObject obj : ((AbstractNativeToolSettings)settings).getDatabaseObjects()) {
            objNames.add(obj.getName());
        }
        message.append("\nObject(s) processed: ").append(String.join((CharSequence)",", objNames));
        DBWorkbench.getPlatformUI().showNotification(task.getName(), message.toString(), false);
    }

    protected void onError(DBTTask task, SETTINGS settings, long workTime) {
    }

    protected boolean doExecute(DBRProgressMonitor monitor, DBTTask task, SETTINGS settings, Log log) throws DBException, InterruptedException {
        this.validateClientHome(monitor, settings);
        long startTime = System.currentTimeMillis();
        boolean isSuccess = true;
        try {
            boolean refreshObjects;
            for (PROCESS_ARG arg : this.getRunInfo(settings)) {
                if (monitor.isCanceled()) break;
                if (this.executeProcess(monitor, task, settings, arg, log)) continue;
                isSuccess = false;
            }
            DBPDataSourceContainer dataSourceContainer = ((AbstractNativeToolSettings)settings).getDataSourceContainer();
            boolean bl = refreshObjects = isSuccess && !monitor.isCanceled();
            if (refreshObjects && this.needsModelRefresh()) {
                for (DBSObject object : ((AbstractNativeToolSettings)settings).getDatabaseObjects()) {
                    DBNDatabaseNode node = dataSourceContainer.getPlatform().getNavigatorModel().findNode(object);
                    if (node == null) continue;
                    node.refreshNode(monitor, (Object)this);
                }
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new DBException("Error executing process", (Throwable)e);
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        long workTime = System.currentTimeMillis() - startTime;
        this.notifyToolFinish(String.valueOf(task.getType().getName()) + " - " + task.getName() + " has finished", workTime);
        if (isSuccess) {
            this.onSuccess(task, settings, workTime);
        } else {
            this.onError(task, settings, workTime);
        }
        return isSuccess;
    }

    protected String getInputCharset() {
        return GeneralUtils.UTF8_ENCODING;
    }

    protected String getOutputCharset() {
        return GeneralUtils.UTF8_ENCODING;
    }

    protected String getDataSourcePassword(DBRProgressMonitor monitor, SETTINGS settings) {
        String userPassword = null;
        DBPDataSourceContainer dataSourceContainer = ((AbstractNativeToolSettings)settings).getDataSourceContainer();
        DBPConnectionConfiguration cfg = new DBPConnectionConfiguration(dataSourceContainer.getActualConnectionConfiguration());
        DBAAuthModel authModel = cfg.getAuthModel();
        if (authModel != AuthModelDatabaseNative.INSTANCE) {
            DBAAuthCredentials credentials = authModel.loadCredentials(dataSourceContainer, cfg);
            try {
                Properties connProperties = new Properties();
                authModel.initAuthentication(monitor, dataSourceContainer.getDataSource(), credentials, cfg, connProperties);
                Object authPassword = connProperties.get("password");
                if (authPassword != null) {
                    userPassword = CommonUtils.toString((Object)authPassword);
                }
            }
            catch (DBException dBException) {}
        }
        if (CommonUtils.isEmpty(userPassword)) {
            userPassword = dataSourceContainer.getActualConnectionConfiguration().getUserPassword();
        }
        return userPassword;
    }

    public static class BinaryFileTransformerJob
    extends Thread {
        private final DBRProgressMonitor monitor;
        private final DBTTask task;
        private OutputStream output;
        private File inputFile;
        private Log log;

        public BinaryFileTransformerJob(DBRProgressMonitor monitor, DBTTask task, File inputFile, OutputStream stream, Log log) {
            super(task.getName());
            this.monitor = monitor;
            this.task = task;
            this.output = stream;
            this.inputFile = inputFile;
            this.log = log;
        }

        @Override
        public void run() {
            try {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (ProgressStreamReader scriptStream = new ProgressStreamReader(this.monitor, this.task.getName(), (InputStream)new FileInputStream(this.inputFile), this.inputFile.length());){
                        byte[] buffer = new byte[100000];
                        while (!this.monitor.isCanceled()) {
                            int readSize = scriptStream.read(buffer);
                            if (readSize < 0) break;
                            this.output.write(buffer, 0, readSize);
                            this.output.flush();
                        }
                        this.output.flush();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.log.error((Object)e);
                    try {
                        this.output.close();
                    }
                    catch (IOException e2) {
                        this.log.error((Object)e2);
                    }
                }
            }
            finally {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    public static class DumpCopierJob
    extends DumpJob {
        public DumpCopierJob(DBRProgressMonitor monitor, String name, InputStream stream, File outFile, Log log) {
            super(name, monitor, stream, outFile, log);
        }

        @Override
        public void runDump() throws IOException {
            this.monitor.beginTask(this.getName(), 100);
            long totalBytesDumped = 0L;
            long prevStatusUpdateTime = 0L;
            byte[] buffer = new byte[10000];
            try {
                NumberFormat numberFormat = NumberFormat.getInstance();
                Throwable throwable = null;
                Object var8_7 = null;
                try (FileOutputStream output = new FileOutputStream(this.outFile);){
                    int count;
                    while ((count = this.input.read(buffer)) > 0) {
                        totalBytesDumped += (long)count;
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - prevStatusUpdateTime > 300L) {
                            this.monitor.subTask(String.valueOf(numberFormat.format(totalBytesDumped)) + " bytes");
                            prevStatusUpdateTime = currentTime;
                        }
                        ((OutputStream)output).write(buffer, 0, count);
                    }
                    output.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                this.monitor.done();
            }
        }
    }

    public static abstract class DumpJob
    extends Thread {
        protected DBRProgressMonitor monitor;
        protected InputStream input;
        protected File outFile;
        protected Log log;

        protected DumpJob(String name, DBRProgressMonitor monitor, InputStream stream, File outFile, Log log) {
            super(name);
            this.monitor = monitor;
            this.input = stream;
            this.outFile = outFile;
            this.log = log;
        }

        @Override
        public final void run() {
            try {
                this.runDump();
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
        }

        protected abstract void runDump() throws IOException;
    }

    private static class LogReaderJob
    extends Thread {
        private DBTTask task;
        private SETTINGS settings;
        private PrintStream logWriter;
        private ProcessBuilder processBuilder;
        private InputStream input;
        final /* synthetic */ AbstractNativeToolHandler this$0;

        protected LogReaderJob(DBTTask task, SETTINGS settings, ProcessBuilder processBuilder, InputStream stream) {
            this.this$0 = var1_1;
            super("Log reader for " + task.getName());
            this.task = task;
            this.settings = settings;
            this.logWriter = ((AbstractNativeToolSettings)settings).getLogWriter();
            this.processBuilder = processBuilder;
            this.input = stream;
        }

        @Override
        public void run() {
            String lf = GeneralUtils.getDefaultLineSeparator();
            List<String> command = this.processBuilder.command();
            StringBuilder cmdString = new StringBuilder();
            for (String cmd : command) {
                if (NativeToolUtils.isSecureString(this.settings, cmd)) {
                    cmd = "******";
                }
                if (cmdString.length() > 0) {
                    cmdString.append(' ');
                }
                cmdString.append(cmd);
            }
            cmdString.append(lf);
            try {
                try {
                    this.logWriter.print(cmdString.toString());
                    this.logWriter.print("Task '" + this.task.getName() + "' started at " + new Date() + lf);
                    this.logWriter.flush();
                    InputStream in = this.input;
                    Object object = null;
                    Object var6_8 = null;
                    try (InputStreamReader reader = new InputStreamReader(in, GeneralUtils.getDefaultConsoleEncoding());){
                        int b;
                        StringBuilder buf = new StringBuilder();
                        while ((b = ((Reader)reader).read()) != -1) {
                            buf.append((char)b);
                            if (b != 10) continue;
                            this.logWriter.println(buf.toString());
                            this.logWriter.flush();
                            buf.setLength(0);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException e) {
                    this.logWriter.println(String.valueOf(e.getMessage()) + lf);
                    this.logWriter.print("Task '" + this.task.getName() + "' finished at " + new Date() + lf);
                    this.logWriter.flush();
                }
            }
            finally {
                this.logWriter.print("Task '" + this.task.getName() + "' finished at " + new Date() + lf);
                this.logWriter.flush();
            }
        }
    }

    private class NullReaderJob
    extends Thread {
        private InputStream input;

        protected NullReaderJob(DBTTask task, InputStream stream) {
            super("Task " + task.getName() + " log reader");
            this.input = stream;
        }

        @Override
        public void run() {
            try {
                int count;
                byte[] buffer = new byte[1000];
                while ((count = this.input.read(buffer)) > 0) {
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static class TextFileTransformerJob
    extends Thread {
        private final DBRProgressMonitor monitor;
        private final DBTTask task;
        private OutputStream output;
        private File inputFile;
        private String inputCharset;
        private String outputCharset;
        private Log log;

        public TextFileTransformerJob(DBRProgressMonitor monitor, DBTTask task, File inputFile, OutputStream stream, String inputCharset, String outputCharset, Log log) {
            super(task.getName());
            this.monitor = monitor;
            this.task = task;
            this.output = stream;
            this.inputFile = inputFile;
            this.inputCharset = inputCharset;
            this.outputCharset = outputCharset;
            this.log = log;
        }

        @Override
        public void run() {
            try {
                try {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (ProgressStreamReader scriptStream = new ProgressStreamReader(this.monitor, this.task.getName(), (InputStream)new FileInputStream(this.inputFile), this.inputFile.length());){
                            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)scriptStream, this.inputCharset));
                            PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.output, this.outputCharset));
                            while (!this.monitor.isCanceled()) {
                                String line = reader.readLine();
                                if (line == null) break;
                                writer.println(line);
                                writer.flush();
                            }
                            this.output.flush();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        IOUtils.close((Closeable)this.output);
                    }
                }
                catch (IOException e) {
                    this.log.error((Object)e);
                    this.monitor.done();
                }
            }
            finally {
                this.monitor.done();
            }
        }
    }
}

