/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.DBDummyNumberTransformer;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCAttribute;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt4;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCTableColumn<TABLE_TYPE extends DBSEntity>
extends JDBCAttribute
implements DBSTableColumn,
DBSEntityAttribute,
DBSAttributeEnumerable,
DBPSaveableObject {
    private static final Log log = Log.getLog(JDBCTableColumn.class);
    private final TABLE_TYPE table;
    private boolean persisted;
    private String defaultValue;

    protected JDBCTableColumn(TABLE_TYPE table, boolean persisted) {
        this.table = table;
        this.persisted = persisted;
    }

    protected JDBCTableColumn(TABLE_TYPE table, boolean persisted, String name, String typeName, int valueType, int ordinalPosition, long maxLength, Integer scale, Integer precision, boolean required, boolean autoGenerated, String defaultValue) {
        super(name, typeName, valueType, ordinalPosition, maxLength, scale, precision, required, autoGenerated);
        this.defaultValue = defaultValue;
        this.table = table;
        this.persisted = persisted;
    }

    protected JDBCTableColumn(TABLE_TYPE table, DBSEntityAttribute source, boolean persisted) {
        super(source);
        this.table = table;
        this.persisted = persisted;
        this.defaultValue = source.getDefaultValue();
    }

    public TABLE_TYPE getTable() {
        return this.table;
    }

    @NotNull
    public TABLE_TYPE getParentObject() {
        return this.getTable();
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=10)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, editable=true, order=20, listProvider=ColumnTypeNameListProvider.class)
    public String getTypeName() {
        return super.getTypeName();
    }

    @Override
    public void setTypeName(String typeName) throws DBException {
        super.setTypeName(typeName);
        DBPDataTypeProvider dataTypeProvider = DBUtils.getParentOfType(DBPDataTypeProvider.class, this);
        if (dataTypeProvider != null) {
            DBSDataType dataType = dataTypeProvider.getLocalDataType(typeName);
            if (dataType != null) {
                this.valueType = dataType.getTypeID();
                if (this instanceof DBSTypedObjectExt4) {
                    try {
                        ((DBSTypedObjectExt4)((Object)this)).setDataType(dataType);
                    }
                    catch (Throwable e) {
                        log.debug(e);
                    }
                }
            } else {
                this.valueType = -1;
            }
        }
    }

    @Override
    @Property(viewable=true, editable=true, order=40, valueRenderer=DBDummyNumberTransformer.class)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    @Override
    @Property(viewable=true, editable=true, order=50)
    public boolean isRequired() {
        return super.isRequired();
    }

    @Override
    @Property(viewable=true, editable=true, order=70)
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public List<DBDLabelValuePair> getValueEnumeration(@NotNull DBCSession session, @Nullable Object valuePattern, int maxResults, boolean calcCount, boolean formatValues, boolean caseInsensitiveSearch) throws DBException {
        String identifier = DBUtils.getQuotedIdentifier(this);
        DBDValueHandler valueHandler = DBUtils.findValueHandler(session, (DBSTypedObject)this);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        if (!calcCount) {
            query.append("DISTINCT ");
        }
        query.append(identifier);
        if (calcCount) {
            query.append(", count(*)");
        } else {
            query.append(", NULL");
        }
        query.append("\nFROM ").append(DBUtils.getObjectFullName(this.getTable(), DBPEvaluationContext.DML));
        if (valuePattern instanceof String) {
            query.append("\nWHERE ");
            if (this.getDataKind() == DBPDataKind.STRING) {
                SQLExpressionFormatter caseInsensitiveFormatter;
                SQLDialect dialect = this.getDataSource().getSQLDialect();
                SQLExpressionFormatter sQLExpressionFormatter = caseInsensitiveFormatter = caseInsensitiveSearch ? dialect.getCaseInsensitiveExpressionFormatter(DBCLogicalOperator.LIKE) : null;
                if (caseInsensitiveSearch && caseInsensitiveFormatter != null) {
                    query.append(caseInsensitiveFormatter.format(identifier, "?"));
                } else {
                    query.append(identifier).append(" LIKE ?");
                }
            } else {
                query.append(identifier).append(" = ?");
            }
        }
        if (calcCount) {
            query.append("\nGROUP BY ").append(identifier);
            query.append("\nORDER BY 2 DESC");
        } else {
            query.append("\nORDER BY 1");
        }
        Throwable throwable = null;
        Object var11_12 = null;
        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, false);){
            if (valuePattern instanceof String) {
                if (this.getDataKind() == DBPDataKind.STRING) {
                    valueHandler.bindValueObject(session, dbStat, this, 0, "%" + valuePattern + "%");
                } else {
                    valueHandler.bindValueObject(session, dbStat, this, 0, valuePattern);
                }
            }
            dbStat.setLimit(0L, maxResults);
            if (dbStat.executeStatement()) {
                List<DBDLabelValuePair> list;
                DBCResultSet dbResult;
                Throwable throwable2;
                block33: {
                    throwable2 = null;
                    Object var14_17 = null;
                    dbResult = dbStat.openResultSet();
                    list = DBVUtils.readDictionaryRows(session, this, valueHandler, dbResult, formatValues, calcCount);
                    if (dbResult == null) break block33;
                    dbResult.close();
                }
                return list;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            return Collections.emptyList();
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public static class ColumnTypeNameListProvider
    implements IPropertyValueListProvider<JDBCTableColumn<?>> {
        @Override
        public boolean allowCustomValue() {
            return true;
        }

        @Override
        public Object[] getPossibleValues(JDBCTableColumn<?> column) {
            TreeSet<String> typeNames = new TreeSet<String>();
            if (column.getDataSource() instanceof DBPDataTypeProvider) {
                for (DBSDataType dBSDataType : ((DBPDataTypeProvider)((Object)column.getDataSource())).getLocalDataTypes()) {
                    if (dBSDataType.getDataKind() == DBPDataKind.UNKNOWN || CommonUtils.isEmpty((String)dBSDataType.getName()) || !Character.isLetter(dBSDataType.getName().charAt(0))) continue;
                    typeNames.add(dBSDataType.getName());
                }
            }
            return typeNames.toArray(new String[0]);
        }
    }
}

