/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.NIOFile;
import org.jkiss.dbeaver.model.fs.nio.NIOFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.NIOFolder;
import org.jkiss.dbeaver.model.fs.nio.NIOResource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNPath;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class DBNPathBase
extends DBNNode
implements DBNNodeWithResource,
DBNLazyNode {
    private static final Log log = Log.getLog(DBNPathBase.class);
    private static final DBNNode[] EMPTY_NODES = new DBNNode[0];
    private DBNNode[] children;
    private DBPImage resImage;

    protected DBNPathBase(DBNNode parentNode) {
        super(parentNode);
    }

    protected abstract Path getPath();

    @Override
    protected void dispose(boolean reflect) {
        this.children = null;
        super.dispose(reflect);
    }

    @Override
    public IResource getResource() {
        return this.getAdapter(IResource.class);
    }

    @Override
    public DBPImage getResourceImage() {
        return this.resImage;
    }

    @Override
    public void setResourceImage(DBPImage resourceImage) {
        this.resImage = resourceImage;
    }

    @Override
    public String getNodeType() {
        return "Path";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeName() {
        return this.getFileName();
    }

    private String getFileName() {
        Path path = this.getPath();
        Path fileName = path.getFileName();
        if (fileName == null) {
            String uriPath;
            String virtName = null;
            URI uri = path.toUri();
            if (uri != null && !CommonUtils.isEmpty((String)(uriPath = uri.getPath()))) {
                virtName = uriPath;
            }
            if (virtName == null) {
                virtName = path.toString();
            }
            return CommonUtils.removeTrailingSlash((String)CommonUtils.removeLeadingSlash(virtName));
        }
        return fileName.toString();
    }

    @Override
    public String getNodeDescription() {
        return null;
    }

    @Override
    public DBPImage getNodeIcon() {
        if (this.resImage != null) {
            return this.resImage;
        }
        return this.allowsChildren() ? DBIcon.TREE_FOLDER : DBIcon.TREE_FILE;
    }

    @Override
    public boolean allowsChildren() {
        return Files.isDirectory(this.getPath(), new LinkOption[0]);
    }

    @Override
    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && this.allowsChildren()) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNNode[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<DBNNode> result = new ArrayList<DBNNode>();
        Path path = this.getPath();
        if (this.allowsChildren() && Files.exists(path, new LinkOption[0])) {
            try {
                Files.list(path).forEach(c -> {
                    DBNPathBase newChild = this.makeNode((Path)c);
                    if (newChild != null) {
                        result.add(newChild);
                    }
                });
            }
            catch (IOException e) {
                throw new DBException("Error reading directory members", e);
            }
        }
        if (result.isEmpty()) {
            return EMPTY_NODES;
        }
        this.filterChildren(result);
        DBNNode[] childNodes = result.toArray(new DBNNode[0]);
        this.sortChildren(childNodes);
        return childNodes;
    }

    private DBNPathBase getChild(Path thePath) {
        if (this.children == null) {
            return null;
        }
        DBNNode[] dBNNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child instanceof DBNPathBase && thePath.equals(((DBNPathBase)child).getPath())) {
                return (DBNPathBase)child;
            }
            ++n2;
        }
        return null;
    }

    private DBNPathBase makeNode(Path resource) {
        return new DBNPath(this, resource);
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        this.children = null;
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, DBNEvent.NodeChange.REFRESH, this));
        return this;
    }

    @Override
    public String getNodeItemPath() {
        return String.valueOf(this.getParentNode().getNodeItemPath()) + "/" + this.getFileName();
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        Path path = this.getPath();
        try {
            Files.move(path, path.getParent().resolve(newName), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new DBException("Can't rename resource", e);
        }
    }

    @Override
    public boolean supportsDrop(DBNNode otherNode) {
        if (!this.allowsChildren()) {
            return false;
        }
        if (otherNode == null) {
            return true;
        }
        return otherNode instanceof DBNPathBase && otherNode != this && otherNode.getParentNode() != this && !this.isChildOf(otherNode);
    }

    @Override
    public void dropNodes(Collection<DBNNode> nodes) throws DBException {
        throw new DBException("Not implemented");
    }

    protected void filterChildren(List<DBNNode> list) {
    }

    protected void sortChildren(DBNNode[] list) {
        Arrays.sort(list, (o1, o2) -> {
            if (o1 instanceof DBNPathBase && o2 instanceof DBNPathBase) {
                Path res1 = ((DBNPathBase)o1).getPath();
                Path res2 = ((DBNPathBase)o2).getPath();
                if (res1 instanceof IFolder && !(res2 instanceof IFolder)) {
                    return -1;
                }
                if (res2 instanceof IFolder && !(res1 instanceof IFolder)) {
                    return 1;
                }
            }
            return o1.getNodeName().compareToIgnoreCase(o2.getNodeName());
        });
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        return Collections.emptyList();
    }

    public void refreshResourceState(Object source) {
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, this));
    }

    @Property(viewable=true, order=10)
    public String getResourcePath() {
        return this.getPath() == null ? "" : this.getPath().toAbsolutePath().toString();
    }

    @Property(viewable=false, order=11)
    public String getResourceLocation() {
        return this.getPath() == null ? "" : this.getPath().toString();
    }

    @Property(viewable=true, order=11)
    public long getResourceSize() throws IOException {
        return this.getPath() == null ? 0L : Files.size(this.getPath());
    }

    @Property(viewable=true, order=11)
    public String getResourceLastModified() throws IOException {
        return Files.getLastModifiedTime(this.getPath(), new LinkOption[0]).toString();
    }

    protected boolean isResourceExists() {
        return this.getPath() != null && Files.exists(this.getPath(), new LinkOption[0]);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == Path.class) {
            return adapter.cast(this.getPath());
        }
        if (adapter == IResource.class) {
            DBNFileSystemRoot rootNode = DBNUtils.getParentOfType(DBNFileSystemRoot.class, this);
            if (rootNode == null) {
                return null;
            }
            Path rootPath = rootNode.getPath();
            DBFVirtualFileSystemRoot fsRoot = rootNode.getRoot();
            NIOFileSystemRoot root = new NIOFileSystemRoot(this.getOwnerProject().getEclipseProject(), String.valueOf(fsRoot.getFileSystem().getType()) + "/" + fsRoot.getFileSystem().getId() + "/" + fsRoot.getId(), rootPath);
            Path path = this.getPath();
            NIOResource resource = this.allowsChildren() ? new NIOFolder(root, path) : new NIOFile(root, path);
            return adapter.cast((Object)resource);
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        Path path = this.getPath();
        return path == null ? super.toString() : path.toString();
    }

    @Override
    public boolean needsInitialization() {
        return this.children == null;
    }
}

