/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;

public class NavigatorObjectsDeleter {
    private static final Log log = Log.getLog(NavigatorObjectsDeleter.class);
    private final List<DBRRunnableWithProgress> tasksToExecute = new ArrayList<DBRRunnableWithProgress>();
    private final IWorkbenchWindow window;
    @Nullable
    private DBECommandContext commandContext;
    private final List<?> selection;
    private final boolean selectedFromNavigator;
    private final boolean supportsShowViewScript;
    private final boolean supportsDeleteContents;
    private boolean deleteContent;
    private final Set<Option> supportedOptions;
    private final Set<Option> enabledOptions = new HashSet<Option>();

    private NavigatorObjectsDeleter(IWorkbenchWindow window, List<?> selection, boolean selectedFromNavigator, boolean supportsShowViewScript, boolean supportsDeleteContents, Set<Option> supportedOptions) {
        this.window = window;
        this.selection = selection;
        this.selectedFromNavigator = selectedFromNavigator;
        this.supportsShowViewScript = supportsShowViewScript;
        this.supportsDeleteContents = supportsDeleteContents;
        this.supportedOptions = supportedOptions;
    }

    static NavigatorObjectsDeleter of(List<?> selection, IWorkbenchWindow window) {
        boolean supportsShowViewScript = false;
        boolean supportsDeleteContents = false;
        boolean selectedFromNavigator = window.getPartService().getActivePart() instanceof NavigatorViewBase;
        HashSet<Option> supportedOptions = new HashSet<Option>();
        for (Object obj : selection) {
            NavigatorHandlerObjectBase.CommandTarget commandTarget;
            DBEObjectMaker objectMaker;
            DBSObject object;
            DBNDatabaseNode node;
            if (obj instanceof DBNProject) {
                supportsDeleteContents = true;
                continue;
            }
            if (!(obj instanceof DBNDatabaseNode) || !((node = (DBNDatabaseNode)obj).getParentNode() instanceof DBNContainer) || (object = node.getObject()) == null || (objectMaker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectMaker.class)) == null) continue;
            Option[] optionArray = Option.values();
            int n = optionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Option option = optionArray[n2];
                if (NavigatorObjectsDeleter.supportsFeature(objectMaker, object.getDataSource(), option.featureValue)) {
                    supportedOptions.add(option);
                }
                ++n2;
            }
            try {
                commandTarget = NavigatorHandlerObjectBase.getCommandTarget(window, node.getParentNode(), null, object.getClass(), false);
            }
            catch (DBException dBException) {
                continue;
            }
            if (!object.isPersisted() || commandTarget.getEditor() != null || commandTarget.getContext() == null) continue;
            supportsShowViewScript = true;
        }
        return new NavigatorObjectsDeleter(window, selection, selectedFromNavigator, supportsShowViewScript, supportsDeleteContents, supportedOptions);
    }

    private static boolean supportsFeature(@NotNull DBEObjectMaker<?, ?> objectMaker, DBPDataSource dataSource, long feature) {
        return (objectMaker.getMakerOptions(dataSource) & feature) != 0L;
    }

    public IProject getProjectToDelete() {
        for (Object obj : this.selection) {
            if (!(obj instanceof DBNProject)) continue;
            return ((DBNProject)obj).getProject().getEclipseProject();
        }
        return null;
    }

    void delete() {
        for (Object obj : this.selection) {
            if (obj instanceof DBNDatabaseNode) {
                this.deleteDatabaseNode((DBNDatabaseNode)obj);
                continue;
            }
            if (obj instanceof DBNResource) {
                this.deleteResource((DBNResource)obj);
                continue;
            }
            if (obj instanceof DBNLocalFolder) {
                this.deleteLocalFolder((DBNLocalFolder)obj);
                continue;
            }
            log.warn((Object)("Don't know how to delete element '" + obj + "'"));
        }
        if (!this.tasksToExecute.isEmpty()) {
            TasksJob.runTasks((String)(this.tasksToExecute.size() > 1 ? "Delete " + this.tasksToExecute.size() + " objects" : "Delete object"), this.tasksToExecute);
        }
    }

    private void deleteLocalFolder(DBNLocalFolder folder) {
        folder.getDataSourceRegistry().removeFolder(folder.getFolder(), false);
        DBNModel.updateConfigAndRefreshDatabases((DBNNode)folder);
    }

    private void deleteResource(DBNResource resourceNode) {
        IResource resource = resourceNode.getResource();
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (resource instanceof IFolder) {
                ((IFolder)resource).delete(true, true, (IProgressMonitor)monitor);
            } else if (resource instanceof IProject) {
                DBWorkbench.getPlatform().getGlobalEventManager().fireGlobalEvent("beforeProjectDelete", Map.of("project", resource.getName()));
                ((IProject)resource).delete(this.deleteContent, true, (IProgressMonitor)monitor);
            } else if (resource != null) {
                resource.delete(3, (IProgressMonitor)monitor);
            }
        }
        catch (CoreException e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.error_deleting_resource_title, NLS.bind((String)UINavigatorMessages.error_deleting_resource_message, (Object)resource.getFullPath().toString()), (Throwable)e);
        }
    }

    private void deleteDatabaseNode(DBNDatabaseNode node) {
        try {
            if (!(node.getParentNode() instanceof DBNContainer)) {
                throw new DBException("Node '" + node + "' doesn't have a container");
            }
            DBSObject object = node.getObject();
            if (object == null) {
                throw new DBException("Can't delete node with null object");
            }
            DBEObjectMaker objectMaker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectMaker.class);
            if (objectMaker == null) {
                throw new DBException("Object maker not found for type '" + object.getClass().getName() + "'");
            }
            NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectBase.getCommandTarget(this.window, node.getParentNode(), null, object.getClass(), false);
            if ((!object.isPersisted() || commandTarget.getEditor() != null) && this.deleteNewObject(node)) {
                return;
            }
            Map<String, Object> deleteOptions = this.collectObjectMakerOptionsMap(object, objectMaker);
            objectMaker.deleteObject(commandTarget.getContext(), node.getObject(), deleteOptions);
            if (commandTarget.getEditor() == null && commandTarget.getContext() != null) {
                NavigatorHandlerObjectBase.ObjectSaver deleter = new NavigatorHandlerObjectBase.ObjectSaver(commandTarget.getContext(), deleteOptions);
                this.tasksToExecute.add(deleter);
            }
            if (commandTarget.getEditor() != null && this.selectedFromNavigator) {
                UIUtils.getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)commandTarget.getEditor());
                DBWorkbench.getPlatformUI().showMessageBox(UINavigatorMessages.actions_navigator_persist_delete_in_the_editor_title, NLS.bind((String)UINavigatorMessages.actions_navigator_persist_delete_in_the_editor_message, (Object)commandTarget.getEditor().getTitle()), false);
            }
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_error_dialog_delete_object_title, NLS.bind((String)UINavigatorMessages.actions_navigator_error_dialog_delete_object_message, (Object)node.getNodeName()), e);
        }
    }

    private boolean deleteNewObject(DBNDatabaseNode node) {
        IEditorReference[] iEditorReferenceArray = this.window.getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorInput editorInput;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editor = editorRef.getEditor(false);
            if (editor instanceof IDatabaseEditor && (editorInput = editor.getEditorInput()) instanceof IDatabaseEditorInput && ((IDatabaseEditorInput)editorInput).getDatabaseObject() == node.getObject()) {
                this.window.getActivePage().closeEditor(editor, false);
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean showScriptWindow() {
        String sql = this.collectSQL();
        boolean result = false;
        if (sql.length() > 0) {
            UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
            if (serviceSQL != null) {
                result = serviceSQL.openSQLViewer(this.commandContext.getExecutionContext(), UINavigatorMessages.actions_navigator_delete_script, (DBPImage)UIIcon.SQL_PREVIEW, sql, true, false) == 10;
            }
        } else {
            result = UIUtils.confirmAction((Shell)this.window.getShell(), (String)UINavigatorMessages.actions_navigator_delete_script, (String)UINavigatorMessages.question_no_sql_available);
        }
        this.commandContext.resetChanges(!result);
        return result;
    }

    private String collectSQL() {
        StringBuilder sql = new StringBuilder();
        try {
            UIUtils.runInProgressService(monitor -> {
                for (Object obj : this.selection) {
                    if (!(obj instanceof DBNDatabaseNode)) continue;
                    this.appendScript(monitor, sql, (DBNDatabaseNode)obj);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.error_sql_generation_title, UINavigatorMessages.error_sql_generation_message, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        return sql.toString();
    }

    private void appendScript(DBRProgressMonitor monitor, StringBuilder sql, DBNDatabaseNode node) throws InvocationTargetException {
        NavigatorHandlerObjectBase.CommandTarget commandTarget;
        if (!(node.getParentNode() instanceof DBNContainer)) {
            return;
        }
        DBSObject object = node.getObject();
        if (object == null) {
            return;
        }
        DBEObjectMaker objectMaker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectMaker.class);
        if (objectMaker == null) {
            return;
        }
        try {
            commandTarget = NavigatorHandlerObjectBase.getCommandTarget(this.window, node.getParentNode(), null, object.getClass(), false);
        }
        catch (DBException e) {
            log.warn((Object)e);
            return;
        }
        if (this.commandContext == null) {
            this.commandContext = commandTarget.getContext();
        }
        if (!object.isPersisted() || commandTarget.getEditor() != null) {
            return;
        }
        Map<String, Object> deleteOptions = this.collectObjectMakerOptionsMap(object, objectMaker);
        try {
            objectMaker.deleteObject(commandTarget.getContext(), node.getObject(), deleteOptions);
        }
        catch (DBException e) {
            log.warn((Object)e);
            return;
        }
        StringBuilder script = new StringBuilder();
        DBECommandContext commandContext = commandTarget.getContext();
        Collection commands = commandContext.getFinalCommands();
        try {
            for (DBECommand command : commands) {
                DBEPersistAction[] persistActions = command.getPersistActions(monitor, commandContext.getExecutionContext(), deleteOptions);
                script.append(SQLUtils.generateScript((DBPDataSource)commandContext.getExecutionContext().getDataSource(), (DBEPersistAction[])persistActions, (boolean)false));
                if (script.length() != 0) continue;
                script.append(SQLUtils.generateComments((DBPDataSource)commandContext.getExecutionContext().getDataSource(), (DBEPersistAction[])persistActions, (boolean)false));
            }
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
        commandTarget.getContext().resetChanges(true);
        if (sql.length() != 0) {
            sql.append("\n");
        }
        sql.append((CharSequence)script);
    }

    public boolean supportsShowViewScript() {
        return this.supportsShowViewScript;
    }

    public boolean supportsDeleteContents() {
        return this.supportsDeleteContents;
    }

    public void setDeleteContents(boolean deleteContents) {
        this.deleteContent = deleteContents;
    }

    public Set<Option> getSupportedOptions() {
        return Collections.unmodifiableSet(this.supportedOptions);
    }

    public void enableOption(@NotNull Option option) {
        this.enabledOptions.add(option);
    }

    public void disableOption(@NotNull Option option) {
        this.enabledOptions.remove((Object)option);
    }

    private Map<String, Object> collectObjectMakerOptionsMap(@NotNull DBSObject object, @NotNull DBEObjectMaker<?, ?> objectMaker) {
        HashMap<String, Object> objectMakerOptionsMap = new HashMap<String, Object>();
        DBPDataSource dataSource = object.getDataSource();
        for (Option option : this.enabledOptions) {
            if (!NavigatorObjectsDeleter.supportsFeature(objectMaker, dataSource, option.featureValue)) continue;
            objectMakerOptionsMap.put(option.optionValue, Boolean.TRUE);
        }
        return objectMakerOptionsMap;
    }

    public static enum Option {
        DELETE_CASCADE(8L, "deleteCascade", UINavigatorMessages.confirm_deleting_delete_cascade_checkbox_label, UINavigatorMessages.confirm_deleting_delete_cascade_checkbox_tooltip),
        CLOSE_EXISTING_CONNECTIONS(32L, "closeExistingConnections", UINavigatorMessages.confirm_deleting_close_existing_connections_checkbox_label, UINavigatorMessages.confirm_deleting_close_existing_connections_checkbox_tooltip);

        private final long featureValue;
        private final String optionValue;
        private final String label;
        private final String tip;

        private Option(@NotNull long featureValue, @NotNull String optionValue, String label, String tip) {
            this.featureValue = featureValue;
            this.optionValue = optionValue;
            this.label = label;
            this.tip = tip;
        }

        public String getLabel() {
            return this.label;
        }

        public String getTip() {
            return this.tip;
        }
    }
}

