/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.ext.postgresql.ui.PostgreConnectionPageAdvanced;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class PostgreConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final Log log = Log.getLog(PostgreConnectionPage.class);
    private Text hostText;
    private Text portText;
    private Text dbText;
    private Text roleText;
    private ClientHomesSelector homesSelector;
    private boolean activated = false;

    public void dispose() {
        super.dispose();
    }

    public Image getImage() {
        DBPDriver driver = this.site.getDriver();
        PostgreServerType serverType = PostgreUtils.getServerType((DBPDriver)driver);
        return DBeaverIcons.getImage((DBPImage)serverType.getIcon());
    }

    public void createControl(Composite composite) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.site.updateButtons();
            }
        };
        DBPDriver driver = this.site.getDriver();
        PostgreServerType serverType = PostgreUtils.getServerType((DBPDriver)driver);
        Composite mainGroup = new Composite(composite, 0);
        mainGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        mainGroup.setLayoutData((Object)gd);
        Group addrGroup = UIUtils.createControlGroup((Composite)mainGroup, (String)"Server", (int)4, (int)768, (int)0);
        this.hostText = UIUtils.createLabelText((Composite)addrGroup, (String)(serverType.isCloudServer() ? PostgreMessages.dialog_setting_connection_cloud_instance : PostgreMessages.dialog_setting_connection_host), null, (int)2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        if (serverType.needsPort()) {
            this.portText = UIUtils.createLabelText((Composite)addrGroup, (String)PostgreMessages.dialog_setting_connection_port, null, (int)2048);
            gd = new GridData(2);
            gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
            this.portText.setLayoutData((Object)gd);
            this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
            this.portText.addModifyListener(textListener);
        } else {
            gd.horizontalSpan = 3;
        }
        this.dbText = UIUtils.createLabelText((Composite)addrGroup, (String)PostgreMessages.dialog_setting_connection_database, null, (int)2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        this.dbText.addModifyListener(textListener);
        this.createAuthPanel(mainGroup, 1);
        if (this.isSessionRoleSupported() || serverType.supportsClient()) {
            Group advancedGroup = UIUtils.createControlGroup((Composite)mainGroup, (String)"Advanced", (int)4, (int)32, (int)0);
            if (this.isSessionRoleSupported()) {
                this.roleText = UIUtils.createLabelText((Composite)advancedGroup, (String)PostgreMessages.dialog_setting_session_role, null, (int)2048);
                this.roleText.setToolTipText(PostgreMessages.dialog_setting_session_role_tip);
                gd = new GridData(32);
                gd.widthHint = UIUtils.getFontHeight((Control)this.roleText) * 15;
                this.roleText.setLayoutData((Object)gd);
            }
            if (!DBWorkbench.getPlatform().getApplication().hasProductFeature("simpleDatabaseAdministration") && serverType.supportsClient()) {
                this.homesSelector = new ClientHomesSelector((Composite)advancedGroup, PostgreMessages.dialog_setting_connection_localClient, false);
                gd = new GridData(800);
                this.homesSelector.getPanel().setLayoutData((Object)gd);
            }
        }
        this.createDriverPanel(mainGroup);
        this.setControl((Control)mainGroup);
    }

    protected boolean isSessionRoleSupported() {
        return true;
    }

    public boolean isComplete() {
        return super.isComplete() && this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && (this.portText == null || !CommonUtils.isEmpty((String)this.portText.getText()));
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        DBPDriver driver = this.site.getDriver();
        super.loadSettings();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                Object defaultHost = driver.getDriverParameter("defaultHost");
                this.hostText.setText(defaultHost != null ? defaultHost.toString() : "localhost");
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.getSite().isNew()) {
                this.portText.setText(CommonUtils.notEmpty((String)driver.getDefaultPort()));
            }
        }
        if (this.dbText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                if (this.getSite().isNew()) {
                    databaseName = driver.getDefaultDatabase();
                    if (CommonUtils.isEmpty((String)databaseName)) {
                        databaseName = "postgres";
                    }
                } else {
                    databaseName = "";
                }
            }
            this.dbText.setText(databaseName);
        }
        if (this.roleText != null) {
            this.roleText.setText(CommonUtils.notEmpty((String)connectionInfo.getProviderProperty("@dbeaver-chosen-role@")));
        }
        if (this.homesSelector != null) {
            this.homesSelector.populateHomes(driver, connectionInfo.getClientHomeId(), this.site.isNew());
        }
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.roleText != null) {
            connectionInfo.setProviderProperty("@dbeaver-chosen-role@", this.roleText.getText().trim());
        }
        if (this.homesSelector != null) {
            connectionInfo.setClientHomeId(this.homesSelector.getSelectedHome());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new PostgreConnectionPageAdvanced(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

