/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.Token;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleScanner;

public class SQLTokenAdapter
extends Token {
    private final TPToken token;

    SQLTokenAdapter(TPToken token, SQLRuleScanner scanner) {
        super((Object)SQLTokenAdapter.makeTextAttribute(token, scanner));
        this.token = token;
    }

    public TPToken getToken() {
        return this.token;
    }

    public String toString() {
        return "Adapter of [" + this.token.toString() + "]";
    }

    private static TextAttribute makeTextAttribute(TPToken token, SQLRuleScanner scanner) {
        if (token instanceof TPTokenDefault && token.getData() instanceof SQLTokenType) {
            switch ((SQLTokenType)token.getData()) {
                case T_KEYWORD: 
                case T_BLOCK_BEGIN: 
                case T_BLOCK_END: 
                case T_BLOCK_HEADER: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.keyword.foreground"), null, scanner.getKeywordStyle());
                }
                case T_STRING: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.string.foreground"), null, scanner.getKeywordStyle());
                }
                case T_QUOTED: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.datatype.foreground"), null, scanner.getKeywordStyle());
                }
                case T_TYPE: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.datatype.foreground"), null, scanner.getKeywordStyle());
                }
                case T_NUMBER: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.number.foreground"), null, 0);
                }
                case T_COMMENT: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.comment.foreground"), null, 0);
                }
                case T_DELIMITER: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.delimiter.foreground"), null, 0);
                }
                case T_BLOCK_TOGGLE: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.delimiter.foreground"), null, scanner.getKeywordStyle());
                }
                case T_CONTROL: 
                case T_SET_DELIMITER: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.command.foreground"), null, scanner.getKeywordStyle());
                }
                case T_PARAMETER: 
                case T_VARIABLE: {
                    return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.parameter.foreground"), null, scanner.getKeywordStyle());
                }
            }
        }
        return new TextAttribute(scanner.getColor("org.jkiss.dbeaver.sql.editor.color.text.foreground"), null, 0);
    }
}

