/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPResourceHandlerDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeExtendable;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.registry.DBNRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;

public class DBNProject
extends DBNResource
implements DBNNodeExtendable {
    private static final Log log = Log.getLog(DBNProject.class);
    private final DBPProject project;
    private final List<DBNNode> extraNodes = new ArrayList<DBNNode>();

    public DBNProject(DBNNode parentNode, DBPProject project, DBPResourceHandler handler) {
        super(parentNode, (IResource)project.getEclipseProject(), handler);
        this.project = project;
        DBNRegistry.getInstance().extendNode(this, false);
    }

    public DBPProject getProject() {
        return this.project;
    }

    public DBNProjectDatabases getDatabases() {
        try {
            DBNNode[] dBNNodeArray = this.getChildren(new VoidProgressMonitor());
            int n = dBNNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode db = dBNNodeArray[n2];
                if (db instanceof DBNProjectDatabases) {
                    return (DBNProjectDatabases)db;
                }
                ++n2;
            }
        }
        catch (DBException e) {
            throw new IllegalStateException("Can't read project contents", e);
        }
        throw new IllegalStateException("No databases resource in project");
    }

    @Override
    public String getNodeName() {
        return this.project.getName();
    }

    @Override
    public String getNodeDescription() {
        if (this.project.isVirtual()) {
            return null;
        }
        this.project.ensureOpen();
        try {
            return this.project.getEclipseProject().getDescription().getComment();
        }
        catch (CoreException e) {
            log.debug((Object)e);
            return null;
        }
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.PROJECT;
    }

    @Override
    public boolean allowsOpen() {
        return true;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBNProject.class) {
            return adapter.cast(this);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public DBPProject getOwnerProject() {
        return this.project;
    }

    @Override
    public boolean supportsRename() {
        return !this.project.isVirtual();
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        this.project.ensureOpen();
        try {
            IProjectDescription description = this.project.getEclipseProject().getDescription();
            description.setName(newName);
            this.project.getEclipseProject().move(description, true, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            throw new DBException("Can't rename project", e);
        }
    }

    @Override
    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        this.project.ensureOpen();
        if (!this.project.getEclipseProject().isOpen()) {
            return new DBNNode[0];
        }
        ArrayList<DBNNode> childrenFiltered = new ArrayList<DBNNode>();
        Collections.addAll(childrenFiltered, super.getChildren(monitor));
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.folder.placeholders")) {
            childrenFiltered.removeIf(node -> node instanceof DBNResource && !((DBNResource)node).isResourceExists());
        }
        if (!this.extraNodes.isEmpty()) {
            childrenFiltered.addAll(this.extraNodes);
        }
        return childrenFiltered.toArray(new DBNNode[0]);
    }

    @Override
    protected DBNNode[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        DBNModel model = this.getModel();
        if (model.isGlobal() && !this.project.isOpen()) {
            this.project.ensureOpen();
        }
        Object[] children = super.readChildNodes(monitor);
        children = (DBNNode[])ArrayUtils.insertArea(DBNNode.class, (Object[])children, (int)0, (Object[])new Object[]{new DBNProjectDatabases(this, this.project.getDataSourceRegistry())});
        return children;
    }

    @Override
    protected IResource[] addImplicitMembers(IResource[] members) {
        DBPResourceHandlerDescriptor[] dBPResourceHandlerDescriptorArray = this.project.getWorkspace().getAllResourceHandlers();
        int n = dBPResourceHandlerDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPResourceHandlerDescriptor rh = dBPResourceHandlerDescriptorArray[n2];
            IFolder rhDefaultRoot = this.project.getWorkspace().getResourceDefaultRoot(this.getProject(), rh, false);
            if (rhDefaultRoot != null && !rhDefaultRoot.exists()) {
                members = (IResource[])ArrayUtils.add(IResource.class, (Object[])members, (Object)rhDefaultRoot);
            }
            ++n2;
        }
        return super.addImplicitMembers(members);
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        this.project.getDataSourceRegistry().refreshConfig();
        return super.refreshNode(monitor, source);
    }

    public DBNResource findResource(IResource resource) {
        ArrayList<IResource> path = new ArrayList<IResource>();
        IResource parent = resource;
        while (!(parent instanceof IProject)) {
            path.add(0, parent);
            parent = parent.getParent();
        }
        DBNResource resNode = this;
        for (IResource res : path) {
            try {
                ((DBNResource)resNode).getChildren(new VoidProgressMonitor());
            }
            catch (DBException e) {
                log.error(e);
            }
            resNode = resNode.getChild(res);
            if (resNode != null) continue;
            return null;
        }
        return resNode;
    }

    @Override
    protected void handleChildResourceChange(IResourceDelta delta) {
        String name = delta.getResource().getName();
        if (name.equals(".dbeaver")) {
            IResourceDelta[] configFiles = delta.getAffectedChildren();
            boolean dsChanged = false;
            if (configFiles != null) {
                IResourceDelta[] iResourceDeltaArray = configFiles;
                int n = configFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta rd = iResourceDeltaArray[n2];
                    IResource childRes = rd.getResource();
                    if (childRes instanceof IFile && childRes.getName().startsWith("data-sources")) {
                        dsChanged = true;
                    }
                    ++n2;
                }
            }
            if (dsChanged) {
                this.getDatabases().getDataSourceRegistry().refreshConfig();
            }
        } else {
            super.handleChildResourceChange(delta);
        }
    }

    @Override
    @NotNull
    public List<DBNNode> getExtraNodes() {
        return this.extraNodes;
    }

    public <T> T getExtraNode(Class<T> nodeType) {
        if (this.extraNodes != null) {
            for (DBNNode node : this.extraNodes) {
                if (!nodeType.isAssignableFrom(node.getClass())) continue;
                return nodeType.cast(node);
            }
        }
        return null;
    }

    @Override
    public void addExtraNode(@NotNull DBNNode node, boolean reflect) {
        this.extraNodes.add(node);
        this.extraNodes.sort(Comparator.comparing(DBNNode::getNodeName));
        if (reflect) {
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, node));
        }
    }

    @Override
    public void removeExtraNode(@NotNull DBNNode node) {
        if (this.extraNodes.remove(node)) {
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, node));
        }
    }

    @Override
    protected void dispose(boolean reflect) {
        for (DBNNode node : this.extraNodes) {
            node.dispose(reflect);
        }
        this.extraNodes.clear();
        super.dispose(reflect);
    }
}

