/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.mysql.model;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oceanbase.mysql.model.OceanbaseMySQLCatalog;
import org.jkiss.dbeaver.ext.oceanbase.mysql.model.OceanbaseMySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class OceanbaseMySQLDatabaseManager
extends SQLObjectEditor<OceanbaseMySQLCatalog, OceanbaseMySQLDataSource> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<? extends DBSObject, OceanbaseMySQLCatalog> getObjectsCache(OceanbaseMySQLCatalog object) {
        return ((OceanbaseMySQLDataSource)object.getDataSource()).getOceanbaseCatalogCache();
    }

    protected OceanbaseMySQLCatalog createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new OceanbaseMySQLCatalog((OceanbaseMySQLDataSource)((Object)container), null);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        OceanbaseMySQLCatalog catalog = (OceanbaseMySQLCatalog)command.getObject();
        StringBuilder script = new StringBuilder("CREATE SCHEMA `" + catalog.getName() + "`");
        this.appendDatabaseModifiers(catalog, script);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create schema", script.toString()));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP SCHEMA `" + ((OceanbaseMySQLCatalog)command.getObject()).getName() + "`"));
    }

    private void appendDatabaseModifiers(OceanbaseMySQLCatalog catalog, StringBuilder script) {
        if (catalog.getAdditionalInfo().getDefaultCharset() != null) {
            script.append("\nDEFAULT CHARACTER SET ").append(catalog.getAdditionalInfo().getDefaultCharset().getName());
        }
        if (catalog.getAdditionalInfo().getDefaultCollation() != null) {
            script.append("\nDEFAULT COLLATE ").append(catalog.getAdditionalInfo().getDefaultCollation().getName());
        }
    }
}

