/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.querylog;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMEvent;
import org.jkiss.dbeaver.model.qm.QMEventAction;
import org.jkiss.dbeaver.model.qm.QMEventBrowser;
import org.jkiss.dbeaver.model.qm.QMEventCursor;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMObjectType;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.filters.QMEventCriteria;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.qm.DefaultEventFilter;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.TableToolTip;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.controls.TableColumnSortListener;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.BaseSQLDialog;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.log.SQLLogFilter;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LongKeyMap;

public class QueryLogViewer
extends Viewer
implements QMMetaListener,
DBPPreferenceListener {
    private static final Log log = Log.getLog(QueryLogViewer.class);
    private static final String QUERY_LOG_CONTROL_ID = "org.jkiss.dbeaver.ui.qm.log";
    private static final String VIEWER_ID = "DBeaver.QM.LogViewer";
    private static final int MIN_ENTRIES_PER_PAGE = 1;
    public static final String COLOR_UNCOMMITTED = "org.jkiss.dbeaver.txn.color.committed.background";
    public static final String COLOR_REVERTED = "org.jkiss.dbeaver.txn.color.reverted.background";
    public static final String COLOR_TRANSACTION = "org.jkiss.dbeaver.txn.color.transaction.background";
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private final IPropertyChangeListener themePropertiesListener;
    private LogColumn COLUMN_TIME = new LogColumn("time", ModelMessages.controls_querylog_column_time_name, ModelMessages.controls_querylog_column_time_tooltip, 80){
        private final DateFormat timeFormat;
        private final DateFormat timestampFormat;
        {
            this.timeFormat = new SimpleDateFormat("MMM-dd HH:mm:ss", Locale.getDefault());
            this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
        }

        @Override
        String getText(QMEvent event, boolean briefInfo) {
            return this.timeFormat.format(event.getObject().getOpenTime());
        }

        @Override
        String getToolTipText(QMEvent event) {
            return this.timestampFormat.format(event.getObject().getOpenTime());
        }
    };
    private static LogColumn COLUMN_TYPE = new LogColumn("type", ModelMessages.controls_querylog_column_type_name, ModelMessages.controls_querylog_column_type_tooltip, 100){

        @Override
        String getText(QMEvent event, boolean briefInfo) {
            return QueryLogViewer.getObjectType(event.getObject());
        }
    };
    private static LogColumn COLUMN_TEXT = new LogColumn("text", ModelMessages.controls_querylog_column_text_name, ModelMessages.controls_querylog_column_text_tooltip, 400){

        @Override
        String getText(QMEvent event, boolean briefInfo) {
            QMMObject object = event.getObject();
            if (object instanceof QMMStatementExecuteInfo) {
                QMMStatementExecuteInfo statement = (QMMStatementExecuteInfo)object;
                String text = CommonUtils.notEmpty((String)statement.getQueryString());
                if (briefInfo) {
                    text = CommonUtils.truncateString((String)text, (int)4000);
                }
                return text;
            }
            if (object instanceof QMMTransactionInfo) {
                if (((QMMTransactionInfo)object).isCommitted()) {
                    return ModelMessages.controls_querylog_commit;
                }
                return ModelMessages.controls_querylog_rollback;
            }
            if (object instanceof QMMTransactionSavepointInfo) {
                if (((QMMTransactionSavepointInfo)object).isCommitted()) {
                    return ModelMessages.controls_querylog_commit;
                }
                return ModelMessages.controls_querylog_rollback;
            }
            if (object instanceof QMMConnectionInfo) {
                String containerName = ((QMMConnectionInfo)object).getContainerName();
                String instanceId = ((QMMConnectionInfo)object).getInstanceId();
                ((QMMConnectionInfo)object).getContextName();
                String containerFullName = containerName;
                if (!CommonUtils.equalObjects((Object)containerName, (Object)instanceId)) {
                    containerFullName = String.valueOf(containerFullName) + " <" + instanceId + ">";
                }
                switch (event.getAction()) {
                    case BEGIN: {
                        return String.valueOf(ModelMessages.controls_querylog_connected_to) + containerFullName + "\"";
                    }
                    case END: {
                        return String.valueOf(ModelMessages.controls_querylog_disconnected_from) + containerFullName + "\"";
                    }
                }
                return "?";
            }
            return "";
        }
    };
    private static LogColumn COLUMN_DURATION = new LogColumn("duration", String.valueOf(ModelMessages.controls_querylog_column_duration_name) + " (" + ModelMessages.controls_querylog__ms + ")", ModelMessages.controls_querylog_column_duration_tooltip, 100){

        @Override
        String getText(QMEvent event, boolean briefInfo) {
            QMMObject object = event.getObject();
            if (object.isClosed()) {
                return NUMBER_FORMAT.format(object.getDuration());
            }
            return "";
        }
    };
    private static LogColumn COLUMN_ROWS = new LogColumn("rows", ModelMessages.controls_querylog_column_rows_name, ModelMessages.controls_querylog_column_rows_tooltip, 120){

        @Override
        String getText(QMEvent event, boolean briefInfo) {
            QMMStatementExecuteInfo exec;
            QMMObject object = event.getObject();
            if (object instanceof QMMStatementExecuteInfo && (exec = (QMMStatementExecuteInfo)object).isClosed() && !exec.isFetching()) {
                long updateRowCount = exec.getUpdateRowCount();
                long fetchRowCount = exec.getFetchRowCount();
                if (updateRowCount < 0L && fetchRowCount <= 0L) {
                    return "";
                }
                if (updateRowCount < 0L) {
                    return String.valueOf(fetchRowCount);
                }
                if (fetchRowCount <= 0L) {
                    return String.valueOf(updateRowCount);
                }
                return String.valueOf(fetchRowCount) + "/" + updateRowCount;
            }
            return "";
        }
    };
    private static LogColumn COLUMN_RESULT = new LogColumn("result", ModelMessages.controls_querylog_column_result_name, ModelMessages.controls_querylog_column_result_tooltip, 120){

        @Override
        String getText(QMEvent event, boolean briefInfo) {
            QMMStatementExecuteInfo exec;
            if (event.getObject() instanceof QMMStatementExecuteInfo && (exec = (QMMStatementExecuteInfo)event.getObject()).isClosed()) {
                if (exec.hasError()) {
                    if (exec.getErrorCode() == 0) {
                        return exec.getErrorMessage();
                    }
                    if (exec.getErrorMessage() == null) {
                        return String.valueOf(ModelMessages.controls_querylog_error) + exec.getErrorCode() + "]";
                    }
                    return "[" + exec.getErrorCode() + "] " + exec.getErrorMessage();
                }
                return ModelMessages.controls_querylog_success;
            }
            return "";
        }
    };
    private static LogColumn COLUMN_DATA_SOURCE = new LogColumn("datasource", ModelMessages.controls_querylog_column_connection_name, ModelMessages.controls_querylog_column_connection_tooltip, 150){

        @Override
        String getText(QMEvent event, boolean briefInfo) {
            QMMObject object = event.getObject();
            String containerName = null;
            if (object instanceof QMMConnectionInfo) {
                containerName = ((QMMConnectionInfo)object).getContainerName();
            } else if (object instanceof QMMTransactionInfo) {
                containerName = ((QMMTransactionInfo)object).getConnection().getContainerName();
            } else if (object instanceof QMMTransactionSavepointInfo) {
                containerName = ((QMMTransactionSavepointInfo)object).getTransaction().getConnection().getContainerName();
            } else if (object instanceof QMMStatementInfo) {
                containerName = ((QMMStatementInfo)object).getConnection().getContainerName();
            } else if (object instanceof QMMStatementExecuteInfo) {
                containerName = ((QMMStatementExecuteInfo)object).getStatement().getConnection().getContainerName();
            }
            return containerName == null ? "?" : containerName;
        }
    };
    private static LogColumn COLUMN_CONTEXT = new LogColumn("context", ModelMessages.controls_querylog_column_context_name, ModelMessages.controls_querylog_column_context_tooltip, 150){

        @Override
        String getText(QMEvent event, boolean briefInfo) {
            QMMObject object = event.getObject();
            String contextName = null;
            if (object instanceof QMMConnectionInfo) {
                contextName = ((QMMConnectionInfo)object).getContextName();
            } else if (object instanceof QMMTransactionInfo) {
                contextName = ((QMMTransactionInfo)object).getConnection().getContextName();
            } else if (object instanceof QMMTransactionSavepointInfo) {
                contextName = ((QMMTransactionSavepointInfo)object).getTransaction().getConnection().getContextName();
            } else if (object instanceof QMMStatementInfo) {
                contextName = ((QMMStatementInfo)object).getConnection().getContextName();
            } else if (object instanceof QMMStatementExecuteInfo) {
                contextName = ((QMMStatementExecuteInfo)object).getStatement().getConnection().getContextName();
            }
            if (contextName == null) {
                return "?";
            }
            return contextName;
        }
    };
    private final LogColumn[] ALL_COLUMNS = new LogColumn[]{this.COLUMN_TIME, COLUMN_TYPE, COLUMN_TEXT, COLUMN_DURATION, COLUMN_ROWS, COLUMN_RESULT, COLUMN_DATA_SOURCE, COLUMN_CONTEXT};
    private final IWorkbenchPartSite site;
    private final Text searchText;
    private Table logTable;
    private List<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
    private LongKeyMap<TableItem> objectToItemMap = new LongKeyMap();
    private QMEventFilter defaultFilter = new DefaultEventFilter();
    private QMEventFilter filter;
    private boolean useDefaultFilter = true;
    private boolean currentSessionOnly;
    private Color colorLightGreen;
    private Color colorLightRed;
    private Color colorLightYellow;
    private final Font boldFont;
    private DragSource dndSource;
    private volatile boolean reloadInProgress = false;
    private int entriesPerPage = 1;
    private LogRefreshJob logRefreshJob = null;

    public QueryLogViewer(Composite parent, IWorkbenchPartSite site, QMEventFilter filter, boolean showConnection, boolean currentSessionOnly) {
        this.site = site;
        this.currentSessionOnly = currentSessionOnly;
        ColorRegistry colorRegistry = site.getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.colorLightGreen = colorRegistry.get(COLOR_UNCOMMITTED);
        this.colorLightRed = colorRegistry.get(COLOR_REVERTED);
        this.colorLightYellow = colorRegistry.get(COLOR_TRANSACTION);
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        boolean inDialog = UIUtils.isInDialog((Control)parent);
        this.searchText = new Text(parent, 2432);
        this.searchText.setLayoutData((Object)new GridData(768));
        this.searchText.setMessage(SQLEditorMessages.editor_query_log_viewer_draw_text_type_qury_part);
        this.searchText.addModifyListener(e -> this.scheduleLogRefresh());
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)site, (Control)this.searchText);
        this.logTable = new Table(parent, 0x10302 | (inDialog ? 2048 : 0));
        this.logTable.setData((Object)this);
        this.logTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        this.logTable.setLayoutData((Object)gd);
        new TableToolTip(this.logTable){

            public String getItemToolTip(TableItem item, int selectedColumn) {
                LogColumn column = (LogColumn)QueryLogViewer.this.logTable.getColumn(selectedColumn).getData();
                return column.getToolTipText((QMEvent)item.getData());
            }
        };
        this.createColumns(showConnection);
        UIUtils.addFocusTracker((IServiceLocator)site, (String)QUERY_LOG_CONTROL_ID, (Control)this.logTable);
        this.logTable.addDisposeListener(e -> this.dispose());
        this.createContextMenu();
        this.addDragAndDropSupport();
        this.logTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                QueryLogViewer.this.showEventDetails((QMEvent)e.item.getData());
            }
        });
        this.filter = filter;
        DBWorkbench.getPlatformUI();
        QMUtils.registerMetaListener((QMMetaListener)this);
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
        this.logTable.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                QueryLogViewer.this.logTable.removeListener(11, (Listener)this);
                if (!QueryLogViewer.this.reloadInProgress) {
                    QueryLogViewer.this.reloadEvents(null);
                }
            }
        });
        this.themePropertiesListener = event -> {
            switch (event.getProperty()) {
                case "org.jkiss.dbeaver.txn.color.committed.background": {
                    this.colorLightGreen = colorRegistry.get(COLOR_UNCOMMITTED);
                    break;
                }
                case "org.jkiss.dbeaver.txn.color.reverted.background": {
                    this.colorLightRed = colorRegistry.get(COLOR_REVERTED);
                    break;
                }
                case "org.jkiss.dbeaver.txn.color.transaction.background": {
                    this.colorLightYellow = colorRegistry.get(COLOR_TRANSACTION);
                }
            }
        };
        this.site.getWorkbenchWindow().getWorkbench().getThemeManager().addPropertyChangeListener(this.themePropertiesListener);
    }

    private synchronized void scheduleLogRefresh() {
        if (this.logRefreshJob == null) {
            this.logRefreshJob = new LogRefreshJob();
        }
        this.logRefreshJob.cancel();
        this.logRefreshJob.schedule(500L);
    }

    public void setFilter(QMEventFilter filter) {
        this.filter = filter;
    }

    public void setUseDefaultFilter(boolean useDefaultFilter) {
        this.useDefaultFilter = useDefaultFilter;
    }

    private void showEventDetails(QMEvent event) {
        EventViewDialog dialog = new EventViewDialog(event);
        dialog.open();
    }

    private void createColumns(boolean showConnection) {
        TableColumn[] tableColumnArray = this.logTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.dispose();
            ++n2;
        }
        this.columns.clear();
        IDialogSettings dialogSettings = UIUtils.getDialogSettings((String)VIEWER_ID);
        int colIndex = 0;
        LogColumn[] logColumnArray = this.ALL_COLUMNS;
        int n3 = this.ALL_COLUMNS.length;
        int n4 = 0;
        while (n4 < n3) {
            LogColumn logColumn = logColumnArray[n4];
            if (showConnection || logColumn != COLUMN_DATA_SOURCE && logColumn != COLUMN_CONTEXT) {
                TableColumn tableColumn = UIUtils.createTableColumn((Table)this.logTable, (int)0, (String)logColumn.title);
                tableColumn.setData((Object)logColumn);
                String colWidth = dialogSettings.get("column-" + logColumn.id);
                if (colWidth != null) {
                    tableColumn.setWidth(Integer.parseInt(colWidth));
                } else {
                    tableColumn.setWidth(logColumn.widthHint);
                }
                tableColumn.setToolTipText(logColumn.toolTip);
                ColumnDescriptor cd = new ColumnDescriptor(logColumn, tableColumn);
                this.columns.add(cd);
                tableColumn.addListener(13, (Listener)new TableColumnSortListener(this.logTable, colIndex));
                tableColumn.addListener(11, event -> {
                    int width = tableColumn.getWidth();
                    dialogSettings.put("column-" + logColumn.id, String.valueOf(width));
                });
                ++colIndex;
            }
            ++n4;
        }
    }

    private void dispose() {
        IWorkbenchWindow workbenchWindow = this.site.getWorkbenchWindow();
        if (workbenchWindow != null) {
            workbenchWindow.getWorkbench().getThemeManager().removePropertyChangeListener(this.themePropertiesListener);
        }
        DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
        QMUtils.unregisterMetaListener((QMMetaListener)this);
        UIUtils.dispose((Widget)this.dndSource);
        UIUtils.dispose((Widget)this.logTable);
        UIUtils.dispose((Resource)this.boldFont);
    }

    public Text getSearchText() {
        return this.searchText;
    }

    public Table getControl() {
        return this.logTable;
    }

    public Object getInput() {
        return null;
    }

    public void setInput(Object input) {
    }

    public IStructuredSelection getSelection() {
        TableItem[] items = this.logTable.getSelection();
        Object[] data = new QMEvent[items.length];
        int i = 0;
        int itemsLength = items.length;
        while (i < itemsLength) {
            data[i] = (QMEvent)items[i].getData();
            ++i;
        }
        return new StructuredSelection(data);
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void refresh() {
        this.reloadEvents(this.searchText.getText());
    }

    private static String getObjectType(QMMObject object) {
        if (object instanceof QMMConnectionInfo) {
            return "";
        }
        if (object instanceof QMMStatementInfo || object instanceof QMMStatementExecuteInfo) {
            QMMStatementInfo statement = object instanceof QMMStatementInfo ? (QMMStatementInfo)object : ((QMMStatementExecuteInfo)object).getStatement();
            return "SQL" + (statement == null ? "" : " / " + CommonUtils.capitalizeWord((String)statement.getPurpose().getTitle()));
        }
        if (object instanceof QMMTransactionInfo) {
            return ModelMessages.controls_querylog_transaction;
        }
        if (object instanceof QMMTransactionSavepointInfo) {
            return ModelMessages.controls_querylog_savepoint;
        }
        return "";
    }

    private Font getObjectFont(QMEvent event) {
        QMMStatementExecuteInfo exec;
        if (event.getObject() instanceof QMMStatementExecuteInfo && (!(exec = (QMMStatementExecuteInfo)event.getObject()).isClosed() || exec.isFetching())) {
            return this.boldFont;
        }
        return null;
    }

    private Color getObjectForeground(QMEvent event) {
        return null;
    }

    private Color getObjectBackground(QMEvent event) {
        if (event.getObject() instanceof QMMStatementExecuteInfo) {
            QMMStatementExecuteInfo exec = (QMMStatementExecuteInfo)event.getObject();
            if (exec.hasError()) {
                return this.colorLightRed;
            }
            QMMTransactionSavepointInfo savepoint = exec.getSavepoint();
            if (savepoint == null) {
                return null;
            }
            if (savepoint.isClosed()) {
                return savepoint.isCommitted() ? this.colorLightGreen : this.colorLightYellow;
            }
            return this.colorLightGreen;
        }
        if (event.getObject() instanceof QMMTransactionInfo || event.getObject() instanceof QMMTransactionSavepointInfo) {
            QMMTransactionSavepointInfo savepoint = event.getObject() instanceof QMMTransactionInfo ? ((QMMTransactionInfo)event.getObject()).getCurrentSavepoint() : (QMMTransactionSavepointInfo)event.getObject();
            return savepoint.isCommitted() ? null : this.colorLightYellow;
        }
        return null;
    }

    private void reloadEvents(@Nullable String searchString) {
        if (this.reloadInProgress) {
            log.debug((Object)"Event reload is in progress. Skip");
            return;
        }
        this.reloadInProgress = true;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.entriesPerPage = Math.max(1, store.getInt("qm.maxEntries"));
        this.defaultFilter = new DefaultEventFilter();
        this.clearLog();
        EventHistoryReadService loadingService = new EventHistoryReadService(searchString);
        LoadingJob.createService((ILoadService)loadingService, (ILoadVisualizer)new EvenHistoryReadVisualizer(loadingService)).schedule();
    }

    public void metaInfoChanged(DBRProgressMonitor monitor, @NotNull List<QMMetaEvent> events) {
        if (DBWorkbench.getPlatform().isShuttingDown()) {
            return;
        }
        UIUtils.asyncExec(() -> this.updateMetaInfo(events));
    }

    private synchronized void updateMetaInfo(List<? extends QMEvent> events) {
        if (this.logTable.isDisposed()) {
            return;
        }
        this.logTable.setRedraw(false);
        try {
            try {
                int itemIndex = 0;
                int i = 0;
                while (i < events.size()) {
                    if (this.useDefaultFilter && itemIndex >= this.entriesPerPage) break;
                    QMEvent event = events.get(i);
                    if (!(this.filter != null && !this.filter.accept(event) || this.useDefaultFilter && !this.defaultFilter.accept(event))) {
                        QMEventAction action;
                        QMMObject object = event.getObject();
                        if (object instanceof QMMStatementExecuteInfo) {
                            if (!CommonUtils.isEmpty((String)((QMMStatementExecuteInfo)object).getQueryString())) {
                                itemIndex = this.createOrUpdateItem(event, itemIndex);
                            }
                        } else if (object instanceof QMMTransactionInfo || object instanceof QMMTransactionSavepointInfo) {
                            itemIndex = this.createOrUpdateItem(event, itemIndex);
                            if (object instanceof QMMTransactionInfo) {
                                QMMTransactionSavepointInfo savepoint = ((QMMTransactionInfo)object).getCurrentSavepoint();
                                while (savepoint != null) {
                                    this.updateExecutions(event, savepoint);
                                    savepoint = savepoint.getPrevious();
                                }
                            } else {
                                this.updateExecutions(event, (QMMTransactionSavepointInfo)object);
                            }
                        } else if (object instanceof QMMConnectionInfo && ((action = event.getAction()) == QMEventAction.BEGIN || action == QMEventAction.END)) {
                            TableItem item = new TableItem(this.logTable, 0, itemIndex++);
                            this.updateItem(event, item);
                        }
                    }
                    ++i;
                }
                int itemCount = this.logTable.getItemCount();
                if (itemCount > this.entriesPerPage) {
                    int[] indexes = new int[itemCount - this.entriesPerPage];
                    int i2 = 0;
                    while (i2 < itemCount - this.entriesPerPage) {
                        indexes[i2] = this.entriesPerPage + i2;
                        TableItem tableItem = this.logTable.getItem(this.entriesPerPage + i2);
                        if (tableItem != null && tableItem.getData() instanceof QMMObject) {
                            this.objectToItemMap.remove(((QMMObject)tableItem.getData()).getObjectId());
                        }
                        ++i2;
                    }
                    this.logTable.remove(indexes);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error updating Query Log", (Throwable)e);
                if (!this.logTable.isDisposed()) {
                    this.logTable.setRedraw(true);
                }
            }
        }
        finally {
            if (!this.logTable.isDisposed()) {
                this.logTable.setRedraw(true);
            }
        }
    }

    private void updateExecutions(QMEvent event, QMMTransactionSavepointInfo savepoint) {
        Iterator i = savepoint.getExecutions();
        while (i.hasNext()) {
            TableItem item;
            QMMStatementExecuteInfo exec = (QMMStatementExecuteInfo)i.next();
            if (exec.hasError() || (item = (TableItem)this.objectToItemMap.get(exec.getObjectId())) == null || item.isDisposed()) continue;
            item.setFont(this.getObjectFont(event));
            item.setForeground(this.getObjectForeground(event));
            item.setBackground(this.getObjectBackground(event));
        }
    }

    private int createOrUpdateItem(QMEvent event, int itemIndex) {
        TableItem item = (TableItem)this.objectToItemMap.get(event.getObject().getObjectId());
        if (item == null) {
            item = new TableItem(this.logTable, 0, itemIndex++);
            this.objectToItemMap.put(event.getObject().getObjectId(), (Object)item);
        }
        this.updateItem(event, item);
        return itemIndex;
    }

    private void updateItem(QMEvent event, TableItem item) {
        if (item.isDisposed()) {
            return;
        }
        item.setData((Object)event);
        int i = 0;
        int columnsSize = this.columns.size();
        while (i < columnsSize) {
            ColumnDescriptor cd = this.columns.get(i);
            item.setText(i, CommonUtils.getSingleLineString((String)cd.logColumn.getText(event, true)));
            ++i;
        }
        item.setFont(this.getObjectFont(event));
        item.setForeground(this.getObjectForeground(event));
        item.setBackground(this.getObjectBackground(event));
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.logTable);
        menuMgr.addMenuListener(manager -> {
            Action editorAction = new Action("Open in SQL console", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE)){

                public void run() {
                    QueryLogViewer.this.openSelectionInEditor();
                }
            };
            Action copyAction = new Action(ModelMessages.controls_querylog_action_copy){

                public void run() {
                    QueryLogViewer.this.copySelectionToClipboard(false);
                }
            };
            copyAction.setEnabled(this.logTable.getSelectionCount() > 0);
            copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
            Action copyAllAction = new Action(ModelMessages.controls_querylog_action_copy_all_fields){

                public void run() {
                    QueryLogViewer.this.copySelectionToClipboard(true);
                }
            };
            copyAllAction.setEnabled(this.logTable.getSelectionCount() > 0);
            copyAllAction.setActionDefinitionId("org.jkiss.dbeaver.core.edit.copy.special");
            Action selectAllAction = new Action(ModelMessages.controls_querylog_action_select_all){

                public void run() {
                    QueryLogViewer.this.selectAll();
                }
            };
            selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
            Action clearLogAction = new Action(ModelMessages.controls_querylog_action_clear_log){

                public void run() {
                    QueryLogViewer.this.clearLog();
                }
            };
            boolean hasStatements = false;
            TableItem[] tableItemArray = this.logTable.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (((QMEvent)item.getData()).getObject() instanceof QMMStatementExecuteInfo) {
                    hasStatements = true;
                    break;
                }
                ++n2;
            }
            if (hasStatements) {
                manager.add((IAction)editorAction);
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)copyAction);
            manager.add((IAction)copyAllAction);
            manager.add((IAction)selectAllAction);
            manager.add((IAction)clearLogAction);
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.eclipse.ui.file.refresh"));
            manager.add((IContributionItem)new Separator());
            this.createFiltersMenu(manager);
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.logTable.setMenu(menu);
        this.site.registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void createFiltersMenu(IMenuManager manager) {
        Action toggleAction;
        final DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        final QMEventCriteria criteria = QMUtils.createDefaultCriteria((DBPPreferenceStore)store);
        DBCExecutionPurpose[] dBCExecutionPurposeArray = DBCExecutionPurpose.values();
        int n = dBCExecutionPurposeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final DBCExecutionPurpose purpose = dBCExecutionPurposeArray[n2];
            toggleAction = new Action(purpose.getTitle(), 2){

                public boolean isChecked() {
                    return criteria.hasQueryType(purpose);
                }

                public void run() {
                    Object[] queryTypes = criteria.getQueryTypes();
                    queryTypes = this.isChecked() ? (DBCExecutionPurpose[])ArrayUtils.remove(DBCExecutionPurpose.class, (Object[])queryTypes, (Object)purpose) : (DBCExecutionPurpose[])ArrayUtils.add(DBCExecutionPurpose.class, (Object[])queryTypes, (Object)purpose);
                    ArrayList<String> typeNames = new ArrayList<String>(queryTypes.length);
                    Object[] objectArray = queryTypes;
                    int n = queryTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object queryType = objectArray[n2];
                        typeNames.add(queryType.name());
                        ++n2;
                    }
                    store.setValue("qm.queryTypes", CommonUtils.makeString(typeNames, (char)','));
                    PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
                    QueryLogViewer.this.scheduleLogRefresh();
                }
            };
            manager.add((IAction)toggleAction);
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
        dBCExecutionPurposeArray = QMObjectType.values();
        n = dBCExecutionPurposeArray.length;
        n2 = 0;
        while (n2 < n) {
            DBCExecutionPurpose type = dBCExecutionPurposeArray[n2];
            toggleAction = new Action(type.getTitle(), 2, (QMObjectType)type, store){
                private final /* synthetic */ QMObjectType val$type;
                private final /* synthetic */ DBPPreferenceStore val$store;
                {
                    this.val$type = qMObjectType;
                    this.val$store = dBPPreferenceStore;
                    super($anonymous0, $anonymous1);
                }

                public boolean isChecked() {
                    return criteria.hasObjectType(this.val$type);
                }

                public void run() {
                    Object[] objectTypes = criteria.getObjectTypes();
                    objectTypes = this.isChecked() ? (QMObjectType[])ArrayUtils.remove(QMObjectType.class, (Object[])objectTypes, (Object)this.val$type) : (QMObjectType[])ArrayUtils.add(QMObjectType.class, (Object[])objectTypes, (Object)this.val$type);
                    ArrayList typeList = new ArrayList();
                    Collections.addAll(typeList, objectTypes);
                    this.val$store.setValue("qm.objectTypes", QMObjectType.toString(typeList));
                    PrefUtils.savePreferenceStore((DBPPreferenceStore)this.val$store);
                    QueryLogViewer.this.scheduleLogRefresh();
                }
            };
            manager.add((IAction)toggleAction);
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.core.qm.filter"));
    }

    private void openSelectionInEditor() {
        TableItem[] items;
        DBPDataSourceContainer dsContainer = null;
        StringBuilder sql = new StringBuilder();
        TableItem[] tableItemArray = items = this.logTable.getSelection();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            QMEvent event = (QMEvent)item.getData();
            QMMObject object = event.getObject();
            if (object instanceof QMMStatementExecuteInfo) {
                String queryString;
                QMMStatementExecuteInfo stmtExec = (QMMStatementExecuteInfo)object;
                if (dsContainer == null) {
                    dsContainer = this.getDataSourceContainer(stmtExec);
                }
                if (!CommonUtils.isEmptyTrimmed((String)(queryString = stmtExec.getQueryString()))) {
                    if (sql.length() > 0) {
                        sql.append("\n");
                    }
                    queryString = queryString.trim();
                    sql.append(queryString);
                    if (!queryString.endsWith(";")) {
                        sql.append(";").append("\n");
                    }
                }
            }
            ++n2;
        }
        if (sql.length() > 0) {
            SQLEditorHandlerOpenEditor.openSQLConsole(UIUtils.getActiveWorkbenchWindow(), new SQLNavigatorContext((DBSObject)dsContainer), "QueryManager", sql.toString());
        }
    }

    private void addDragAndDropSupport() {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 7;
        this.dndSource = new DragSource((Control)this.logTable, operations);
        this.dndSource.setTransfer(types);
        this.dndSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                String tdt = QueryLogViewer.this.getSelectedText(false);
                event.data = !CommonUtils.isEmpty((String)tdt) ? tdt : "";
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    public synchronized void clearLog() {
        this.logTable.removeAll();
        this.objectToItemMap.clear();
    }

    public void selectAll() {
        if (!this.logTable.isDisposed()) {
            this.logTable.selectAll();
        }
    }

    public void copySelectionToClipboard(boolean extraInfo) {
        String tdt = this.getSelectedText(extraInfo);
        if (CommonUtils.isEmpty((String)tdt)) {
            return;
        }
        if (tdt.length() > 0) {
            UIUtils.setClipboardContents((Display)this.logTable.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)tdt);
        }
    }

    private String getSelectedText(boolean extraInfo) {
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        StringBuilder tdt = new StringBuilder();
        for (QMEvent item : selection) {
            if (tdt.length() > 0) {
                tdt.append(GeneralUtils.getDefaultLineSeparator());
            }
            if (extraInfo) {
                int i1 = 0;
                int columnsSize = this.columns.size();
                while (i1 < columnsSize) {
                    ColumnDescriptor cd = this.columns.get(i1);
                    String text = cd.logColumn.getText(item, true);
                    if (i1 > 0) {
                        tdt.append('\t');
                    }
                    tdt.append(text);
                    ++i1;
                }
                continue;
            }
            String text = COLUMN_TEXT.getText(item, true);
            tdt.append(text);
        }
        return tdt.toString();
    }

    private static String formatMinutes(long ms) {
        long min = ms / 1000L / 60L;
        long sec = (ms - min * 1000L * 60L) / 1000L;
        return NLS.bind((String)ModelMessages.controls_querylog_format_minutes, (Object)String.valueOf(min), (Object)String.valueOf(sec));
    }

    public synchronized void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        if (event.getProperty().startsWith("qm.")) {
            this.scheduleLogRefresh();
        }
    }

    private DBPDataSourceContainer getDataSourceContainer(QMMStatementExecuteInfo stmtExec) {
        DBPDataSourceContainer dsContainer = null;
        QMMConnectionInfo session = stmtExec.getStatement().getConnection();
        DBPProject project = session.getProject();
        String containerId = session.getContainerId();
        dsContainer = project != null ? project.getDataSourceRegistry().getDataSource(containerId) : DBUtils.findDataSource((String)containerId);
        return dsContainer;
    }

    private static class ColumnDescriptor {
        LogColumn logColumn;
        TableColumn tableColumn;

        ColumnDescriptor(LogColumn logColumn, TableColumn tableColumn) {
            this.logColumn = logColumn;
            this.tableColumn = tableColumn;
        }
    }

    private class EvenHistoryReadVisualizer
    extends ProgressLoaderVisualizer<List<QMEvent>> {
        EvenHistoryReadVisualizer(EventHistoryReadService loadingService) {
            super((ILoadService)loadingService, (Composite)QueryLogViewer.this.logTable);
        }

        public void visualizeLoading() {
            QueryLogViewer.this.reloadInProgress = true;
            super.visualizeLoading();
        }

        public void completeLoading(List<QMEvent> result) {
            try {
                Listener[] sortListeners;
                TableColumn sortColumn;
                super.completeLoading(result);
                super.visualizeLoading();
                if (result != null) {
                    QueryLogViewer.this.updateMetaInfo(result);
                }
                if ((sortColumn = QueryLogViewer.this.logTable.getSortColumn()) != null && (sortListeners = sortColumn.getListeners(13)) != null) {
                    Listener[] listenerArray = sortListeners;
                    int n = sortListeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Listener listener = listenerArray[n2];
                        Event event = new Event();
                        event.widget = sortColumn;
                        event.doit = false;
                        listener.handleEvent(event);
                        ++n2;
                    }
                }
            }
            finally {
                QueryLogViewer.this.reloadInProgress = false;
            }
        }
    }

    class EventHistoryReadService
    extends AbstractLoadService<List<QMEvent>> {
        @Nullable
        private String searchString;

        protected EventHistoryReadService(String searchString) {
            super("Load query history");
            this.searchString = searchString;
        }

        public List<QMEvent> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            ArrayList<QMEvent> events = new ArrayList<QMEvent>();
            QMEventBrowser eventBrowser = QMUtils.getEventBrowser((boolean)QueryLogViewer.this.currentSessionOnly);
            if (eventBrowser != null) {
                QMEventCriteria criteria = QMUtils.createDefaultCriteria((DBPPreferenceStore)DBWorkbench.getPlatform().getPreferenceStore());
                criteria.setSearchString(CommonUtils.isEmptyTrimmed((String)this.searchString) ? null : this.searchString.trim());
                monitor.beginTask("Load query history", 1);
                if (!CommonUtils.isEmpty((String)this.searchString)) {
                    monitor.subTask("Search queries: " + this.searchString);
                } else {
                    monitor.subTask("Load all queries");
                }
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (QMEventCursor cursor = eventBrowser.getQueryHistoryCursor(monitor, criteria, (QMEventFilter)(QueryLogViewer.this.filter != null ? QueryLogViewer.this.filter : (QueryLogViewer.this.useDefaultFilter ? QueryLogViewer.this.defaultFilter : null)));){
                        while (events.size() < QueryLogViewer.this.entriesPerPage && cursor.hasNextEvent(monitor)) {
                            if (monitor.isCanceled()) {
                                break;
                            }
                            events.add((QMEvent)cursor.nextEvent(monitor));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            }
            return events;
        }

        public Object getFamily() {
            return QueryLogViewer.class;
        }
    }

    private class EventViewDialog
    extends BaseSQLDialog {
        private static final String DIALOG_ID = "DBeaver.QM.EventViewDialog";
        private final QMEvent object;

        EventViewDialog(QMEvent object) {
            super(QueryLogViewer.this.getControl().getShell(), QueryLogViewer.this.site, "Event", null);
            this.setShellStyle(1136);
            this.object = object;
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return UIUtils.getDialogSettings((String)DIALOG_ID);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(String.valueOf(ModelMessages.controls_querylog_shell_text) + COLUMN_TYPE.getText(this.object, true));
        }

        protected Composite createDialogArea(Composite parent) {
            Composite msg;
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)new GridLayout(1, false));
            Composite topFrame = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
            topFrame.setLayoutData((Object)new GridData(1808));
            UIUtils.createLabelText((Composite)topFrame, (String)ModelMessages.controls_querylog_label_time, (String)QueryLogViewer.this.COLUMN_TIME.getText(this.object, true), (int)8);
            UIUtils.createLabelText((Composite)topFrame, (String)ModelMessages.controls_querylog_label_type, (String)COLUMN_TYPE.getText(this.object, true), (int)2056);
            Label messageLabel = UIUtils.createControlLabel((Composite)topFrame, (String)ModelMessages.controls_querylog_label_text);
            messageLabel.setLayoutData((Object)new GridData(2));
            if (this.object.getObject() instanceof QMMStatementExecuteInfo) {
                msg = this.createSQLPanel(topFrame);
            } else {
                Text messageText = new Text(topFrame, 2634);
                messageText.setText(COLUMN_TEXT.getText(this.object, true));
                msg = messageText;
            }
            GridData gd = new GridData(1808);
            gd.widthHint = 500;
            msg.setLayoutData((Object)gd);
            Composite bottomFrame = UIUtils.createPlaceholder((Composite)composite, (int)1, (int)5);
            bottomFrame.setLayoutData((Object)new GridData(768));
            Label resultLabel = UIUtils.createControlLabel((Composite)bottomFrame, (String)ModelMessages.controls_querylog_label_result);
            resultLabel.setLayoutData((Object)new GridData(2));
            Text resultText = new Text(bottomFrame, 2890);
            resultText.setText(COLUMN_RESULT.getText(this.object, true));
            gd = new GridData(768);
            gd.heightHint = 60;
            gd.widthHint = 300;
            resultText.setLayoutData((Object)gd);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            parent.setLayoutData((Object)new GridData(768));
            parent.setLayout((Layout)new GridLayout(2, false));
            Composite leftCell = UIUtils.createComposite((Composite)parent, (int)1);
            leftCell.setLayoutData((Object)new GridData(768));
            Composite rightCell = UIUtils.createComposite((Composite)parent, (int)1);
            rightCell.setLayoutData((Object)new GridData(128));
            this.createButton(rightCell, 0, IDialogConstants.OK_LABEL, true);
            QMMStatementExecuteInfo execInfo = null;
            if (this.object.getObject() instanceof QMMStatementExecuteInfo && this.isQueryLinkedWithEditor(execInfo = (QMMStatementExecuteInfo)this.object.getObject()) && SQLEditorUtils.isOpenSeparateConnection(QueryLogViewer.this.getDataSourceContainer(execInfo))) {
                UIUtils.createPushButton((Composite)leftCell, (String)SQLEditorMessages.editor_query_log_viewer_reexecute_query_button_text, null, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (EventViewDialog.this.object.getObject() instanceof QMMStatementExecuteInfo) {
                            QMMStatementExecuteInfo execInfo = (QMMStatementExecuteInfo)EventViewDialog.this.object.getObject();
                            SQLEditor editor = ((SQLLogFilter)((EventViewDialog)EventViewDialog.this).QueryLogViewer.this.filter).getEditor();
                            SQLQuery query = new SQLQuery(editor.getDataSource(), execInfo.getQueryString());
                            editor.processQueries(List.of(query), false, true, false, true, null, null);
                        }
                    }
                });
            }
            this.createCopyButton(leftCell);
        }

        @Override
        protected SQLDialect getSQLDialect() {
            SQLDialect dialect;
            if (this.object.getObject() instanceof QMMStatementExecuteInfo && (dialect = ((QMMStatementExecuteInfo)this.object.getObject()).getStatement().getConnection().getSQLDialect()) != null) {
                return dialect;
            }
            return super.getSQLDialect();
        }

        @Override
        protected DBCExecutionContext getExecutionContext() {
            return null;
        }

        @Override
        protected String getSQLText() {
            return COLUMN_TEXT.getText(this.object, false);
        }

        @Override
        protected boolean isLabelVisible() {
            return false;
        }

        private boolean isQueryLinkedWithEditor(QMMStatementExecuteInfo execInfo) {
            DBCExecutionPurpose purpose = execInfo.getStatement().getPurpose();
            return (purpose == DBCExecutionPurpose.USER_SCRIPT || purpose == DBCExecutionPurpose.USER) && this.object.getObject() instanceof QMMStatementExecuteInfo && QueryLogViewer.this.filter != null && QueryLogViewer.this.filter instanceof SQLLogFilter && ((SQLLogFilter)QueryLogViewer.this.filter).getEditor() != null;
        }
    }

    private static abstract class LogColumn {
        private final String id;
        private final String title;
        private final String toolTip;
        private final int widthHint;

        private LogColumn(String id, String title, String toolTip, int widthHint) {
            this.id = id;
            this.title = title;
            this.toolTip = toolTip;
            this.widthHint = widthHint;
        }

        abstract String getText(QMEvent var1, boolean var2);

        String getToolTipText(QMEvent event) {
            return this.getText(event, true);
        }
    }

    private class LogRefreshJob
    extends AbstractUIJob {
        LogRefreshJob() {
            super(ModelMessages.controls_querylog_job_refresh);
        }

        protected IStatus runInUIThread(DBRProgressMonitor monitor) {
            QueryLogViewer.this.refresh();
            return Status.OK_STATUS;
        }
    }
}

