/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.console;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.data.console.ConsoleMessages;
import org.jkiss.dbeaver.data.console.ConsoleViewSwitchHandler;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListenerDefault;

public class ConsoleViewSwitchContributor
extends WorkbenchWindowControlContribution {
    @Nullable
    private static SQLEditor obtainSqlEditorContext(@NotNull Control control) {
        while (control != null) {
            Object data = control.getData("org.jkiss.dbeaver.ui.editors.sql.SQLEditor");
            if (data instanceof SQLEditor) {
                return (SQLEditor)data;
            }
            control = control.getParent();
        }
        return null;
    }

    @Nullable
    protected Control createControl(@NotNull Composite parent) {
        final SQLEditor editor = ConsoleViewSwitchContributor.obtainSqlEditorContext((Control)parent);
        if (editor == null) {
            return null;
        }
        ConsoleViewSwitchHandler.watchForEditor(editor);
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        final Action action = new Action(ConsoleMessages.console_view_action_tooltip, 2){
            {
                super($anonymous0, $anonymous1);
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE));
            }

            public void run() {
                ConsoleViewSwitchHandler.toggleConsoleViewForEditor(editor);
            }
        };
        editor.addListener((SQLEditorListener)new SQLEditorListenerDefault(){

            public void onDataSourceChanged(DBPPreferenceListener.PreferenceChangeEvent event) {
                if (event == null || event.getProperty().equals("SQLEditor.ConsoleView.showConsoleViewByDefault")) {
                    boolean isConsoleViewEnabled = ConsoleViewSwitchHandler.isConsoleViewEnabledForEditor(editor);
                    action.setChecked(isConsoleViewEnabled);
                    editor.setConsoleViewOutputEnabled(isConsoleViewEnabled);
                }
            }
        });
        ActionContributionItem actionContribution = new ActionContributionItem((IAction)action);
        actionContribution.fill(toolBar, 0);
        return toolBar;
    }
}

