/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.List;
import org.jkiss.dbeaver.parser.common.GrammarAnalyzer;
import org.jkiss.dbeaver.parser.common.Parser;
import org.jkiss.dbeaver.parser.common.ParserFsm;
import org.jkiss.dbeaver.parser.common.grammar.GrammarInfo;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaBuilder;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaTransition;

public class ParserFactory {
    private final GrammarInfo grammar;
    private final ParserFsm parserFsm;

    private ParserFactory(GrammarInfo grammar, ParserFsm parserFsm) {
        this.grammar = grammar;
        this.parserFsm = parserFsm;
    }

    public Parser createParser() {
        return new Parser(this.grammar, this.parserFsm);
    }

    public static ParserFactory getFactory(GrammarInfo grammar) {
        GrammarNfaBuilder builder = new GrammarNfaBuilder(grammar);
        GrammarNfaBuilder.NfaFragment root = builder.traverseGrammar();
        List<GrammarNfaTransition> terminalTransitions = builder.getTerminalTransitions();
        GrammarAnalyzer analyzer = new GrammarAnalyzer(terminalTransitions, root);
        ParserFsm parserFsm = analyzer.buildTerminalsGraph();
        parserFsm.prepare();
        return new ParserFactory(grammar, parserFsm);
    }
}

