/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.BoldStylerProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbookEditorsHandler;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public class CustomWorkbookEditorsHandler
extends WorkbookEditorsHandler {
    private String pattern;

    protected ViewerFilter getFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (CustomWorkbookEditorsHandler.this.pattern == null || !(viewer instanceof TableViewer)) {
                    return true;
                }
                String name = null;
                if (element instanceof EditorReference) {
                    name = ((EditorReference)element).getTitle();
                }
                if (name == null) {
                    return false;
                }
                return CustomWorkbookEditorsHandler.match(CustomWorkbookEditorsHandler.this.pattern, name) != null;
            }
        };
    }

    protected void setLabelProvider(TableViewerColumn column) {
        column.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getElement() instanceof WorkbenchPartReference) {
                    WorkbenchPartReference ref = (WorkbenchPartReference)cell.getElement();
                    String text = CustomWorkbookEditorsHandler.this.getWorkbenchPartReferenceText(ref);
                    cell.setText(text);
                    cell.setImage(ref.getTitleImage());
                    List<Object> ranges = CommonUtils.isEmpty((String)CustomWorkbookEditorsHandler.this.pattern) ? Collections.emptyList() : CustomWorkbookEditorsHandler.match(CustomWorkbookEditorsHandler.this.pattern, text);
                    if (CommonUtils.isEmpty(ranges)) {
                        cell.setStyleRanges(null);
                    } else {
                        Font font = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getItalic("org.eclipse.ui.workbench.TAB_TEXT_FONT");
                        StyledString.Styler styler = new BoldStylerProvider(font).getBoldStyler();
                        StyledString ss = new StyledString(text);
                        for (int[] nArray : ranges) {
                            ss.setStyle(nArray[0], nArray[1], styler);
                        }
                        cell.setStyleRanges(ss.getStyleRanges());
                    }
                    cell.getControl().redraw();
                }
            }

            public String getToolTipText(Object element) {
                if (element instanceof WorkbenchPartReference) {
                    return ((WorkbenchPartReference)element).getTitleToolTip();
                }
                return super.getToolTipText(element);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)column.getViewer());
    }

    protected void setMatcherString(String pattern) {
        this.pattern = pattern;
    }

    @Nullable
    private static List<int[]> match(@NotNull String pattern, @NotNull String value) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        int p = 0;
        int v = 0;
        int start = -1;
        while (p <= pattern.length() && v <= value.length()) {
            if (p != pattern.length() && v == value.length()) {
                return null;
            }
            if (p < pattern.length() && Character.toLowerCase(pattern.charAt(p)) == Character.toLowerCase(value.charAt(v))) {
                if (start < 0) {
                    start = v;
                }
                ++p;
            } else if (start >= 0) {
                ranges.add(new int[]{start, v - start});
                start = -1;
            }
            ++v;
        }
        return ranges;
    }
}

