/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui;

import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.ui.SQLServerUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class SQLServerConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Text hostText;
    private Text portText;
    private Text dbText;
    private Button showAllSchemas;
    private Button encryptPassword;
    private boolean needsPort;
    private boolean activated;
    private final Image LOGO_AZURE = this.createImage("icons/azure_logo.png");
    private final Image LOGO_BABELFISH = this.createImage("icons/bbfsh_logo.png");
    private final Image LOGO_SQLSERVER = this.createImage("icons/mssql_logo.png");
    private final Image LOGO_SYBASE = this.createImage("icons/sybase_logo.png");

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.LOGO_AZURE);
        UIUtils.dispose((Resource)this.LOGO_BABELFISH);
        UIUtils.dispose((Resource)this.LOGO_SQLSERVER);
        UIUtils.dispose((Resource)this.LOGO_SYBASE);
    }

    public void createControl(Composite composite) {
        boolean isSqlServer = this.isSqlServer();
        boolean isDriverAzure = isSqlServer && this.isDriverAzure();
        Composite settingsGroup = new Composite(composite, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        settingsGroup.setLayoutData((Object)gd);
        this.needsPort = CommonUtils.getBoolean((Object)this.getSite().getDriver().getDriverParameter("needsPort"), (boolean)true);
        Label hostLabel = new Label(settingsGroup, 0);
        hostLabel.setText(SQLServerUIMessages.dialog_connection_host_label);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text(settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        if (isDriverAzure || !this.needsPort) {
            gd.horizontalSpan = 3;
        } else {
            Label portLabel = new Label(settingsGroup, 0);
            portLabel.setText(SQLServerUIMessages.dialog_connection_port_label);
            portLabel.setLayoutData((Object)new GridData(128));
            this.portText = new Text(settingsGroup, 2048);
            gd = new GridData(2);
            gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
            this.portText.setLayoutData((Object)gd);
        }
        Label dbLabel = new Label(settingsGroup, 0);
        dbLabel.setText(SQLServerUIMessages.dialog_connection_database_schema_label);
        dbLabel.setLayoutData((Object)new GridData(128));
        this.dbText = new Text(settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        this.createAuthPanel(settingsGroup, 4);
        Group secureGroup = new Group(settingsGroup, 0);
        secureGroup.setText(SQLServerUIMessages.dialog_setting_connection_settings);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        secureGroup.setLayoutData((Object)gd);
        secureGroup.setLayout((Layout)new GridLayout(1, false));
        if (!isSqlServer) {
            this.encryptPassword = UIUtils.createCheckbox((Composite)secureGroup, (String)SQLServerUIMessages.dialog_setting_encrypt_password, (String)SQLServerUIMessages.dialog_setting_encrypt_password_tip, (boolean)false, (int)2);
        }
        this.showAllSchemas = UIUtils.createCheckbox((Composite)secureGroup, (String)SQLServerUIMessages.dialog_setting_show_all_schemas, (String)SQLServerUIMessages.dialog_setting_show_all_schemas_tip, (boolean)true, (int)2);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    public boolean isComplete() {
        return this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText());
    }

    public Image getImage() {
        Image logo = this.LOGO_SYBASE;
        if (this.isSqlServer()) {
            logo = this.isDriverAzure() ? this.LOGO_AZURE : (this.isDriverBabelfish() ? this.LOGO_BABELFISH : this.LOGO_SQLSERVER);
        }
        return logo;
    }

    private boolean isDriverAzure() {
        return SQLServerUtils.isDriverAzure((DBPDriver)this.getSite().getDriver());
    }

    private boolean isDriverBabelfish() {
        return SQLServerUtils.isDriverBabelfish((DBPDriver)this.getSite().getDriver());
    }

    private boolean isSqlServer() {
        return SQLServerUtils.isDriverSqlServer((DBPDriver)this.getSite().getDriver());
    }

    public void loadSettings() {
        super.loadSettings();
        boolean isDriverAzure = this.isSqlServer() && this.isDriverAzure();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                this.hostText.setText(CommonUtils.toString((Object)this.site.getDriver().getDefaultHost(), (String)(isDriverAzure ? ".database.windows.net" : "localhost")));
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (this.getSite().isNew() && CommonUtils.isEmpty((String)databaseName)) {
                databaseName = CommonUtils.notEmpty((String)this.site.getDriver().getDefaultDatabase());
            }
            this.dbText.setText(CommonUtils.notEmpty((String)databaseName));
        }
        this.showAllSchemas.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-show-all-schemas@")));
        if (!this.isSqlServer()) {
            this.encryptPassword.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-encrypt-password@")));
        }
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.showAllSchemas != null) {
            connectionInfo.setProviderProperty("@dbeaver-show-all-schemas@", String.valueOf(this.showAllSchemas.getSelection()));
        }
        if (this.encryptPassword != null) {
            connectionInfo.setProviderProperty("@dbeaver-encrypt-password@", String.valueOf(this.encryptPassword.getSelection()));
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

