/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.content;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDContentStorageLocal;
import org.jkiss.dbeaver.model.data.storage.BytesContentStorage;
import org.jkiss.dbeaver.model.data.storage.ExternalContentStorage;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.data.storage.TemporaryContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.LocalFileStorage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.editors.IStatefulEditorInput;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class ContentEditorInput
implements IPathEditorInput,
IStatefulEditorInput,
DBPContextProvider,
IEncodingSupport {
    private static final Log log = Log.getLog(ContentEditorInput.class);
    private IValueController valueController;
    private IEditorPart[] editorParts;
    private IEditorPart defaultPart;
    private boolean contentDetached = false;
    private File contentFile;
    private String fileCharset;
    private StringEditorInput.StringStorage stringStorage;

    public ContentEditorInput(@NotNull IValueController valueController, @Nullable IEditorPart[] editorParts, @Nullable IEditorPart defaultPart, @NotNull DBRProgressMonitor monitor) throws DBException {
        this.valueController = valueController;
        this.editorParts = editorParts;
        this.defaultPart = defaultPart;
        this.fileCharset = this.getDefaultEncoding();
        this.prepareContent(monitor);
    }

    public ContentEditorInput(@NotNull IValueController valueController, @Nullable IEditorPart[] editorParts, @Nullable IEditorPart defaultPart, @Nullable String charset, @NotNull DBRProgressMonitor monitor) throws DBException {
        this.valueController = valueController;
        this.editorParts = editorParts;
        this.defaultPart = defaultPart;
        this.fileCharset = CommonUtils.isEmpty((String)charset) ? this.getDefaultEncoding() : charset;
        this.prepareContent(monitor);
    }

    public IValueController getValueController() {
        return this.valueController;
    }

    public void refreshContent(DBRProgressMonitor monitor, IValueController valueController) throws DBException {
        this.valueController = valueController;
        this.prepareContent(monitor);
    }

    IEditorPart[] getEditors() {
        return this.editorParts;
    }

    public IEditorPart getDefaultEditor() {
        return this.defaultPart;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TYPE_LOB);
    }

    public String getName() {
        String inputName = this.valueController instanceof IAttributeController ? ((IAttributeController)this.valueController).getColumnId() : this.valueController.getValueName();
        if (this.isReadOnly()) {
            inputName = String.valueOf(inputName) + " [Read Only]";
        }
        return inputName;
    }

    @Nullable
    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    @Nullable
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IStorage.class) {
            if (this.stringStorage != null) {
                return adapter.cast(this.stringStorage);
            }
            return adapter.cast(new LocalFileStorage(this.contentFile, this.fileCharset));
        }
        return null;
    }

    public Object getValue() {
        return this.valueController.getValue();
    }

    public long getContentLength() {
        if (this.stringStorage != null) {
            return this.stringStorage.getLength();
        }
        if (this.contentFile != null) {
            return this.contentFile.length();
        }
        return 0L;
    }

    private void prepareContent(DBRProgressMonitor monitor) throws DBException {
        Object[] value = new Object[1];
        UIUtils.syncExec(() -> {
            Object object = this.getValue();
        });
        if (!(value[0] instanceof DBDContent)) {
            this.stringStorage = new StringEditorInput(this.getName(), (CharSequence)CommonUtils.toString((Object)value[0]), this.isReadOnly(), this.fileCharset).getStorage();
            return;
        }
        DBDContent content = (DBDContent)value[0];
        DBDContentStorage storage = content.getContents(monitor);
        if (this.contentDetached) {
            this.release();
            this.contentDetached = false;
        }
        if (storage instanceof DBDContentStorageLocal) {
            this.contentFile = ((DBDContentStorageLocal)storage).getDataFile();
            this.contentDetached = true;
        } else {
            try {
                if (this.contentFile == null) {
                    String valueId = this.valueController instanceof IAttributeController ? ((IAttributeController)this.valueController).getColumnId() : this.valueController.getValueName();
                    this.contentFile = ContentUtils.createTempContentFile((DBRProgressMonitor)monitor, (DBPPlatform)DBWorkbench.getPlatform(), (String)valueId);
                }
                this.copyContentToFile(content, monitor);
            }
            catch (IOException e) {
                if (this.contentFile != null && this.contentFile.exists() && !this.contentFile.delete()) {
                    log.warn((Object)("Can't delete temporary content file '" + this.contentFile.getAbsolutePath() + "'"));
                }
                throw new DBException("Can't delete content file", (Throwable)e);
            }
        }
        if (this.valueController.isReadOnly()) {
            this.markReadOnly(true);
        }
    }

    private void markReadOnly(boolean readOnly) throws DBException {
        if (!this.contentFile.setWritable(!readOnly)) {
            throw new DBException("Can't set content read-only");
        }
    }

    public void release() {
        if (this.contentFile != null && !this.contentDetached) {
            if (!this.contentFile.delete()) {
                log.warn((Object)("Can't delete temp file '" + this.contentFile.getAbsolutePath() + "'"));
            }
            this.contentDetached = true;
        }
        this.stringStorage = null;
    }

    @Nullable
    public IPath getPath() {
        return this.contentFile == null ? new Path("fake_path") : new Path(this.contentFile.getAbsolutePath());
    }

    public boolean isReadOnly() {
        return this.valueController.isReadOnly();
    }

    void saveToExternalFile(File file, IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = this.openContents();){
                ContentUtils.saveContentToFile((InputStream)is, (File)file, (DBRProgressMonitor)RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
        }
    }

    private InputStream openContents() throws Exception {
        return this.stringStorage == null ? new FileInputStream(this.contentFile) : this.stringStorage.getContents();
    }

    void loadFromExternalFile(File extFile, IProgressMonitor monitor) throws CoreException {
        try {
            this.release();
            this.contentFile = extFile;
            this.contentDetached = true;
            Object value = this.getValue();
            if (value instanceof DBDContent) {
                ((DBDContent)value).updateContents((DBRProgressMonitor)new DefaultProgressMonitor(monitor), (DBDContentStorage)new ExternalContentStorage(DBWorkbench.getPlatform(), extFile));
            } else {
                this.updateStringValueFromFile(extFile);
            }
            this.refreshContentParts(extFile);
        }
        catch (Throwable e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
        }
    }

    private void updateStringValueFromFile(File extFile) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileReader is = new FileReader(extFile);){
                String str = IOUtils.readToString((Reader)is);
                this.stringStorage.setString(str);
                this.valueController.updateValue(str, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Error reading content from file", (Throwable)e);
        }
    }

    void refreshContentParts(Object source) {
        IEditorPart[] iEditorPartArray = this.editorParts;
        int n = this.editorParts.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart cePart = iEditorPartArray[n2];
            if (cePart instanceof IRefreshablePart) {
                ((IRefreshablePart)cePart).refreshPart(source, false);
            }
            ++n2;
        }
    }

    private void copyContentToFile(DBDContent contents, DBRProgressMonitor monitor) throws DBException, IOException {
        block21: {
            DBDContentStorage storage = contents.getContents(monitor);
            this.markReadOnly(false);
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileOutputStream os = new FileOutputStream(this.contentFile);){
                if (contents.isNull()) {
                    ContentUtils.copyStreams((InputStream)new ByteArrayInputStream(new byte[0]), (long)0L, (OutputStream)os, (DBRProgressMonitor)monitor);
                    break block21;
                }
                if (storage == null) {
                    log.warn((Object)"Can't get data from null storage");
                    return;
                }
                Throwable throwable2 = null;
                Object var8_11 = null;
                try (InputStream is = storage.getContentStream();){
                    ContentUtils.copyStreams((InputStream)is, (long)storage.getContentLength(), (OutputStream)os, (DBRProgressMonitor)monitor);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        this.markReadOnly(this.valueController.isReadOnly());
    }

    public void updateContentFromFile(DBRProgressMonitor monitor, Object value) throws DBException {
        block29: {
            if (this.valueController.isReadOnly()) {
                throw new DBCException("Can't update read-only value");
            }
            if (value instanceof DBDContent) {
                DBDContent content = (DBDContent)value;
                DBDContentStorage storage = content.getContents(monitor);
                if (storage instanceof DBDContentStorageLocal) {
                    content.updateContents(monitor, storage);
                    this.contentDetached = true;
                } else {
                    if (storage instanceof DBDContentCached) {
                        try {
                            Throwable throwable = null;
                            Object var6_8 = null;
                            try (FileInputStream is = new FileInputStream(this.contentFile);){
                                block28: {
                                    if (ContentUtils.isTextContent((DBDContent)content)) {
                                        Throwable throwable2 = null;
                                        Object var9_13 = null;
                                        try (InputStreamReader reader = new InputStreamReader((InputStream)is, this.fileCharset);){
                                            storage = StringContentStorage.createFromReader((Reader)reader);
                                            break block28;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                            } else if (throwable2 != throwable3) {
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            throw throwable2;
                                        }
                                    }
                                    storage = BytesContentStorage.createFromStream((InputStream)is, (long)this.contentFile.length(), (String)this.fileCharset);
                                }
                                this.contentDetached = content.updateContents(monitor, storage);
                                break block29;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            throw new DBException("Error reading content from file", (Throwable)e);
                        }
                    }
                    storage = new TemporaryContentStorage(DBWorkbench.getPlatform(), this.contentFile, this.fileCharset, false);
                    this.contentDetached = content.updateContents(monitor, storage);
                }
            } else if (this.stringStorage != null) {
                this.valueController.updateValue(this.stringStorage.getString(), false);
                this.contentDetached = true;
            }
        }
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.valueController.getExecutionContext();
    }

    public String getEncoding() {
        return this.fileCharset;
    }

    public String getDefaultEncoding() {
        if (this.valueController.getExecutionContext() == null) {
            return GeneralUtils.getDefaultFileEncoding();
        }
        return DBValueFormatting.getDefaultBinaryFileEncoding((DBPDataSource)this.valueController.getExecutionContext().getDataSource());
    }

    public void setEncoding(String fileCharset) {
        this.fileCharset = fileCharset;
        IEditorPart[] iEditorPartArray = this.editorParts;
        int n = this.editorParts.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart part = iEditorPartArray[n2];
            try {
                if (part instanceof IReusableEditor) {
                    ((IReusableEditor)part).setInput((IEditorInput)this);
                } else {
                    part.init(part.getEditorSite(), (IEditorInput)this);
                }
            }
            catch (PartInitException e) {
                log.error((Object)("Error refreshing content editor part " + part), (Throwable)e);
            }
            ++n2;
        }
    }
}

