/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef3.Disposable;
import org.eclipse.jface.action.IAction;

public class ActionRegistry {
    private Map map = new HashMap(15);

    public void dispose() {
        Iterator actions = this.getActions();
        while (actions.hasNext()) {
            IAction action = (IAction)actions.next();
            if (!(action instanceof Disposable)) continue;
            ((Disposable)action).dispose();
        }
    }

    public IAction getAction(Object key) {
        return (IAction)this.map.get(key);
    }

    public Iterator getActions() {
        return this.map.values().iterator();
    }

    public void registerAction(IAction action) {
        Assert.isNotNull((Object)action.getId(), (String)("action must have an ID in " + this.getClass().getName() + " :registerAction(IAction)"));
        this.registerAction(action.getId(), action);
    }

    private void registerAction(String id, IAction action) {
        this.map.put(id, action);
    }

    public void removeAction(IAction action) {
        this.map.remove(action.getId());
    }
}

