/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializer;
import org.jkiss.utils.CommonUtils;

public class DriverDescriptorSerializerModern
extends DriverDescriptorSerializer {
    private static final Log log = Log.getLog(DriverDescriptorSerializerModern.class);
    private DriverDescriptor driver;

    DriverDescriptorSerializerModern(DriverDescriptor driver) {
        this.driver = driver;
    }

    public void serialize(JsonWriter json, boolean export) throws IOException {
        Map<String, String> pathSubstitutions = this.getPathSubstitutions();
        json.name(this.driver.getId());
        json.beginObject();
        if (export) {
            JSONUtils.fieldNE((JsonWriter)json, (String)"provider", (String)this.driver.getProviderDescriptor().getId());
        }
        JSONUtils.field((JsonWriter)json, (String)"id", (String)this.driver.getId());
        JSONUtils.field((JsonWriter)json, (String)"name", (String)this.driver.getName());
        JSONUtils.field((JsonWriter)json, (String)"class", (String)this.driver.getDriverClassName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"url", (String)this.driver.getSampleURL());
        JSONUtils.fieldNE((JsonWriter)json, (String)"port", (String)this.driver.getDefaultPort());
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)this.driver.getDescription());
        JSONUtils.fieldNE((JsonWriter)json, (String)"categories", (String)String.join((CharSequence)",", this.driver.getCategories()));
        JSONUtils.field((JsonWriter)json, (String)"custom", (boolean)this.driver.isCustom());
        JSONUtils.field((JsonWriter)json, (String)"embedded", (boolean)this.driver.isEmbedded());
        JSONUtils.field((JsonWriter)json, (String)"anonymous", (boolean)this.driver.isAnonymousAccess());
        JSONUtils.field((JsonWriter)json, (String)"allowsEmptyPassword", (boolean)this.driver.isAnonymousAccess());
        JSONUtils.field((JsonWriter)json, (String)"instantiable", (boolean)this.driver.isInstantiable());
        if (this.driver.isCustomDriverLoader()) {
            JSONUtils.field((JsonWriter)json, (String)"customDriverLoader", (boolean)this.driver.isCustomDriverLoader());
        }
        if (this.driver.isDisabled()) {
            JSONUtils.field((JsonWriter)json, (String)"disabled", (boolean)true);
        }
        if (!CommonUtils.isEmpty((String)this.driver.getCategory())) {
            JSONUtils.fieldNE((JsonWriter)json, (String)"category", (String)this.driver.getCategory());
        }
        if (!CommonUtils.isEmpty(this.driver.getDriverLibraries())) {
            json.name("libraries");
            json.beginObject();
            for (DBPDriverLibrary dBPDriverLibrary : this.driver.getDriverLibraries()) {
                List<DriverDescriptor.DriverFileInfo> files;
                if (export && !dBPDriverLibrary.isDisabled()) continue;
                json.name(DriverDescriptorSerializerModern.substitutePathVariables(pathSubstitutions, dBPDriverLibrary.getPath()));
                json.beginObject();
                JSONUtils.fieldNE((JsonWriter)json, (String)"type", (String)dBPDriverLibrary.getType().name());
                JSONUtils.field((JsonWriter)json, (String)"custom", (boolean)dBPDriverLibrary.isCustom());
                if (dBPDriverLibrary.isDisabled()) {
                    JSONUtils.field((JsonWriter)json, (String)"disabled", (boolean)true);
                }
                if (!CommonUtils.isEmpty((String)dBPDriverLibrary.getPreferredVersion())) {
                    JSONUtils.field((JsonWriter)json, (String)"version", (String)dBPDriverLibrary.getPreferredVersion());
                }
                if (!export && !CommonUtils.isEmpty(files = this.driver.getResolvedFiles().get(dBPDriverLibrary))) {
                    json.name("files");
                    json.beginObject();
                    for (DriverDescriptor.DriverFileInfo file : files) {
                        if (file.getFile() == null) {
                            log.warn((Object)("File missing in " + file.getId()));
                            continue;
                        }
                        json.name(file.getId());
                        json.beginObject();
                        if (!CommonUtils.isEmpty((String)file.getVersion())) {
                            JSONUtils.field((JsonWriter)json, (String)"version", (String)file.getVersion());
                        }
                        JSONUtils.field((JsonWriter)json, (String)"path", (String)DriverDescriptorSerializerModern.substitutePathVariables(pathSubstitutions, file.getFile().getAbsolutePath()));
                        json.endObject();
                    }
                    json.endObject();
                }
                json.endObject();
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty(this.driver.getNativeClientHomes())) {
            json.name("native-clients");
            json.beginObject();
            for (DBPNativeClientLocation dBPNativeClientLocation : this.driver.getNativeClientHomes()) {
                json.name(dBPNativeClientLocation.getName());
                json.beginObject();
                if (dBPNativeClientLocation.getPath() != null) {
                    JSONUtils.fieldNE((JsonWriter)json, (String)"path", (String)dBPNativeClientLocation.getPath().getAbsolutePath());
                }
                json.endObject();
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty(this.driver.getCustomParameters())) {
            json.name("driver-parameters");
            json.beginObject();
            for (Map.Entry entry : this.driver.getCustomParameters().entrySet()) {
                if (!this.driver.isCustom() && CommonUtils.equalObjects(entry.getValue(), (Object)this.driver.getDefaultParameters().get(entry.getKey()))) continue;
                json.name((String)entry.getKey());
                json.value(CommonUtils.toString(entry.getValue()));
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty(this.driver.getCustomConnectionProperties())) {
            json.name("connection-properties");
            json.beginObject();
            for (Map.Entry entry : this.driver.getCustomConnectionProperties().entrySet()) {
                if (CommonUtils.equalObjects(entry.getValue(), (Object)this.driver.getDefaultConnectionProperties().get(entry.getKey()))) continue;
                json.name(CommonUtils.toString(entry.getKey()));
                json.value(CommonUtils.toString(entry.getValue()));
            }
            json.endObject();
        }
        json.endObject();
    }
}

