/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.SortedMap;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.swt.IFocusService;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRCondition;
import org.jkiss.dbeaver.model.runtime.DBRCreator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRValueProvider;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DummyRunnableContext;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.SharedFonts;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.ui.dialogs.MessageBoxBuilder;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.dbeaver.ui.internal.UIActivator;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class UIUtils {
    private static final Log log = Log.getLog(UIUtils.class);
    private static final String INLINE_WIDGET_EDITOR_ID = "org.jkiss.dbeaver.ui.InlineWidgetEditor";
    private static final Color COLOR_BLACK = new Color(null, 0, 0, 0);
    private static final Color COLOR_WHITE = new Color(null, 255, 255, 255);
    private static final Color COLOR_WHITE_DARK = new Color(null, 208, 208, 208);
    private static final SharedTextColors SHARED_TEXT_COLORS = new SharedTextColors();
    private static final SharedFonts SHARED_FONTS = new SharedFonts();
    private static final String MAX_LONG_STRING = String.valueOf(Long.MAX_VALUE);

    public static VerifyListener getIntegerVerifyListener(Locale locale) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        return e -> {
            int i = 0;
            while (i < e.text.length()) {
                char ch = e.text.charAt(i);
                if (!Character.isDigit(ch) && ch != symbols.getMinusSign() && ch != symbols.getGroupingSeparator()) {
                    e.doit = false;
                    return;
                }
                ++i;
            }
            e.doit = true;
        };
    }

    public static VerifyListener getNumberVerifyListener(Locale locale) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        char[] allowedChars = new char[]{symbols.getDecimalSeparator(), symbols.getGroupingSeparator(), symbols.getMinusSign(), symbols.getZeroDigit(), symbols.getMonetaryDecimalSeparator(), '+', '.', ','};
        String exponentSeparator = symbols.getExponentSeparator();
        return e -> {
            int i = 0;
            while (i < e.text.length()) {
                char ch = e.text.charAt(i);
                if (!Character.isDigit(ch) && !ArrayUtils.contains((char[])allowedChars, (char)ch) && exponentSeparator.indexOf(ch) == -1) {
                    e.doit = false;
                    return;
                }
                ++i;
            }
            e.doit = true;
        };
    }

    public static VerifyListener getUnsignedLongOrEmptyTextVerifyListener(Text text) {
        return e -> {
            if (e.text.isEmpty()) {
                e.doit = true;
                return;
            }
            int i = 0;
            while (i < e.text.length()) {
                if (!Character.isDigit(e.text.charAt(i))) {
                    e.doit = false;
                    return;
                }
                ++i;
            }
            String newText = String.valueOf(text.getText().substring(0, e.start)) + e.text + text.getText().substring(e.end);
            if (newText.length() < MAX_LONG_STRING.length()) {
                e.doit = true;
                return;
            }
            if (newText.length() > MAX_LONG_STRING.length()) {
                e.doit = false;
                return;
            }
            e.doit = newText.compareTo(MAX_LONG_STRING) <= 0;
        };
    }

    public static void createToolBarSeparator(Composite toolBar, int style) {
        Label label = new Label(toolBar, 0);
        label.setImage(DBeaverIcons.getImage((DBPImage)((style & 0x100) == 256 ? UIIcon.SEPARATOR_H : UIIcon.SEPARATOR_V)));
    }

    public static void createLabelSeparator(Composite toolBar, int style) {
        Label label = new Label(toolBar, 2 | style);
        label.setLayoutData((Object)new GridData(style == 256 ? 768 : 1040));
    }

    public static void createToolBarSeparator(ToolBar toolBar, int style) {
        Label label = new Label((Composite)toolBar, 0);
        label.setImage(DBeaverIcons.getImage((DBPImage)((style & 0x100) == 256 ? UIIcon.SEPARATOR_H : UIIcon.SEPARATOR_V)));
        new ToolItem(toolBar, 2).setControl((Control)label);
    }

    public static TableColumn createTableColumn(Table table, int style, String text) {
        TableColumn column = new TableColumn(table, style);
        column.setText(text);
        return column;
    }

    public static TreeColumn createTreeColumn(Tree tree, int style, String text) {
        TreeColumn column = new TreeColumn(tree, style);
        column.setText(text);
        return column;
    }

    public static void executeOnResize(final Control control, final Runnable runnable) {
        control.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                control.removeControlListener((ControlListener)this);
                runnable.run();
            }
        });
    }

    public static void packColumns(Table table) {
        UIUtils.packColumns(table, false);
    }

    public static void packColumns(Table table, boolean fit) {
        table.setRedraw(false);
        try {
            int n;
            TableColumn[] tableColumnArray;
            TableColumn[] columns;
            int totalWidth = 0;
            TableColumn[] tableColumnArray2 = columns = table.getColumns();
            int n2 = columns.length;
            int n3 = 0;
            while (n3 < n2) {
                TableColumn column = tableColumnArray2[n3];
                column.pack();
                totalWidth += column.getWidth();
                ++n3;
            }
            Rectangle clientArea = table.getBounds();
            if (clientArea.width > 0 && totalWidth > clientArea.width) {
                TableColumn[] tableColumnArray3 = columns;
                int n4 = columns.length;
                n2 = 0;
                while (n2 < n4) {
                    TableColumn column = tableColumnArray3[n2];
                    int colWidth = column.getWidth();
                    if (colWidth > totalWidth / 3) {
                        column.setWidth(totalWidth / 3);
                        totalWidth -= colWidth;
                        totalWidth += column.getWidth();
                    }
                    ++n2;
                }
                if (totalWidth < clientArea.width) {
                    int extraSpace = totalWidth - clientArea.width;
                    GC gc = new GC((Drawable)table);
                    try {
                        tableColumnArray = columns;
                        n = columns.length;
                        int n5 = 0;
                        while (n5 < n) {
                            TableColumn tc = tableColumnArray[n5];
                            double ratio = (double)tc.getWidth() / (double)totalWidth;
                            int newWidth = (int)((double)tc.getWidth() - (double)extraSpace * ratio);
                            int minWidth = gc.stringExtent((String)tc.getText()).x;
                            if (newWidth < (minWidth += 5)) {
                                newWidth = minWidth;
                            }
                            tc.setWidth(newWidth);
                            ++n5;
                        }
                    }
                    finally {
                        gc.dispose();
                    }
                }
            }
            if (fit && totalWidth < clientArea.width) {
                int sbWidth = table.getBorderWidth() * 2;
                if (table.getVerticalBar() != null) {
                    sbWidth = table.getVerticalBar().getSize().x;
                }
                if (columns.length > 0) {
                    float extraSpace = (clientArea.width - totalWidth - sbWidth) / columns.length - 1;
                    tableColumnArray = columns;
                    n = columns.length;
                    int n6 = 0;
                    while (n6 < n) {
                        TableColumn tc = tableColumnArray[n6];
                        tc.setWidth((int)((float)tc.getWidth() + extraSpace));
                        ++n6;
                    }
                }
            }
        }
        finally {
            table.setRedraw(true);
        }
    }

    public static void packColumns(@NotNull Tree tree) {
        UIUtils.packColumns(tree, false, null);
    }

    public static void packColumns(@NotNull Tree tree, boolean fit, @Nullable float[] ratios) {
        block23: {
            tree.setRedraw(false);
            try {
                TreeColumn tc2;
                int n;
                TreeColumn[] columns;
                TreeItem[] treeItemArray = tree.getItems();
                int n2 = treeItemArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    TreeItem item = treeItemArray[n3];
                    if (item.isDisposed()) {
                        return;
                    }
                    ++n3;
                }
                TreeColumn[] treeColumnArray = columns = tree.getColumns();
                int n4 = columns.length;
                n2 = 0;
                while (n2 < n4) {
                    TreeColumn column = treeColumnArray[n2];
                    column.pack();
                    ++n2;
                }
                Rectangle clientArea = tree.getClientArea();
                if (clientArea.isEmpty()) {
                    return;
                }
                int totalWidth = 0;
                TreeColumn[] treeColumnArray2 = columns;
                int n5 = columns.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeColumn column = treeColumnArray2[n6];
                    int colWidth = column.getWidth();
                    if (colWidth > clientArea.width) {
                        colWidth = clientArea.width;
                        column.setWidth(colWidth);
                    }
                    totalWidth += colWidth;
                    ++n6;
                }
                if (!fit) break block23;
                int areaWidth = clientArea.width;
                if (totalWidth > areaWidth) {
                    GC gc = new GC((Drawable)tree);
                    try {
                        int extraSpace = totalWidth - areaWidth;
                        TreeColumn[] treeColumnArray3 = columns;
                        int n7 = columns.length;
                        n = 0;
                        while (n < n7) {
                            tc2 = treeColumnArray3[n];
                            double ratio = (double)tc2.getWidth() / (double)totalWidth;
                            int newWidth = (int)((double)tc2.getWidth() - (double)extraSpace * ratio);
                            int minWidth = gc.stringExtent((String)tc2.getText()).x;
                            if (newWidth < (minWidth += 5)) {
                                newWidth = minWidth;
                            }
                            tc2.setWidth(newWidth);
                            ++n;
                        }
                        break block23;
                    }
                    finally {
                        gc.dispose();
                    }
                }
                if (totalWidth < areaWidth) {
                    float extraSpace = areaWidth - totalWidth;
                    if (columns.length > 0) {
                        if (ratios == null || ratios.length < columns.length) {
                            extraSpace /= (float)columns.length;
                            extraSpace -= 1.0f;
                            TreeColumn[] treeColumnArray4 = columns;
                            n = columns.length;
                            int tc2 = 0;
                            while (tc2 < n) {
                                TreeColumn tc3 = treeColumnArray4[tc2];
                                tc3.setWidth((int)((float)tc3.getWidth() + extraSpace));
                                ++tc2;
                            }
                        } else {
                            int i = 0;
                            while (i < columns.length) {
                                tc2 = columns[i];
                                tc2.setWidth((int)((float)tc2.getWidth() + extraSpace * ratios[i]));
                                ++i;
                            }
                        }
                    }
                }
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    public static void maxTableColumnsWidth(Table table) {
        table.setRedraw(false);
        try {
            int columnCount = table.getColumnCount();
            if (columnCount > 0) {
                TableColumn[] columns;
                int totalWidth = 0;
                TableColumn[] tableColumnArray = columns = table.getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tc = tableColumnArray[n2];
                    tc.pack();
                    totalWidth += tc.getWidth();
                    ++n2;
                }
                Rectangle clientArea = table.getClientArea();
                if (totalWidth < clientArea.width) {
                    int extraSpace = clientArea.width - totalWidth;
                    extraSpace /= columnCount;
                    TableColumn[] tableColumnArray2 = columns;
                    int n3 = columns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TableColumn tc = tableColumnArray2[n4];
                        tc.setWidth(tc.getWidth() + extraSpace);
                        ++n4;
                    }
                }
            }
        }
        finally {
            table.setRedraw(true);
        }
    }

    public static int getColumnAtPos(TableItem item, int x, int y) {
        int columnCount = item.getParent().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getColumnAtPos(TreeItem item, int x, int y) {
        int columnCount = item.getParent().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static TableItem getNextTableItem(Table table, TableItem item) {
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length - 1) {
            if (items[i] == item) {
                return items[i + 1];
            }
            ++i;
        }
        return null;
    }

    public static TableItem getPreviousTableItem(Table table, TableItem item) {
        TableItem[] items = table.getItems();
        int i = 1;
        while (i < items.length) {
            if (items[i] == item) {
                return items[i - 1];
            }
            ++i;
        }
        return null;
    }

    public static TreeItem getNextTreeItem(Tree tree, TreeItem item) {
        TreeItem[] items = tree.getItems();
        int i = 0;
        while (i < items.length - 1) {
            if (items[i] == item) {
                return items[i + 1];
            }
            ++i;
        }
        return null;
    }

    public static void dispose(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            try {
                widget.dispose();
            }
            catch (Exception e) {
                log.debug((Object)"widget dispose error", (Throwable)e);
            }
        }
    }

    public static void dispose(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            try {
                resource.dispose();
            }
            catch (Exception e) {
                log.debug((Object)"Resource dispose error", (Throwable)e);
            }
        }
    }

    public static void showMessageBox(Shell shell, String title, String info, int messageType) {
        Runnable messageBoxRunnable;
        DBIcon icon = null;
        if (messageType == 1) {
            icon = DBIcon.STATUS_ERROR;
        } else if (messageType == 8) {
            icon = DBIcon.STATUS_WARNING;
        } else if (messageType == 4) {
            icon = DBIcon.STATUS_QUESTION;
        } else if (messageType == 2) {
            icon = DBIcon.STATUS_INFO;
        }
        if (icon != null) {
            DBIcon finalIcon = icon;
            messageBoxRunnable = () -> UIUtils.lambda$3(shell, title, info, (DBPImage)finalIcon);
        } else {
            messageBoxRunnable = () -> {
                Shell activeShell = shell != null ? shell : UIUtils.getActiveWorkbenchShell();
                MessageBox messageBox = new MessageBox(activeShell, messageType | 0x20);
                messageBox.setMessage(info);
                messageBox.setText(title);
                messageBox.open();
            };
        }
        UIUtils.syncExec(messageBoxRunnable);
    }

    public static boolean confirmAction(String title, String question) {
        return UIUtils.confirmAction(null, title, question);
    }

    public static boolean confirmAction(@Nullable Shell shell, String title, String question) {
        return UIUtils.confirmAction(shell, title, question, (DBPImage)DBIcon.STATUS_QUESTION);
    }

    public static boolean confirmAction(@Nullable Shell shell, String title, String message, @NotNull DBPImage image) {
        Reply[] reply = new Reply[1];
        UIUtils.syncExec(() -> {
            Reply reply = MessageBoxBuilder.builder(shell != null ? shell : UIUtils.getActiveWorkbenchShell()).setTitle(title).setMessage(message).setReplies(Reply.YES, Reply.NO).setDefaultReply(Reply.NO).setPrimaryImage(image).showMessageBox();
        });
        return reply[0] == Reply.YES;
    }

    public static int getFontHeight(Control control) {
        return UIUtils.getFontHeight(control.getFont());
    }

    public static int getFontHeight(Font font) {
        FontData[] fontData = font.getFontData();
        if (fontData.length == 0) {
            return 20;
        }
        return fontData[0].getHeight();
    }

    public static int getTextHeight(@NotNull Control control) {
        return UIUtils.getTextSize((Control)control, (String)"X").y;
    }

    @NotNull
    public static Point getTextSize(@NotNull Control control, @NotNull String text) {
        GC gc = new GC((Drawable)control);
        try {
            Point point = gc.textExtent(text);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    public static Font makeBoldFont(Font normalFont) {
        return UIUtils.modifyFont(normalFont, 1);
    }

    @NotNull
    public static Font modifyFont(@NotNull Font normalFont, int style) {
        FontData[] data;
        FontData[] fontDataArray = data = normalFont.getFontData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(fd.getStyle() | style);
            ++n2;
        }
        return new Font(normalFont.getDevice(), data);
    }

    public static Group createControlGroup(Composite parent, String label, int columns, int layoutStyle, int widthHint) {
        Group group = new Group(parent, 0);
        group.setText(label);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(layoutStyle);
            if (widthHint > 0) {
                gd.widthHint = widthHint;
            }
            group.setLayoutData((Object)gd);
        }
        GridLayout gl = new GridLayout(columns, false);
        group.setLayout((Layout)gl);
        return group;
    }

    public static Label createControlLabel(Composite parent, String label) {
        return UIUtils.createControlLabel(parent, label, 1);
    }

    public static Label createControlLabel(Composite parent, String label, int hSpan) {
        Label textLabel = new Label(parent, 0);
        textLabel.setText(String.valueOf(label) + ": ");
        GridData gd = new GridData(4);
        gd.horizontalSpan = hSpan;
        textLabel.setLayoutData((Object)gd);
        return textLabel;
    }

    public static Label createLabel(Composite parent, String label) {
        Label textLabel = new Label(parent, 0);
        textLabel.setText(label);
        return textLabel;
    }

    public static Label createLabel(Composite parent, @NotNull DBPImage image) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setImage(DBeaverIcons.getImage(image));
        return imageLabel;
    }

    public static CLabel createInfoLabel(Composite parent, String text) {
        CLabel tipLabel = new CLabel(parent, 0);
        tipLabel.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_INFO));
        tipLabel.setText(text);
        return tipLabel;
    }

    public static CLabel createInfoLabel(Composite parent, String text, int gridStyle, int hSpan) {
        CLabel tipLabel = new CLabel(parent, 0);
        tipLabel.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_INFO));
        tipLabel.setText(text);
        GridData gd = new GridData(gridStyle);
        if (hSpan > 1) {
            gd.horizontalSpan = hSpan;
        }
        tipLabel.setLayoutData((Object)gd);
        return tipLabel;
    }

    public static Text createLabelText(Composite parent, String label, String value) {
        return UIUtils.createLabelText(parent, label, value, 2048);
    }

    public static Text createLabelText(Composite parent, String label, String value, int style) {
        return UIUtils.createLabelText(parent, label, value, style, new GridData(768));
    }

    @NotNull
    public static Text createLabelText(@NotNull Composite parent, @NotNull String label, @Nullable String value, int style, @Nullable Object layoutData) {
        UIUtils.createControlLabel(parent, label);
        Text text = new Text(parent, style);
        UIUtils.fixReadonlyTextBackground(text);
        if (value != null) {
            text.setText(value);
        }
        if (layoutData != null) {
            text.setLayoutData(layoutData);
        }
        return text;
    }

    @NotNull
    public static Text createLabelTextAdvanced(final @NotNull Composite parent, final @NotNull String label, @Nullable String value, int style) {
        UIUtils.createControlLabel(parent, label);
        Composite panel = UIUtils.createComposite(parent, 2);
        panel.setLayoutData((Object)new GridData(768));
        final Text text = new Text(panel, style);
        text.setLayoutData((Object)new GridData(768));
        UIUtils.fixReadonlyTextBackground(text);
        if (value != null) {
            text.setText(value);
        }
        ToolBar editTB = new ToolBar(panel, 256);
        ToolItem editButton = new ToolItem(editTB, 1024);
        editButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.EDIT));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newText = EditTextDialog.editText(parent.getShell(), label, text.getText());
                if (newText != null) {
                    text.setText(newText);
                }
            }
        });
        editTB.setLayoutData((Object)new GridData(32));
        return text;
    }

    @NotNull
    public static Spinner createLabelSpinner(@NotNull Composite parent, @NotNull String label, @Nullable String tooltip, int value, int minimum, int maximum) {
        Label l = UIUtils.createControlLabel(parent, label);
        if (tooltip != null) {
            l.setToolTipText(tooltip);
        }
        return UIUtils.createSpinner(parent, tooltip, value, minimum, maximum);
    }

    @NotNull
    public static Spinner createSpinner(Composite parent, String tooltip, int value, int minimum, int maximum) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMinimum(minimum);
        spinner.setMaximum(maximum);
        spinner.setSelection(value);
        if (tooltip != null) {
            spinner.setToolTipText(tooltip);
        }
        return spinner;
    }

    @NotNull
    public static Spinner createLabelSpinner(@NotNull Composite parent, @NotNull String label, int value, int minimum, int maximum) {
        return UIUtils.createLabelSpinner(parent, label, null, value, minimum, maximum);
    }

    @NotNull
    public static Button createLabelCheckbox(Composite parent, String label, boolean checked) {
        return UIUtils.createLabelCheckbox(parent, label, null, checked, 0);
    }

    @NotNull
    public static Button createLabelCheckbox(Composite parent, String label, String tooltip, boolean checked) {
        return UIUtils.createLabelCheckbox(parent, label, tooltip, checked, 0);
    }

    @NotNull
    public static Button createLabelCheckbox(@NotNull Composite parent, @NotNull String label, @Nullable String tooltip, boolean checked, int style) {
        Label labelControl = UIUtils.createControlLabel(parent, label);
        final Button button = new Button(parent, 0x20 | style);
        if (checked) {
            button.setSelection(true);
        }
        labelControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!button.isDisposed() && button.isVisible() && button.isEnabled()) {
                    button.setSelection(!button.getSelection());
                    button.notifyListeners(13, new Event());
                }
            }
        });
        if (tooltip != null) {
            labelControl.setToolTipText(tooltip);
            button.setToolTipText(tooltip);
        }
        return button;
    }

    public static Button createCheckbox(Composite parent, String label, String tooltip, boolean checked, int hSpan) {
        Button checkbox = UIUtils.createCheckbox(parent, label, checked);
        if (tooltip != null) {
            checkbox.setToolTipText(tooltip);
        }
        if (hSpan > 1) {
            GridData gd = new GridData(32);
            gd.horizontalSpan = hSpan;
            checkbox.setLayoutData((Object)gd);
        }
        return checkbox;
    }

    public static Button createCheckbox(Composite parent, String label, boolean checked) {
        Button button = new Button(parent, 32);
        button.setText(label);
        if (checked) {
            button.setSelection(true);
        }
        return button;
    }

    public static Button createCheckbox(Composite parent, boolean checked) {
        Button button = new Button(parent, 32);
        if (checked) {
            button.setSelection(true);
        }
        return button;
    }

    public static Combo createLabelCombo(Composite parent, String label, int style) {
        return UIUtils.createLabelCombo(parent, label, null, style);
    }

    public static Combo createLabelCombo(Composite parent, String label, String tooltip, int style) {
        Label labelControl = UIUtils.createControlLabel(parent, label);
        if (tooltip != null) {
            labelControl.setToolTipText(tooltip);
        }
        Combo combo = new Combo(parent, style);
        combo.setLayoutData((Object)new GridData(768));
        if (tooltip != null) {
            combo.setToolTipText(tooltip);
        }
        return combo;
    }

    public static Button createToolButton(Composite parent, String text, SelectionListener selectionListener) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    public static ToolItem createToolItem(ToolBar parent, String text, DBPImage icon, SelectionListener selectionListener) {
        return UIUtils.createToolItem(parent, text, icon != null ? DBeaverIcons.getImage(icon) : null, selectionListener);
    }

    public static ToolItem createToolItem(ToolBar parent, String title, String text, DBPImage icon, SelectionListener selectionListener) {
        ToolItem toolItem = UIUtils.createToolItem(parent, text, icon != null ? DBeaverIcons.getImage(icon) : null, selectionListener);
        if (title != null) {
            toolItem.setText(title);
        }
        return toolItem;
    }

    public static ToolItem createToolItem(ToolBar parent, String text, Image icon, SelectionListener selectionListener) {
        ToolItem button = new ToolItem(parent, 8);
        button.setToolTipText(text);
        if (icon != null) {
            button.setImage(icon);
        }
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    public static void updateContributionItems(IContributionManager manager) {
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.update();
            ++n2;
        }
    }

    @Nullable
    public static Shell getActiveShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        return workbench == null ? null : UIUtils.getShell((IShellProvider)workbench.getActiveWorkbenchWindow());
    }

    @Nullable
    public static Shell getShell(IShellProvider provider) {
        return provider == null ? null : provider.getShell();
    }

    @Nullable
    public static Shell getShell(IWorkbenchPart part) {
        return part == null ? null : UIUtils.getShell((IShellProvider)part.getSite());
    }

    @Nullable
    public static Integer getTextInteger(Text text) {
        String str = text.getText();
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            log.debug((Object)e);
            return null;
        }
    }

    @Nullable
    public static IHandlerActivation registerKeyBinding(IServiceLocator serviceLocator, IAction action) {
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        if (handlerService != null) {
            return handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
        }
        return null;
    }

    public static Composite createPlaceholder(Composite parent, int columns) {
        return UIUtils.createPlaceholder(parent, columns, 0);
    }

    public static Composite createComposite(Composite parent, int columns) {
        Composite ph = new Composite(parent, 0);
        GridLayout gl = new GridLayout(columns, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        ph.setLayout((Layout)gl);
        return ph;
    }

    public static Composite createPlaceholder(Composite parent, int columns, int spacing) {
        Composite ph = new Composite(parent, 0);
        GridLayout gl = new GridLayout(columns, false);
        gl.verticalSpacing = spacing;
        gl.horizontalSpacing = spacing;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        ph.setLayout((Layout)gl);
        return ph;
    }

    public static Composite createFormPlaceholder(Composite parent, int columns, int hSpan) {
        Composite ph = new Composite(parent, 0);
        GridLayout gl = new GridLayout(columns, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        ph.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hSpan;
        ph.setLayoutData((Object)gd);
        return ph;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setGridSpan(Control control, int horizontalSpan, int verticalSpan) {
        GridData gd;
        Object layoutData = control.getLayoutData();
        if (layoutData == null) {
            if (!(control.getParent().getLayout() instanceof GridLayout)) {
                log.debug((Object)("Can't set grid span for layout: " + control.getParent().getLayout()));
                return;
            }
            gd = new GridData();
            control.setLayoutData((Object)gd);
        } else {
            if (!(layoutData instanceof GridData)) {
                log.debug((Object)("Can't set grid span for non-grid layout: " + layoutData.getClass().getName()));
                return;
            }
            gd = (GridData)layoutData;
        }
        gd.horizontalSpan = horizontalSpan;
        gd.verticalSpan = verticalSpan;
    }

    public static Label createHorizontalLine(Composite parent) {
        return UIUtils.createHorizontalLine(parent, 1, 0);
    }

    public static Label createHorizontalLine(Composite parent, int hSpan, int vIndent) {
        Label horizontalLine = new Label(parent, 258);
        GridData gd = new GridData(4, 4, true, false, 1, 1);
        gd.horizontalSpan = hSpan;
        gd.verticalIndent = vIndent;
        horizontalLine.setLayoutData((Object)gd);
        return horizontalLine;
    }

    public static Label createVerticalLine(Composite parent) {
        Label horizontalLine = new Label(parent, 514);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(4, 4, false, true, 1, 1);
            horizontalLine.setLayoutData((Object)gd);
        }
        return horizontalLine;
    }

    @Nullable
    public static String getComboSelection(Combo combo) {
        int selectionIndex = combo.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        return combo.getItem(selectionIndex);
    }

    public static boolean setComboSelection(Combo combo, String value) {
        if (value == null) {
            return false;
        }
        int count = combo.getItemCount();
        int i = 0;
        while (i < count) {
            if (value.equals(combo.getItem(i))) {
                combo.select(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Combo createEncodingCombo(Composite parent, @Nullable String curCharset) {
        Combo encodingCombo = new Combo(parent, 4);
        encodingCombo.setVisibleItemCount(30);
        SortedMap<String, Charset> charsetMap = Charset.availableCharsets();
        int index = 0;
        int defIndex = -1;
        for (String csName : charsetMap.keySet()) {
            Charset charset = (Charset)charsetMap.get(csName);
            encodingCombo.add(charset.displayName());
            if (curCharset != null) {
                if (charset.displayName().equalsIgnoreCase(curCharset)) {
                    defIndex = index;
                }
                if (defIndex < 0) {
                    for (String alias : charset.aliases()) {
                        if (!alias.equalsIgnoreCase(curCharset)) continue;
                        defIndex = index;
                    }
                }
            }
            ++index;
        }
        if (defIndex >= 0) {
            encodingCombo.select(defIndex);
        } else if (curCharset != null) {
            log.warn((Object)("Charset '" + curCharset + "' is not recognized"));
        }
        return encodingCombo;
    }

    @NotNull
    public static CustomSashForm createPartDivider(IWorkbenchPart workbenchPart, Composite parent, int style) {
        CustomSashForm sash = new CustomSashForm(parent, style);
        return sash;
    }

    @NotNull
    public static String formatMessage(@Nullable String message, Object ... args) {
        if (message == null) {
            return "";
        }
        return MessageFormat.format(message, args);
    }

    @NotNull
    public static Button createPushButton(@NotNull Composite parent, @Nullable String label, @Nullable Image image) {
        return UIUtils.createPushButton(parent, label, image, null);
    }

    @NotNull
    public static Button createPushButton(@NotNull Composite parent, @Nullable String label, @Nullable Image image, @Nullable SelectionListener selectionListener) {
        Button button = new Button(parent, 8);
        if (label != null) {
            button.setText(label);
        }
        if (image != null) {
            button.setImage(image);
        }
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    @NotNull
    public static Button createDialogButton(@NotNull Composite parent, @Nullable String label, @Nullable SelectionListener selectionListener) {
        return UIUtils.createDialogButton(parent, label, null, null, selectionListener);
    }

    @NotNull
    public static Button createDialogButton(@NotNull Composite parent, @Nullable String label, @Nullable DBPImage icon, @Nullable String toolTip, @Nullable SelectionListener selectionListener) {
        int widthHint;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        if (icon != null) {
            button.setImage(DBeaverIcons.getImage(icon));
        }
        if (toolTip != null) {
            button.setToolTipText(toolTip);
        }
        GridData gd = new GridData(256);
        GC gc = new GC((Drawable)button);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)61);
        }
        finally {
            gc.dispose();
        }
        Point minSize = button.computeSize(-1, -1, true);
        gd.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)gd);
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    @NotNull
    public static Button createRadioButton(@NotNull Composite parent, @Nullable String label, @NotNull Object data, @Nullable SelectionListener selectionListener) {
        Button button = new Button(parent, 16);
        button.setText(label);
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        button.setData(data);
        return button;
    }

    public static void setHelp(Control control, String pluginId, String helpContextID) {
        if (control != null && !control.isDisposed()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, String.valueOf(pluginId) + "." + helpContextID);
        }
    }

    public static void setHelp(Control control, String helpContextID) {
        UIUtils.setHelp(control, "org.jkiss.dbeaver.ui", helpContextID);
    }

    public static String makeAnchor(String text) {
        return "<a>" + text + "</a>";
    }

    @Nullable
    public static <T> T findView(IWorkbenchWindow workbenchWindow, Class<T> viewClass) {
        IViewReference[] references;
        IViewReference[] iViewReferenceArray = references = workbenchWindow.getActivePage().getViewReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            IViewPart view = ref.getView(false);
            if (view != null && viewClass.isAssignableFrom(view.getClass())) {
                return viewClass.cast(view);
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public static IViewPart findView(IWorkbenchWindow workbenchWindow, String viewId) {
        IViewReference[] references;
        IViewReference[] iViewReferenceArray = references = workbenchWindow.getActivePage().getViewReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals(viewId)) {
                return ref.getView(false);
            }
            ++n2;
        }
        return null;
    }

    public static void setClipboardContents(Display display, Transfer transfer, Object contents) {
        Clipboard clipboard = new Clipboard(display);
        clipboard.setContents(new Object[]{contents}, new Transfer[]{transfer});
        clipboard.dispose();
    }

    public static void showPreferencesFor(Shell shell, Object element, String ... defPageID) {
        PreferenceDialog propDialog = element == null ? PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)defPageID[0], (String[])defPageID, null, (int)0) : PreferencesUtil.createPropertyDialogOn((Shell)shell, (Object)element, (String)defPageID[0], null, null, (int)0);
        if (propDialog != null) {
            propDialog.open();
        }
    }

    public static void addFocusTracker(IServiceLocator serviceLocator, String controlID, Control control) {
        IFocusService focusService = (IFocusService)serviceLocator.getService(IFocusService.class);
        if (focusService == null) {
            focusService = (IFocusService)UIUtils.getActiveWorkbenchWindow().getService(IFocusService.class);
        }
        if (focusService != null) {
            IFocusService finalFocusService = focusService;
            finalFocusService.addFocusTracker(control, controlID);
            control.addDisposeListener(e -> finalFocusService.removeFocusTracker(control));
        } else {
            log.debug((Object)("Focus service not found in " + serviceLocator));
        }
    }

    public static void addDefaultEditActionsSupport(IServiceLocator site, Control control) {
        UIUtils.addFocusTracker(site, INLINE_WIDGET_EDITOR_ID, control);
    }

    @NotNull
    public static IDialogSettings getDialogSettings(@NotNull String dialogId) {
        IDialogSettings workbenchSettings = UIActivator.getDefault().getDialogSettings();
        return UIUtils.getSettingsSection(workbenchSettings, dialogId);
    }

    @NotNull
    public static IDialogSettings getSettingsSection(@NotNull IDialogSettings parent, @NotNull String sectionId) {
        IDialogSettings section = parent.getSection(sectionId);
        if (section == null) {
            section = parent.addNewSection(sectionId);
        }
        return section;
    }

    public static void putSectionValueWithType(IDialogSettings dialogSettings, @NotNull String key, Object value) {
        if (value == null) {
            dialogSettings.put(key, null);
            return;
        }
        if (value instanceof Double) {
            dialogSettings.put(key, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            dialogSettings.put(key, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            dialogSettings.put(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            dialogSettings.put(key, ((Long)value).longValue());
        } else if (value instanceof String) {
            dialogSettings.put(key, (String)value);
        } else if (value instanceof Boolean) {
            dialogSettings.put(key, ((Boolean)value).booleanValue());
        }
        dialogSettings.put(String.valueOf(key) + "_type", value.getClass().getSimpleName());
    }

    public static Object getSectionValueWithType(IDialogSettings dialogSettings, @NotNull String key) {
        block22: {
            String type = dialogSettings.get(String.valueOf(key) + "_type");
            if (type == null) break block22;
            switch (type) {
                case "Double": {
                    return dialogSettings.getDouble(key);
                }
                case "Float": {
                    return Float.valueOf(dialogSettings.getFloat(key));
                }
                case "Integer": {
                    return dialogSettings.getInt(key);
                }
                case "Long": {
                    return dialogSettings.getLong(key);
                }
                case "String": {
                    return dialogSettings.get(key);
                }
                case "Boolean": {
                    return dialogSettings.getBoolean(key);
                }
            }
        }
        return dialogSettings.get(key);
    }

    @Nullable
    public static IWorkbenchPartSite getWorkbenchPartSite(IServiceLocator serviceLocator) {
        IWorkbenchPartSite partSite = (IWorkbenchPartSite)serviceLocator.getService(IWorkbenchPartSite.class);
        if (partSite == null) {
            IWorkbenchPage activePage;
            IWorkbenchWindow workbenchWindow;
            IWorkbenchPart activePart = (IWorkbenchPart)serviceLocator.getService(IWorkbenchPart.class);
            if (activePart == null && (workbenchWindow = UIUtils.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null) {
                activePart = activePage.getActivePart();
            }
            if (activePart != null) {
                partSite = activePart.getSite();
            }
        }
        return partSite;
    }

    public static boolean isContextActive(String contextId) {
        Collection contextIds = ((IContextService)UIUtils.getActiveWorkbenchWindow().getService(IContextService.class)).getActiveContextIds();
        for (Object id : contextIds) {
            if (!contextId.equals(id)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ISelectionProvider getSelectionProvider(IServiceLocator serviceLocator) {
        ISelectionProvider selectionProvider = (ISelectionProvider)serviceLocator.getService(ISelectionProvider.class);
        if (selectionProvider != null) {
            return selectionProvider;
        }
        IWorkbenchPartSite partSite = UIUtils.getWorkbenchPartSite(serviceLocator);
        if (partSite == null) {
            IWorkbenchWindow activeWindow;
            IWorkbenchPart activePart = (IWorkbenchPart)serviceLocator.getService(IWorkbenchPart.class);
            if (activePart == null && (activeWindow = UIUtils.getActiveWorkbenchWindow()) != null) {
                activePart = activeWindow.getActivePage().getActivePart();
            }
            if (activePart != null) {
                partSite = activePart.getSite();
            }
        }
        if (partSite != null) {
            return partSite.getSelectionProvider();
        }
        return null;
    }

    public static void enableWithChildren(Control control, boolean enable) {
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    UIUtils.enableWithChildren(child, enable);
                } else {
                    child.setEnabled(enable);
                }
                ++n2;
            }
        }
    }

    public static boolean isUIThread() {
        return Display.getDefault().getThread() == Thread.currentThread();
    }

    public static boolean hasFocus(Control control) {
        if (control == null || control.isDisposed()) {
            return false;
        }
        Control focusControl = control.getDisplay().getFocusControl();
        if (focusControl == null) {
            return false;
        }
        Control fc = focusControl;
        while (fc != null) {
            if (fc == control) {
                return true;
            }
            fc = fc.getParent();
        }
        return false;
    }

    public static CTabItem getTabItem(CTabFolder tabFolder, Object data) {
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData() == data) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static void disposeControlOnItemDispose(CTabItem tabItem) {
        tabItem.addDisposeListener(e -> {
            Control control = tabItem.getControl();
            if (!control.isDisposed()) {
                control.dispose();
            }
        });
    }

    public static TreeItem getTreeItem(Tree tree, Object data) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() == data) {
                return item;
            }
            TreeItem child = UIUtils.getTreeItem(item, data);
            if (child != null) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private static TreeItem getTreeItem(TreeItem parent, Object data) {
        TreeItem[] treeItemArray = parent.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() == data) {
                return item;
            }
            TreeItem child = UIUtils.getTreeItem(item, data);
            if (child != null) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public static int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = UIUtils.blend(c1.red, c2.red, ratio);
        int g = UIUtils.blend(c1.green, c2.green, ratio);
        int b = UIUtils.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    public static boolean isParent(Control parent, Control child) {
        Control c = child;
        while (c != null) {
            if (c == parent) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    public static boolean isInDialog() {
        try {
            Shell activeShell = Display.getCurrent().getActiveShell();
            return activeShell != null && UIUtils.isInDialog((Control)activeShell);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isInDialog(Control control) {
        return control.getShell().getData() instanceof Dialog;
    }

    public static boolean isInWizard(Control control) {
        return control.getShell().getData() instanceof IWizardContainer;
    }

    public static Link createLink(Composite parent, String text, SelectionListener listener) {
        Link link = new Link(parent, 0);
        link.setText(text);
        link.addSelectionListener(listener);
        return link;
    }

    public static void postEvent(Control ownerControl, Event event) {
        Display display = ownerControl.getDisplay();
        UIUtils.asyncExec(() -> {
            boolean bl = display.post(event);
        });
    }

    public static void drawMessageOverControl(Control control, PaintEvent e, String message, int offset) {
        UIUtils.drawMessageOverControl(control, e.gc, message, offset);
    }

    public static void drawMessageOverControl(Control control, GC gc, String message, int offset) {
        Rectangle bounds = control.getBounds();
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            line = line.trim();
            Point ext = gc.textExtent(line);
            gc.drawText(line, (bounds.width - ext.x) / 2, bounds.height / 2 + offset);
            offset += ext.y;
            ++n2;
        }
    }

    public static void createTableContextMenu(@NotNull Table table, @Nullable DBRCreator<Boolean, IContributionManager> menuCreator) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            if (menuCreator != null && !((Boolean)menuCreator.createObject((Object)menuMgr)).booleanValue()) {
                return;
            }
            UIUtils.fillDefaultTableContextMenu((IContributionManager)manager, table);
        });
        menuMgr.setRemoveAllWhenShown(true);
        table.setMenu(menuMgr.createContextMenu((Control)table));
        table.addDisposeListener(e -> menuMgr.dispose());
    }

    public static void setControlContextMenu(Control control, IMenuListener menuListener) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(menuListener);
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menuMgr.createContextMenu(control));
        control.addDisposeListener(e -> menuMgr.dispose());
    }

    public static void fillDefaultTableContextMenu(IContributionManager menu, final Table table) {
        if (table.getColumnCount() > 1) {
            menu.add((IAction)new Action("Copy " + table.getColumn(0).getText()){

                public void run() {
                    StringBuilder text = new StringBuilder();
                    TableItem[] tableItemArray = table.getSelection();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (text.length() > 0) {
                            text.append("\n");
                        }
                        text.append(item.getText(0));
                        ++n2;
                    }
                    if (text.length() == 0) {
                        return;
                    }
                    UIUtils.setClipboardContents(table.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
                }
            });
        }
        menu.add((IAction)new Action("Copy All"){

            public void run() {
                StringBuilder text = new StringBuilder();
                int columnCount = table.getColumnCount();
                TableItem[] tableItemArray = table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (text.length() > 0) {
                        text.append("\n");
                    }
                    int i = 0;
                    while (i < columnCount) {
                        if (i > 0) {
                            text.append("\t");
                        }
                        text.append(item.getText(i));
                        ++i;
                    }
                    ++n2;
                }
                if (text.length() == 0) {
                    return;
                }
                UIUtils.setClipboardContents(table.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
            }
        });
    }

    public static void fillDefaultTreeContextMenu(IContributionManager menu, final Tree tree) {
        if (tree.getColumnCount() > 1) {
            menu.add((IAction)new Action("Copy " + tree.getColumn(0).getText()){

                public void run() {
                    StringBuilder text = new StringBuilder();
                    TreeItem[] treeItemArray = tree.getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (text.length() > 0) {
                            text.append("\n");
                        }
                        text.append(item.getText(0));
                        ++n2;
                    }
                    if (text.length() == 0) {
                        return;
                    }
                    UIUtils.setClipboardContents(tree.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
                }
            });
        }
        menu.add((IAction)new Action("Copy All"){

            public void run() {
                StringBuilder text = new StringBuilder();
                int columnCount = tree.getColumnCount();
                TreeItem[] treeItemArray = tree.getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (text.length() > 0) {
                        text.append("\n");
                    }
                    int i = 0;
                    while (i < columnCount) {
                        if (i > 0) {
                            text.append("\t");
                        }
                        text.append(item.getText(i));
                        ++i;
                    }
                    ++n2;
                }
                if (text.length() == 0) {
                    return;
                }
                UIUtils.setClipboardContents(tree.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
            }
        });
    }

    public static void addFileOpenOverlay(Text text, SelectionListener listener) {
        Image browseImage = DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER);
        Rectangle iconBounds = browseImage.getBounds();
        text.addPaintListener(e -> {
            Rectangle bounds = ((Text)e.widget).getBounds();
            e.gc.drawImage(browseImage, bounds.width - rectangle.width - 2, 0);
        });
    }

    public static Combo createDelimiterCombo(Composite group, String label, String[] options, String defDelimiter, boolean multiDelims) {
        UIUtils.createControlLabel(group, label);
        Combo combo = new Combo(group, 2052);
        combo.setLayoutData((Object)new GridData(768));
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            combo.add(CommonUtils.escapeDisplayString((String)option));
            ++n2;
        }
        if (!multiDelims) {
            if (!ArrayUtils.contains((Object[])options, (Object)defDelimiter)) {
                combo.add(CommonUtils.escapeDisplayString((String)defDelimiter));
            }
            String[] items = combo.getItems();
            int i = 0;
            int itemsLength = items.length;
            while (i < itemsLength) {
                String delim = CommonUtils.unescapeDisplayString((String)items[i]);
                if (delim.equals(defDelimiter)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        } else {
            combo.setText(CommonUtils.escapeDisplayString((String)defDelimiter));
        }
        return combo;
    }

    public static SharedTextColors getSharedTextColors() {
        return SHARED_TEXT_COLORS;
    }

    public static SharedFonts getSharedFonts() {
        return SHARED_FONTS;
    }

    public static void run(IRunnableContext runnableContext, boolean fork, boolean cancelable, DBRRunnableWithProgress runnableWithProgress) throws InvocationTargetException, InterruptedException {
        runnableContext.run(fork, cancelable, monitor -> runnableWithProgress.run(RuntimeUtils.makeMonitor((IProgressMonitor)monitor)));
    }

    public static AbstractUIJob runUIJob(String jobName, DBRRunnableWithProgress runnableWithProgress) {
        return UIUtils.runUIJob(jobName, 0, runnableWithProgress);
    }

    public static AbstractUIJob runUIJob(String jobName, int timeout, final DBRRunnableWithProgress runnableWithProgress) {
        AbstractUIJob job = new AbstractUIJob(jobName){

            @Override
            public IStatus runInUIThread(DBRProgressMonitor monitor) {
                try {
                    runnableWithProgress.run(monitor);
                }
                catch (InvocationTargetException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(timeout);
        return job;
    }

    @Nullable
    public static IWorkbenchWindow findActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    @NotNull
    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow workbenchWindow = UIUtils.findActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            throw new IllegalStateException("No workbench window");
        }
        return workbenchWindow;
    }

    public static IWorkbenchWindow getParentWorkbenchWindow(Control control) {
        Composite p = control.getParent();
        while (p != null) {
            if (p.getData() instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)p.getData();
            }
            p = p.getParent();
        }
        return null;
    }

    @Nullable
    public static Shell getActiveWorkbenchShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return Display.getDefault().getActiveShell();
    }

    public static DBRRunnableContext getDefaultRunnableContext() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && workbench.getActiveWorkbenchWindow() != null) {
            return new RunnableContextDelegate((IRunnableContext)workbench.getActiveWorkbenchWindow());
        }
        return (fork, cancelable, runnable) -> runnable.run((DBRProgressMonitor)new VoidProgressMonitor());
    }

    public static DBRRunnableContext getDialogRunnableContext() {
        return (fork, cancelable, runnable) -> UIUtils.runInProgressDialog(runnable);
    }

    public static void runInProgressService(DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        UIUtils.getDefaultRunnableContext().run(true, true, runnable);
    }

    public static void runInProgressDialog(DBRRunnableWithProgress runnable) throws InvocationTargetException {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            Object runnableContext = workbenchWindow != null ? new ProgressMonitorDialog(workbench.getActiveWorkbenchWindow().getShell()) : workbench.getProgressService();
            runnableContext.run(true, true, monitor -> runnable.run(RuntimeUtils.makeMonitor((IProgressMonitor)monitor)));
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void runInUI(IRunnableContext context, DBRRunnableWithProgress runnable) {
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI(context, monitor -> runnable.run(RuntimeUtils.makeMonitor((IProgressMonitor)monitor)), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(null, null, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void runInUI(DBRRunnableWithProgress runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchWindow context = window != null ? window : DummyRunnableContext.INSTANCE;
        UIUtils.runInUI((IRunnableContext)context, runnable);
    }

    public static Display getDisplay() {
        try {
            return PlatformUI.getWorkbench().getDisplay();
        }
        catch (Exception exception) {
            return Display.getDefault();
        }
    }

    public static void timerExec(int milliseconds, @NotNull Runnable runnable) {
        try {
            Display display = UIUtils.getDisplay();
            if (!display.isDisposed()) {
                display.timerExec(milliseconds, runnable);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public static void asyncExec(Runnable runnable) {
        try {
            Display display = UIUtils.getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(runnable);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public static void syncExec(Runnable runnable) {
        try {
            Display display = UIUtils.getDisplay();
            if (!display.isDisposed()) {
                display.syncExec(runnable);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public static <T> T syncExec(RunnableWithResult<T> runnable) {
        try {
            UIUtils.getDisplay().syncExec(runnable);
            return (T)runnable.getResult();
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    @Nullable
    public static Color getSharedColor(@Nullable String rgbString) {
        if (CommonUtils.isEmpty((String)rgbString)) {
            return null;
        }
        return SHARED_TEXT_COLORS.getColor(rgbString);
    }

    @Nullable
    public static Color getSharedColor(@Nullable RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return SHARED_TEXT_COLORS.getColor(rgb);
    }

    public static Color getConnectionColor(DBPConnectionConfiguration connectionInfo) {
        String rgbString = connectionInfo.getConnectionColor();
        if (CommonUtils.isEmpty((String)rgbString)) {
            rgbString = connectionInfo.getConnectionType().getColor();
        }
        if (CommonUtils.isEmpty((String)rgbString)) {
            return null;
        }
        return UIUtils.getConnectionColorByRGB(rgbString);
    }

    public static Color getConnectionTypeColor(DBPConnectionType connectionType) {
        String rgbString = connectionType.getColor();
        if (CommonUtils.isEmpty((String)rgbString)) {
            return null;
        }
        return UIUtils.getConnectionColorByRGB(rgbString);
    }

    public static Color getConnectionColorByRGB(String rgbStringOrId) {
        if (rgbStringOrId.isEmpty()) {
            return null;
        }
        if (Character.isAlphabetic(rgbStringOrId.charAt(0))) {
            RGB rgb = UIUtils.getActiveWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().getRGB(rgbStringOrId);
            return SHARED_TEXT_COLORS.getColor(rgb);
        }
        Color connectionColor = SHARED_TEXT_COLORS.getColor(rgbStringOrId);
        if (connectionColor.getBlue() == 255 && connectionColor.getRed() == 255 && connectionColor.getGreen() == 255) {
            return null;
        }
        return connectionColor;
    }

    public static Shell createCenteredShell(Shell parent) {
        Rectangle bounds = parent.getBounds();
        int x = bounds.x + bounds.width / 2 - 120;
        int y = bounds.y + bounds.height / 2 - 170;
        Shell shell = new Shell(parent);
        shell.setBounds(x, y, 0, 0);
        return shell;
    }

    public static void disposeCenteredShell(Shell shell) {
        Composite parentShell = shell.getParent();
        shell.dispose();
        if (parentShell instanceof Shell) {
            ((Shell)parentShell).setActive();
        }
    }

    public static void centerShell(Shell parent, Shell shell) {
        if (parent == null || shell == null) {
            return;
        }
        Point size = shell.computeSize(-1, -1);
        Rectangle parentBounds = parent.getBounds();
        int x = parentBounds.x + (parentBounds.width - size.x) / 2;
        int y = parentBounds.y + (parentBounds.height - size.y) / 2;
        shell.setLocation(x, y);
    }

    public static Image getShardImage(String id) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(id);
    }

    public static ImageDescriptor getShardImageDescriptor(String id) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(id);
    }

    public static void addVariablesToControl(@NotNull Control controlForTip, @NotNull String[] variables, String toolTipPattern) {
        StringContentProposalProvider proposalProvider = new StringContentProposalProvider((String[])Arrays.stream(variables).map(GeneralUtils::variablePattern).toArray(String[]::new));
        UIUtils.setContentProposalToolTip(controlForTip, toolTipPattern, variables);
        ContentAssistUtils.installContentProposal(controlForTip, (IControlContentAdapter)new SmartTextContentAdapter(), proposalProvider);
    }

    public static void setContentProposalToolTip(Control control, String toolTip, String ... variables) {
        control.setToolTipText(UIUtils.getSupportedVariablesTip(toolTip, variables));
    }

    @NotNull
    public static String getSupportedVariablesTip(String toolTip, String ... variables) {
        StringBuilder varsTip = new StringBuilder();
        varsTip.append(toolTip).append(". ").append(UIMessages.pref_page_connections_tool_tip_text_allowed_variables).append(":\n");
        int i = 0;
        while (i < variables.length) {
            String var = variables[i];
            if (i > 0) {
                varsTip.append(",\n");
            }
            varsTip.append("  ").append(GeneralUtils.variablePattern((String)var));
            ++i;
        }
        varsTip.append(".");
        return varsTip.toString();
    }

    public static CoolItem createCoolItem(CoolBar coolBar, Control control) {
        CoolItem item = new CoolItem(coolBar, 0);
        item.setControl(control);
        Point size = control.computeSize(-1, -1);
        Point preferred = item.computeSize(size.x, size.y);
        item.setPreferredSize(preferred);
        return item;
    }

    public static void resizeShell(@NotNull Shell shell) {
        Rectangle displayArea = shell.getDisplay().getClientArea();
        Point shellLocation = shell.getLocation();
        Point shellSize = shell.getSize();
        Point compSize = shell.computeSize(-1, -1, true);
        boolean needsLayout = false;
        if (shellSize.x < compSize.x || shellSize.y < compSize.y) {
            shellSize.x = Math.max(shellSize.x, compSize.x);
            shellSize.y = Math.max(shellSize.y, compSize.y);
            shell.setSize(shellSize);
            needsLayout = true;
        }
        if (shellLocation.x + shellSize.x > displayArea.width || shellLocation.y + shellSize.y > displayArea.height) {
            shellLocation.x = CommonUtils.clamp((int)(displayArea.width - shellSize.x), (int)0, (int)shellLocation.x);
            shellLocation.y = CommonUtils.clamp((int)(displayArea.height - shellSize.y), (int)0, (int)shellLocation.y);
            shell.setLocation(shellLocation.x, shellLocation.y);
            needsLayout = true;
        }
        if (needsLayout) {
            shell.layout(true);
        }
    }

    public static void waitJobCompletion(AbstractJob job) {
        Display display = Display.getCurrent();
        while (!job.isFinished()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.update();
    }

    public static void waitInUI(DBRCondition condition, long waitTime) {
        UIUtils.syncExec(() -> {
            long startTime = System.currentTimeMillis();
            Display display = Display.getCurrent();
            do {
                if (display.readAndDispatch()) continue;
                RuntimeUtils.pause((int)100);
            } while (!condition.isConditionMet() && System.currentTimeMillis() - startTime < waitTime);
            display.update();
        });
    }

    public static void fixReadonlyTextBackground(Text textField) {
    }

    public static ColorRegistry getColorRegistry() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
    }

    public static Color getGlobalColor(String colorName) {
        return UIUtils.getColorRegistry().get(colorName);
    }

    public static Control createEmptyLabel(Composite parent, int horizontalSpan, int verticalSpan) {
        Label emptyLabel = new Label(parent, 0);
        GridData gd = new GridData(128);
        gd.horizontalSpan = horizontalSpan;
        gd.verticalSpan = verticalSpan;
        gd.widthHint = 0;
        emptyLabel.setLayoutData((Object)gd);
        return emptyLabel;
    }

    public static void disposeChildControls(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public static double greyLevel(RGB rgb) {
        if (rgb.red == rgb.green && rgb.green == rgb.blue) {
            return rgb.red;
        }
        return 0.299 * (double)rgb.red + 0.587 * (double)rgb.green + 0.114 * (double)rgb.blue + 0.5;
    }

    public static boolean isDark(RGB rgb) {
        return UIUtils.greyLevel(rgb) < 128.0;
    }

    public static Color getContrastColor(Color color) {
        if (color == null) {
            return COLOR_BLACK;
        }
        double luminance = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        if (luminance > 0.5) {
            return UIStyles.isDarkTheme() ? COLOR_WHITE_DARK : COLOR_WHITE;
        }
        return COLOR_BLACK;
    }

    public static void openWebBrowser(String url) {
        if (!((url = url.trim()).startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://"))) {
            url = "http://" + url;
        }
        Program.launch((String)url);
    }

    public static void setBackgroundForAll(Control control, Color color) {
        if (!(control instanceof Button)) {
            control.setBackground(color);
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control ch = controlArray[n2];
                UIUtils.setBackgroundForAll(ch, color);
                ++n2;
            }
        }
    }

    public static <T extends Control> void addEmptyTextHint(final T control, final DBRValueProvider<String, T> tipProvider) {
        control.addPaintListener(new PaintListener(){
            private Font hintFont;
            {
                this.hintFont = UIUtils.modifyFont(control2.getFont(), 2);
                control2.addDisposeListener(e -> this.hintFont.dispose());
            }

            public void paintControl(PaintEvent e) {
                String tip = (String)tipProvider.getValue((Object)control);
                if (tip != null && UIUtils.isEmptyTextControl(control) && !control.isFocusControl()) {
                    e.gc.setForeground(UIUtils.getDisplay().getSystemColor(18));
                    e.gc.setFont(this.hintFont);
                    e.gc.drawText(tip, 2, 0, true);
                    e.gc.setFont(null);
                }
            }
        });
    }

    private static boolean isEmptyTextControl(Control control) {
        return control instanceof Text && ((Text)control).getCharCount() == 0 || control instanceof StyledText && ((StyledText)control).getCharCount() == 0 || control instanceof Combo && ((Combo)control).getText().isEmpty();
    }

    public static void expandAll(AbstractTreeViewer treeViewer) {
        Control control = treeViewer.getControl();
        control.setRedraw(false);
        try {
            treeViewer.expandAll();
        }
        finally {
            control.setRedraw(true);
        }
    }

    public static Font getMonospaceFont() {
        return JFaceResources.getFont((String)"org.eclipse.jface.textfont");
    }

    public static <T extends Control> T getParentOfType(Control control, Class<T> parentType) {
        while (control != null) {
            if (parentType.isInstance(control)) {
                return (T)((Control)parentType.cast(control));
            }
            control = control.getParent();
        }
        return null;
    }

    public static Object normalizePropertyValue(Object text) {
        if (text instanceof String) {
            return CommonUtils.toString((Object)text).trim();
        }
        return text;
    }

    public static void setControlVisible(Control control, boolean visible) {
        control.setVisible(visible);
        Object gd = control.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).exclude = !visible;
        }
    }

    public static void installMacOSFocusLostSubstitution(@NotNull Widget widget, final @NotNull Runnable onFocusLost) {
        if (!RuntimeUtils.isMacOS()) {
            return;
        }
        if (widget instanceof Combo || widget instanceof CCombo) {
            widget.addListener(13, (Listener)new TypedListener((SWTEventListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    onFocusLost.run();
                }
            }));
        } else {
            widget.addDisposeListener(e -> onFocusLost.run());
        }
    }

    private static /* synthetic */ void lambda$3(Shell shell, String string, String string2, DBPImage dBPImage) {
        Reply reply = MessageBoxBuilder.builder(shell != null ? shell : UIUtils.getActiveWorkbenchShell()).setTitle(string).setMessage(string2).setReplies(Reply.OK).setDefaultReply(Reply.OK).setPrimaryImage(dBPImage).showMessageBox();
    }
}

