/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.registry.ConfirmationDescriptor;

public class ConfirmationRegistry {
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.confirmations";
    private static ConfirmationRegistry instance;
    private final Map<String, ConfirmationDescriptor> confirmations = new HashMap<String, ConfirmationDescriptor>();

    private ConfirmationRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("confirmation".equals(element.getName())) {
                ConfirmationDescriptor descriptor = new ConfirmationDescriptor(element);
                this.confirmations.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
    }

    @NotNull
    public static synchronized ConfirmationRegistry getInstance() {
        if (instance == null) {
            instance = new ConfirmationRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    @NotNull
    public Collection<ConfirmationDescriptor> getConfirmations() {
        return this.confirmations.values();
    }

    public int confirmAction(@Nullable Shell shell, @NotNull String id, int type, Object ... args) {
        ConfirmationDescriptor descriptor = this.confirmations.get(id);
        if (descriptor == null) {
            throw new IllegalArgumentException("Can't find confirmation '" + id + "'");
        }
        return ConfirmationDialog.open(type, type, shell, NLS.bind((String)descriptor.getTitle(), (Object[])args), NLS.bind((String)descriptor.getMessage(), (Object[])args), descriptor.getToggleMessage() != null ? NLS.bind((String)descriptor.getToggleMessage(), (Object[])args) : null, false, "org.jkiss.dbeaver.core.confirm." + id);
    }
}

