/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jkiss.dbeaver.parser.common.ParserFsm;
import org.jkiss.dbeaver.parser.common.ParserFsmNode;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaBuilder;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaOperation;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaTransition;
import org.jkiss.dbeaver.parser.common.grammar.nfa.ParseOperationKind;

class GrammarAnalyzer {
    private final List<GrammarNfaTransition> terminalTransitions;
    private final GrammarNfaBuilder.NfaFragment root;

    public GrammarAnalyzer(List<GrammarNfaTransition> terminalTransitions, GrammarNfaBuilder.NfaFragment root) {
        this.terminalTransitions = terminalTransitions;
        this.root = root;
    }

    public ParserFsm buildTerminalsGraph() {
        int fsmsStatesCount = this.root.getFrom().getNext().size() + this.terminalTransitions.size();
        HashMap<GrammarNfaTransition, ParserFsmNode> states = new HashMap<GrammarNfaTransition, ParserFsmNode>(fsmsStatesCount);
        ArrayList<ParserFsmNode> initialStates = new ArrayList<ParserFsmNode>();
        for (GrammarNfaTransition startTransition : this.root.getFrom().getNext()) {
            ParserFsmNode initialState = new ParserFsmNode(states.size(), false);
            states.put(startTransition, initialState);
            initialStates.add(initialState);
        }
        ParserFsmNode endState = new ParserFsmNode(states.size(), true);
        for (GrammarNfaTransition transition : this.terminalTransitions) {
            states.put(transition, new ParserFsmNode(states.size(), false));
        }
        for (GrammarNfaTransition startTransition : this.root.getFrom().getNext()) {
            this.discoverPathsFrom(states, startTransition);
        }
        for (GrammarNfaTransition transition : this.terminalTransitions) {
            this.discoverPathsFrom(states, transition);
        }
        ArrayList<ParserFsmNode> parseFsmStates = new ArrayList<ParserFsmNode>(states.values());
        parseFsmStates.add(endState);
        return new ParserFsm(initialStates, parseFsmStates);
    }

    private void discoverPathsFrom(Map<GrammarNfaTransition, ParserFsmNode> states, GrammarNfaTransition transition) {
        List<Step> paths = this.findPaths(transition);
        for (Step path : paths) {
            ArrayList<GrammarNfaOperation> ops = new ArrayList<GrammarNfaOperation>();
            for (GrammarNfaTransition step : path) {
                GrammarNfaOperation op = step.getOperation();
                if (op.getKind() == ParseOperationKind.TERM || op.getKind() == ParseOperationKind.NONE) continue;
                ops.add(op);
            }
            Collections.reverse(ops);
            states.get(transition).connectTo(states.get(path.transition), path.transition.getOperation().getPattern(), ops);
        }
    }

    private List<Step> findPaths(GrammarNfaTransition transition) {
        ArrayDeque<Step> stack = new ArrayDeque<Step>();
        stack.push(Step.initial(transition));
        ArrayList<Step> result = new ArrayList<Step>();
        BitSet active = new BitSet();
        while (stack.size() > 0) {
            Step currStep = (Step)stack.pop();
            if (currStep.isUp) {
                active.clear(currStep.transition.getTo().getId());
                continue;
            }
            if (active.get(currStep.transition.getTo().getId())) {
                throw new RuntimeException("recursion hit at " + currStep);
            }
            active.set(currStep.transition.getTo().getId());
            stack.push(currStep.exit(currStep.transition));
            for (GrammarNfaTransition child : currStep.transition.getTo().getNext()) {
                Step next = currStep.enter(child);
                if (child.getTo() == this.root.getTo()) {
                    result.add(next);
                }
                if (child.getOperation().getKind().equals((Object)ParseOperationKind.TERM)) {
                    result.add(next);
                    continue;
                }
                stack.push(next);
            }
        }
        return result;
    }

    private static class Step
    implements Iterable<GrammarNfaTransition> {
        private final Step prev;
        private final boolean isUp;
        private final GrammarNfaTransition transition;

        private Step(Step prev, boolean isUp, GrammarNfaTransition transition) {
            this.prev = prev;
            this.isUp = isUp;
            this.transition = transition;
        }

        public static Step initial(GrammarNfaTransition transition) {
            return new Step(null, false, transition);
        }

        public Step enter(GrammarNfaTransition transition) {
            return new Step(this, false, transition);
        }

        public Step exit(GrammarNfaTransition transition) {
            return new Step(this, true, transition);
        }

        public String toString() {
            ArrayList<String> steps = new ArrayList<String>();
            Step x = this;
            while (x != null) {
                steps.add(x.transition.toString());
                x = x.prev;
            }
            return "Path of " + String.join((CharSequence)", ", steps);
        }

        @Override
        public Iterator<GrammarNfaTransition> iterator() {
            return new Iterator<GrammarNfaTransition>(){
                private Step current;
                {
                    this.current = step;
                }

                @Override
                public GrammarNfaTransition next() {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    GrammarNfaTransition result = this.current.transition;
                    this.current = this.current.prev;
                    return result;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }
            };
        }
    }
}

