/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common.grammar;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.parser.common.grammar.GrammarRule;

public class GrammarInfo {
    private final String name;
    private final String startRuleName;
    private final String skipRuleName;
    private final Map<String, GrammarRule> rules;

    public GrammarInfo(String name, String startRule, String skipRule, Map<String, GrammarRule> rules) {
        this.name = name;
        this.startRuleName = startRule;
        this.skipRuleName = skipRule;
        this.rules = Collections.unmodifiableMap(rules);
    }

    public String getName() {
        return this.name;
    }

    public String getStartRuleName() {
        return this.startRuleName;
    }

    public String getSkipRuleName() {
        return this.skipRuleName;
    }

    public GrammarRule findRule(String name) {
        return this.rules.get(name);
    }

    public Collection<GrammarRule> getRules() {
        return Collections.unmodifiableCollection(this.rules.values());
    }

    public static GrammarInfo ofRules(String name, GrammarRule ... rules) {
        HashMap<String, GrammarRule> rulesByName = new HashMap<String, GrammarRule>();
        GrammarRule[] grammarRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            GrammarRule rule = grammarRuleArray[n2];
            if (rulesByName.containsKey(rule.getName())) {
                throw new RuntimeException("Ambiguity at '" + rule.getName() + "' was met");
            }
            rulesByName.put(rule.getName(), rule);
            ++n2;
        }
        return new GrammarInfo(name, rules.length > 0 ? rules[0].getName() : null, null, rulesByName);
    }
}

