/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common.grammar.nfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jkiss.dbeaver.parser.common.grammar.AlternativeExpression;
import org.jkiss.dbeaver.parser.common.grammar.CharactersExpression;
import org.jkiss.dbeaver.parser.common.grammar.CheckExpression;
import org.jkiss.dbeaver.parser.common.grammar.CheckNotExpression;
import org.jkiss.dbeaver.parser.common.grammar.ExpressionVisitor;
import org.jkiss.dbeaver.parser.common.grammar.GrammarInfo;
import org.jkiss.dbeaver.parser.common.grammar.GrammarRule;
import org.jkiss.dbeaver.parser.common.grammar.NumberExpression;
import org.jkiss.dbeaver.parser.common.grammar.RegexExpression;
import org.jkiss.dbeaver.parser.common.grammar.RuleCallExpression;
import org.jkiss.dbeaver.parser.common.grammar.RuleExpression;
import org.jkiss.dbeaver.parser.common.grammar.SequenceExpression;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfa;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaOperation;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaState;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaTransition;
import org.jkiss.dbeaver.parser.common.grammar.nfa.ParseOperationKind;

public class GrammarNfaBuilder {
    private final GrammarInfo grammar;
    private final GrammarNfa nfa;
    private int exprId = 0;
    private final List<GrammarNfaTransition> terminalTransitions = new ArrayList<GrammarNfaTransition>();

    public GrammarNfaBuilder(GrammarInfo grammar) {
        this.grammar = grammar;
        this.nfa = new GrammarNfa();
    }

    public List<GrammarNfaTransition> getTerminalTransitions() {
        return this.terminalTransitions;
    }

    private int nextExprId() {
        return this.exprId++;
    }

    public NfaFragment traverseGrammar() {
        Collection<GrammarRule> grammarRules = this.grammar.getRules();
        HashMap<GrammarRule, NfaFragment> ruleFragments = new HashMap<GrammarRule, NfaFragment>(grammarRules.size());
        RuleVisitor ruleVisitor = new RuleVisitor();
        for (GrammarRule rule : grammarRules) {
            ruleFragments.put(rule, ruleVisitor.traverseRule(rule));
        }
        GrammarNfaTransition[] grammarNfaTransitionArray = this.nfa.getTransitions().toArray(new GrammarNfaTransition[0]);
        int n = grammarNfaTransitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            GrammarNfaTransition n3 = grammarNfaTransitionArray[n2];
            if (n3.getOperation().getKind() == ParseOperationKind.CALL) {
                this.nfa.removeTransition(n3);
                this.nfa.createTransition(n3.getFrom(), ((NfaFragment)ruleFragments.get(n3.getOperation().getRule())).getFrom(), GrammarNfaOperation.makeEmpty(n3.getOperation().getExprId()));
            }
            if (n3.getOperation().getKind() == ParseOperationKind.RESUME) {
                this.nfa.removeTransition(n3);
                this.nfa.createTransition(((NfaFragment)ruleFragments.get(n3.getOperation().getRule())).getTo(), n3.getTo(), GrammarNfaOperation.makeEmpty(n3.getOperation().getExprId()));
            }
            ++n2;
        }
        return (NfaFragment)ruleFragments.get(this.grammar.findRule(this.grammar.getStartRuleName()));
    }

    public static class NfaFragment {
        private final GrammarNfaState from;
        private final GrammarNfaState to;

        public NfaFragment(GrammarNfaState from, GrammarNfaState to) {
            this.from = from;
            this.to = to;
        }

        public GrammarNfaState getFrom() {
            return this.from;
        }

        public GrammarNfaState getTo() {
            return this.to;
        }
    }

    private class RuleVisitor
    implements ExpressionVisitor<GrammarRule, NfaFragment> {
        private RuleVisitor() {
        }

        private NfaFragment traverseRule(GrammarRule rule) {
            int exprId = GrammarNfaBuilder.this.nextExprId();
            NfaFragment fragment = rule.getExpression().apply(this, rule);
            GrammarNfaState start = GrammarNfaBuilder.this.nfa.createState(rule);
            GrammarNfaState end = GrammarNfaBuilder.this.nfa.createState(rule);
            GrammarNfaBuilder.this.nfa.createTransition(start, fragment.from, GrammarNfaOperation.makeRuleOperation(exprId, ParseOperationKind.RULE_START, rule));
            GrammarNfaBuilder.this.nfa.createTransition(fragment.to, end, GrammarNfaOperation.makeRuleOperation(exprId, ParseOperationKind.RULE_END, rule));
            return new NfaFragment(start, end);
        }

        private NfaFragment visitSkipRuleIfNeeded(GrammarRule rule) {
            if (rule.isUseSkipRule()) {
                GrammarRule skipRule = GrammarNfaBuilder.this.grammar.findRule(GrammarNfaBuilder.this.grammar.getSkipRuleName());
                return this.traverseRule(skipRule);
            }
            GrammarNfaState state = GrammarNfaBuilder.this.nfa.createState(rule);
            return new NfaFragment(state, state);
        }

        @Override
        public NfaFragment visitAlternative(AlternativeExpression alternatives, GrammarRule rule) {
            int exprId = GrammarNfaBuilder.this.nextExprId();
            GrammarNfaState from = GrammarNfaBuilder.this.nfa.createState(rule);
            GrammarNfaState to = GrammarNfaBuilder.this.nfa.createState(rule);
            for (RuleExpression alt : alternatives.children) {
                NfaFragment fragment = alt.apply(this, rule);
                GrammarNfaBuilder.this.nfa.createTransition(from, fragment.from, GrammarNfaOperation.makeEmpty(exprId));
                GrammarNfaBuilder.this.nfa.createTransition(fragment.to, to, GrammarNfaOperation.makeEmpty(exprId));
            }
            return new NfaFragment(from, to);
        }

        @Override
        public NfaFragment visitCharacters(CharactersExpression charactersExpression, GrammarRule rule) {
            int exprId = GrammarNfaBuilder.this.nextExprId();
            NfaFragment head = this.visitSkipRuleIfNeeded(rule);
            GrammarNfaState from = head.to;
            GrammarNfaState to = GrammarNfaBuilder.this.nfa.createState(rule);
            String rawChars = charactersExpression.pattern;
            String lookbehind = Character.isLetterOrDigit(rawChars.charAt(0)) ? "\\b" : "";
            String lookahead = Character.isLetterOrDigit(rawChars.charAt(rawChars.length() - 1)) ? "\\b" : "";
            String pattern = String.valueOf(lookbehind) + RegexExpression.escapeSpecialChars(rawChars) + lookahead;
            if (!rule.isCaseSensitiveTerms()) {
                pattern = "(?i:" + pattern + ")";
            }
            GrammarNfaBuilder.this.terminalTransitions.add(GrammarNfaBuilder.this.nfa.createTransition(from, to, GrammarNfaOperation.makeTerm(exprId, pattern)));
            return new NfaFragment(head.from, to);
        }

        @Override
        public NfaFragment visitCheck(CheckExpression checkExpression, GrammarRule rule) {
            throw new RuntimeException();
        }

        @Override
        public NfaFragment visitCheckNot(CheckNotExpression checkNotExpression, GrammarRule rule) {
            throw new RuntimeException();
        }

        @Override
        public NfaFragment visitSequence(SequenceExpression sequence, GrammarRule rule) {
            int exprId = GrammarNfaBuilder.this.nextExprId();
            GrammarNfaState from = GrammarNfaBuilder.this.nfa.createState(rule);
            GrammarNfaState to = GrammarNfaBuilder.this.nfa.createState(rule);
            int stepsCount = sequence.children.size();
            if (stepsCount > 0) {
                GrammarNfaState prev = from;
                int i = 0;
                while (i < stepsCount) {
                    NfaFragment part = ((RuleExpression)sequence.children.get(i)).apply(this, rule);
                    if (i == 0) {
                        GrammarNfaBuilder.this.nfa.createTransition(prev, part.from, GrammarNfaOperation.makeSequenceOperation(exprId, ParseOperationKind.SEQ_ENTER, 0, stepsCount, 0));
                    } else {
                        GrammarNfaBuilder.this.nfa.createTransition(prev, part.from, GrammarNfaOperation.makeSequenceOperation(exprId, ParseOperationKind.SEQ_STEP, 0, stepsCount, i));
                    }
                    prev = part.to;
                    ++i;
                }
                GrammarNfaBuilder.this.nfa.createTransition(prev, to, GrammarNfaOperation.makeSequenceOperation(exprId, ParseOperationKind.SEQ_EXIT, 0, stepsCount, stepsCount));
            } else {
                GrammarNfaBuilder.this.nfa.createTransition(from, to, GrammarNfaOperation.makeEmpty(exprId));
            }
            return new NfaFragment(from, to);
        }

        @Override
        public NfaFragment visitRuleCall(RuleCallExpression ruleCallExpression, GrammarRule rule) {
            int exprId = GrammarNfaBuilder.this.nextExprId();
            GrammarNfaState from = GrammarNfaBuilder.this.nfa.createState(rule);
            GrammarNfaState to = GrammarNfaBuilder.this.nfa.createState(rule);
            GrammarNfaState call = GrammarNfaBuilder.this.nfa.createState(rule);
            GrammarRule targetRule = GrammarNfaBuilder.this.grammar.findRule(ruleCallExpression.ruleName);
            GrammarNfaBuilder.this.nfa.createTransition(from, call, GrammarNfaOperation.makeRuleOperation(exprId, ParseOperationKind.CALL, targetRule));
            GrammarNfaBuilder.this.nfa.createTransition(call, to, GrammarNfaOperation.makeRuleOperation(exprId, ParseOperationKind.RESUME, targetRule));
            return new NfaFragment(from, to);
        }

        @Override
        public NfaFragment visitNumber(NumberExpression numberExpression, GrammarRule rule) {
            int exprId = GrammarNfaBuilder.this.nextExprId();
            int minNum = numberExpression.min;
            int maxNum = numberExpression.max;
            if (minNum < 0 || maxNum < minNum) {
                throw new IllegalArgumentException("Max loop number can't be 0");
            }
            GrammarNfaState from = GrammarNfaBuilder.this.nfa.createState(rule);
            GrammarNfaState to = GrammarNfaBuilder.this.nfa.createState(rule);
            NfaFragment part = numberExpression.child.apply(this, rule);
            if (maxNum == 1) {
                GrammarNfaBuilder.this.nfa.createTransition(from, part.from, GrammarNfaOperation.makeEmpty(exprId));
                GrammarNfaBuilder.this.nfa.createTransition(part.to, to, GrammarNfaOperation.makeEmpty(exprId));
            } else {
                GrammarNfaBuilder.this.nfa.createTransition(from, part.from, GrammarNfaOperation.makeSequenceOperation(exprId, ParseOperationKind.LOOP_ENTER, minNum, maxNum, null));
                GrammarNfaBuilder.this.nfa.createTransition(part.to, part.from, GrammarNfaOperation.makeSequenceOperation(exprId, ParseOperationKind.LOOP_INCREMENT, minNum, maxNum, null));
                GrammarNfaBuilder.this.nfa.createTransition(part.to, to, GrammarNfaOperation.makeSequenceOperation(exprId, ParseOperationKind.LOOP_EXIT, minNum, maxNum, null));
            }
            if (minNum == 0) {
                GrammarNfaBuilder.this.nfa.createTransition(from, to, GrammarNfaOperation.makeEmpty(exprId));
            }
            return new NfaFragment(from, to);
        }

        @Override
        public NfaFragment visitRegex(RegexExpression regexExpression, GrammarRule rule) {
            int exprId = GrammarNfaBuilder.this.nextExprId();
            NfaFragment head = this.visitSkipRuleIfNeeded(rule);
            GrammarNfaState from = head.to;
            GrammarNfaState to = GrammarNfaBuilder.this.nfa.createState(rule);
            String pattern = regexExpression.pattern;
            if (!rule.isCaseSensitiveTerms()) {
                pattern = "(?i:" + pattern + ")";
            }
            GrammarNfaBuilder.this.terminalTransitions.add(GrammarNfaBuilder.this.nfa.createTransition(from, to, GrammarNfaOperation.makeTerm(exprId, pattern)));
            return new NfaFragment(head.from, to);
        }
    }
}

