/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import org.jkiss.dbeaver.ext.oracle.data.OracleBFILEValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleBLOBValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleCLOBValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleObjectValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleRefCursorValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleTemporalAccessorValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleTimestampValueHandler;
import org.jkiss.dbeaver.ext.oracle.data.OracleXMLValueHandler;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class OracleValueHandlerProvider
implements DBDValueHandlerProvider {
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject typedObject) {
        String typeName;
        switch (typedObject.getTypeID()) {
            case 2004: {
                return OracleBLOBValueHandler.INSTANCE;
            }
            case 2005: 
            case 2011: {
                return OracleCLOBValueHandler.INSTANCE;
            }
            case 101: 
            case 2013: 
            case 2014: {
                if (((OracleDataSource)dataSource).isDriverVersionAtLeast(12, 2)) {
                    return new OracleTemporalAccessorValueHandler(preferences);
                }
                return new OracleTimestampValueHandler(preferences);
            }
            case 2002: {
                return OracleObjectValueHandler.INSTANCE;
            }
            case -10: {
                return OracleRefCursorValueHandler.INSTANCE;
            }
        }
        switch (typeName = typedObject.getTypeName()) {
            case "SYS.XMLTYPE": 
            case "XMLTYPE": {
                return OracleXMLValueHandler.INSTANCE;
            }
            case "BFILE": {
                return OracleBFILEValueHandler.INSTANCE;
            }
            case "REFCURSOR": {
                return OracleRefCursorValueHandler.INSTANCE;
            }
        }
        if (typeName.contains("TIMESTAMP") || typedObject.getDataKind() == DBPDataKind.DATETIME) {
            return new OracleTimestampValueHandler(preferences);
        }
        return null;
    }
}

