/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.editparts;

import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Viewport;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.ExposeHelper;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.editparts.ViewportHelper;

public class ViewportExposeHelper
extends ViewportHelper
implements ExposeHelper {
    private Insets exposeMargin;
    private int minimumFrameCount = 3;
    private int maximumFrameCount = 8;

    public ViewportExposeHelper(GraphicalEditPart owner) {
        super(owner);
    }

    @Override
    public void exposeDescendant(EditPart part) {
        Viewport port = this.findViewport(this.owner);
        if (port == null) {
            return;
        }
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getCopy();
        target.translateToAbsolute((Translatable)exposeRegion);
        if (this.exposeMargin != null) {
            exposeRegion.expand(this.exposeMargin);
        }
        port.getContents().translateToRelative((Translatable)exposeRegion);
        Point offset = port.getContents().getBounds().getLocation();
        exposeRegion.translate(offset.negate());
        exposeRegion.translate(port.getHorizontalRangeModel().getMinimum(), port.getVerticalRangeModel().getMinimum());
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = new Point();
        finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
        finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
        Point startLocation = port.getViewLocation();
        int dx = finalLocation.x - startLocation.x;
        int dy = finalLocation.y - startLocation.y;
        int frames = (Math.abs(dx) + Math.abs(dy)) / 15;
        frames = Math.max(frames, this.getMinimumFrameCount());
        frames = Math.min(frames, this.getMaximumFrameCount());
        int stepX = Math.min(dx / frames, viewportSize.width / 3);
        int stepY = Math.min(dy / frames, viewportSize.height / 3);
        int i = 1;
        while (i < frames) {
            port.setViewLocation(startLocation.x + stepX * i, startLocation.y + stepY * i);
            port.getUpdateManager().performUpdate();
            ++i;
        }
        port.setViewLocation(finalLocation);
    }

    public int getMaximumFrameCount() {
        return this.maximumFrameCount;
    }

    public int getMinimumFrameCount() {
        return this.minimumFrameCount;
    }

    public void setMargin(Insets margin) {
        this.exposeMargin = margin;
    }

    public void setMaximumFrameCount(int maximumFrameCount) {
        this.maximumFrameCount = maximumFrameCount;
    }

    public void setMinimumFrameCount(int minimumFrameCount) {
        this.minimumFrameCount = minimumFrameCount;
        if (this.getMaximumFrameCount() < minimumFrameCount) {
            this.setMaximumFrameCount(minimumFrameCount);
        }
    }
}

