/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.handles;

import org.eclipse.draw2dl.Border;
import org.eclipse.draw2dl.Cursors;
import org.eclipse.draw2dl.LineBorder;
import org.eclipse.draw2dl.Locator;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.handles.AbstractHandle;
import org.eclipse.gef3.handles.MoveHandleLocator;
import org.eclipse.gef3.tools.DragEditPartsTracker;

public class MoveHandle
extends AbstractHandle {
    protected static final int INNER_PAD = 2;

    public MoveHandle(GraphicalEditPart owner) {
        this(owner, new MoveHandleLocator(owner.getFigure()));
    }

    public MoveHandle(GraphicalEditPart owner, Locator loc) {
        super(owner, loc);
        this.initialize();
    }

    @Override
    protected DragTracker createDragTracker() {
        DragEditPartsTracker tracker = new DragEditPartsTracker(this.getOwner());
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        return !Rectangle.SINGLETON.setBounds(this.getBounds()).shrink(2, 2).contains(x, y);
    }

    @Override
    public Point getAccessibleLocation() {
        Point p = this.getBounds().getTopRight().translate(-1, this.getBounds().height / 4);
        this.translateToAbsolute((Translatable)p);
        return p;
    }

    protected void initialize() {
        this.setOpaque(false);
        this.setBorder((Border)new LineBorder(1));
        this.setCursor(Cursors.SIZEALL);
    }
}

