/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.internal.ui.palette.editparts;

import org.eclipse.draw2dl.Border;
import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LayoutManager;
import org.eclipse.draw2dl.MarginBorder;
import org.eclipse.draw2dl.ToolbarLayout;
import org.eclipse.gef3.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef3.internal.ui.palette.editparts.ColumnsLayout;
import org.eclipse.gef3.internal.ui.palette.editparts.PaletteContainerFlowLayout;
import org.eclipse.gef3.palette.PaletteContainer;
import org.eclipse.gef3.ui.palette.editparts.PaletteEditPart;

public class GroupEditPart
extends PaletteEditPart {
    private static final Border SCROLL_PANE_BORDER = new MarginBorder(2, 2, 2, 2);
    private static final Border SCROLL_PANE_LIST_BORDER = new MarginBorder(2, 0, 2, 0);
    private int cachedLayout = -1;

    public GroupEditPart(PaletteContainer group) {
        super(group);
    }

    @Override
    public IFigure createFigure() {
        Figure figure = new Figure();
        figure.setOpaque(true);
        figure.setBackgroundColor(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
        return figure;
    }

    @Override
    protected void refreshVisuals() {
        PaletteContainerFlowLayout manager;
        int layout = this.getLayoutSetting();
        if (this.cachedLayout == layout) {
            return;
        }
        this.cachedLayout = layout;
        if (layout == 1) {
            manager = new ColumnsLayout();
            this.getContentPane().setBorder(SCROLL_PANE_BORDER);
        } else if (layout == 2) {
            PaletteContainerFlowLayout flow = new PaletteContainerFlowLayout();
            flow.setMajorSpacing(0);
            flow.setMinorSpacing(0);
            manager = flow;
            this.getContentPane().setBorder(SCROLL_PANE_BORDER);
        } else {
            manager = new ToolbarLayout();
            this.getContentPane().setBorder(SCROLL_PANE_LIST_BORDER);
        }
        this.getContentPane().setLayoutManager((LayoutManager)manager);
    }
}

