/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class PostgreExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<PostgreDatabase, PostgreSchema> {
    private final List<String> searchPath = new ArrayList<String>();
    private List<String> defaultSearchPath = new ArrayList<String>();
    private String activeUser;
    private long activeSchemaId;
    private boolean isolatedContext;

    public PostgreExecutionContext(@NotNull PostgreDatabase database, String purpose) {
        super((JDBCRemoteInstance)database, purpose);
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)super.getDataSource();
    }

    @Nullable
    public PostgreExecutionContext getContextDefaults() {
        return this;
    }

    @NotNull
    public PostgreDatabase getDefaultCatalog() {
        return (PostgreDatabase)this.getOwnerInstance();
    }

    public PostgreSchema getDefaultSchema() {
        return this.getDefaultCatalog().getSchema(this.activeSchemaId);
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return true;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, PostgreDatabase catalog, PostgreSchema schema) throws DBCException {
        this.setDefaultCatalog(monitor, catalog, schema, false);
    }

    void setDefaultCatalog(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase catalog, @Nullable PostgreSchema schema, boolean force) throws DBCException {
        try {
            catalog.checkInstanceConnection(monitor);
            JDBCRemoteInstance oldInstance = this.getOwnerInstance();
            boolean catalogChanged = false;
            boolean schemaChanged = false;
            if (oldInstance != catalog) {
                if (this.isolatedContext) {
                    this.disconnect();
                    this.setOwnerInstance(catalog);
                    this.connect(monitor, null, null, null, false);
                } else {
                    this.getDataSource().setActiveDatabase(catalog);
                }
                catalogChanged = true;
            }
            if (schema != null) {
                if (catalogChanged && !this.isolatedContext) {
                    PostgreDatabase newInstance = this.getDataSource().getDefaultInstance();
                    PostgreExecutionContext newContext = (PostgreExecutionContext)newInstance.getDefaultContext(false);
                    newContext.changeDefaultSchema(monitor, schema, true, force);
                } else {
                    schemaChanged = this.changeDefaultSchema(monitor, schema, true, force);
                }
            }
            if (catalogChanged || schemaChanged) {
                DBUtils.fireObjectSelectionChange((DBSObject)oldInstance, (DBSObject)catalog);
            }
        }
        catch (DBException e) {
            throw new DBCException("Error changing default database", (Throwable)e);
        }
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, PostgreSchema schema) throws DBCException {
        this.setDefaultCatalog(monitor, schema.getDatabase(), schema, false);
    }

    boolean changeDefaultSchema(DBRProgressMonitor monitor, PostgreSchema schema, boolean reflect, boolean force) throws DBCException {
        if (this.activeSchemaId == schema.getObjectId() && !force) {
            return false;
        }
        if (schema.isExternal()) {
            return false;
        }
        this.setSearchPath(monitor, schema);
        this.setSearchPath(schema.getName());
        PostgreSchema oldActiveSchema = this.getDefaultSchema();
        this.activeSchemaId = schema.getObjectId();
        if (reflect) {
            DBUtils.fireObjectSelectionChange((DBSObject)oldActiveSchema, (DBSObject)schema);
        }
        return true;
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        this.activeSchemaId = 0L;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Read context defaults");){
                DBPConnectionBootstrap bootstrap;
                String bsSchemaName;
                String[] stringArray;
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement stat = session.prepareStatement("SELECT current_schema(),session_user");){
                    Throwable throwable3 = null;
                    stringArray = null;
                    try (JDBCResultSet rs = stat.executeQuery();){
                        if (rs.nextRow()) {
                            String activeSchemaName = JDBCUtils.safeGetString((ResultSet)rs, (int)1);
                            if (!CommonUtils.isEmpty((String)activeSchemaName)) {
                                this.getDefaultCatalog().getSchemas(monitor);
                                PostgreSchema activeSchema = this.getDefaultCatalog().getSchema(monitor, activeSchemaName);
                                if (activeSchema != null) {
                                    this.activeSchemaId = activeSchema.getObjectId();
                                }
                            }
                            this.activeUser = JDBCUtils.safeGetString((ResultSet)rs, (int)2);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
                String searchPathStr = JDBCUtils.queryString((Connection)session, (String)"SHOW search_path", (Object[])new Object[0]);
                this.searchPath.clear();
                if (searchPathStr != null) {
                    stringArray = searchPathStr.split(",");
                    int n = stringArray.length;
                    int stat = 0;
                    while (stat < n) {
                        String str = stringArray[stat];
                        str = str.trim();
                        String spSchema = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)str);
                        if (!this.searchPath.contains(spSchema)) {
                            this.searchPath.add(spSchema);
                        }
                        ++stat;
                    }
                    if (this.activeSchemaId == 0L) {
                        for (String schemaName : this.searchPath) {
                            PostgreSchema activeSchema = this.getDefaultCatalog().getSchema(monitor, schemaName);
                            if (activeSchema == null) continue;
                            this.activeSchemaId = activeSchema.getObjectId();
                            break;
                        }
                    }
                } else {
                    this.searchPath.add("public");
                }
                if (this.defaultSearchPath.isEmpty()) {
                    this.setUserInTheEndOfThePath(this.searchPath);
                    this.defaultSearchPath = new ArrayList<String>(this.searchPath);
                }
                if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bsSchemaName = (bootstrap = this.getBootstrapSettings()).getDefaultSchemaName()))) {
                    this.setSearchPath(monitor, bsSchemaName);
                    PostgreSchema bsSchema = this.getDefaultCatalog().getSchema(monitor, bsSchemaName);
                    if (bsSchema != null) {
                        this.activeSchemaId = bsSchema.getObjectId();
                    }
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
        this.setSessionRole(monitor);
        return true;
    }

    public String getActiveUser() {
        return this.activeUser;
    }

    public List<String> getSearchPath() {
        return this.searchPath;
    }

    List<String> getDefaultSearchPath() {
        return this.defaultSearchPath;
    }

    private void setSearchPath(DBRProgressMonitor monitor, PostgreSchema schema) throws DBCException {
        this.setSearchPath(monitor, schema.getName());
    }

    /*
     * WARNING - void declaration
     */
    private void setSearchPath(DBRProgressMonitor monitor, String defSchemaName) throws DBCException {
        ArrayList<String> newSearchPath = new ArrayList<String>(this.getDefaultSearchPath());
        int schemaIndex = newSearchPath.indexOf(defSchemaName);
        if (schemaIndex > 0) {
            newSearchPath.remove(schemaIndex);
        }
        newSearchPath.add(0, defSchemaName);
        StringBuilder spString = new StringBuilder();
        for (String string : newSearchPath) {
            if (spString.length() > 0) {
                spString.append(",");
            }
            spString.append(DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)string));
        }
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Change search path");){
                DBExecUtils.tryExecuteRecover((Object)session, (DBPDataSource)session.getDataSource(), param -> {
                    try {
                        JDBCUtils.executeSQL((Connection)session, (String)("SET search_path = " + spString), (Object[])new Object[0]);
                    }
                    catch (SQLException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (Throwable throwable2) {
                void var6_12;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var6_12;
            }
        }
        catch (DBException dBException) {
            throw new DBCException("Error setting search path", (Throwable)dBException, (DBCExecutionContext)this);
        }
    }

    private static boolean isUserFirstInPath(List<String> newSearchPath) {
        return !newSearchPath.isEmpty() && newSearchPath.get(0).equals("$user");
    }

    private void setUserInTheEndOfThePath(List<String> searchPath) {
        if (CommonUtils.isEmpty(searchPath)) {
            return;
        }
        if (PostgreExecutionContext.isUserFirstInPath(searchPath)) {
            searchPath.remove(0);
            searchPath.add("$user");
        } else {
            int userIndex = -1;
            int i = 0;
            while (i < searchPath.size()) {
                if (searchPath.get(i).equals("$user")) {
                    userIndex = i;
                    break;
                }
                ++i;
            }
            if (userIndex != -1) {
                searchPath.remove(userIndex);
                searchPath.add("$user");
            }
        }
    }

    private void setSearchPath(String path) {
        this.searchPath.clear();
        this.searchPath.add(path);
        if (!path.equals(this.activeUser)) {
            this.searchPath.add(this.activeUser);
        }
    }

    private void setSessionRole(@NotNull DBRProgressMonitor monitor) throws DBCException {
        String roleName = this.getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-chosen-role@");
        if (CommonUtils.isEmpty((String)roleName)) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active role");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement dbStat = session.createStatement();){
                    String sql = "SET ROLE " + this.getDataSource().getSQLDialect().getQuotedIdentifier(roleName, false, true);
                    dbStat.executeUpdate(sql);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
    }

    public void setIsolatedContext(boolean isolatedContext) {
        this.isolatedContext = isolatedContext;
    }
}

